/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticjob;

import java.lang.reflect.Method;
import org.apache.shardingsphere.elasticjob.infra.listener.ShardingContexts;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ElasticJobExecutorInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final AbstractTag<String> ITEM_TAG = Tags.ofKey((String)"item");
    private static final AbstractTag<String> SHARDING_TOTAL_COUNT_TAG = Tags.ofKey((String)"shardingTotalCount");
    private static final AbstractTag<String> TASK_ID_TAG = Tags.ofKey((String)"taskId");
    private static final AbstractTag<String> SHARDING_ITEM_PARAMETERS_TAG = Tags.ofKey((String)"shardingItemParameters");

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        ShardingContexts shardingContexts = (ShardingContexts)allArguments[1];
        Integer item = (Integer)allArguments[2];
        String operateName = ComponentsDefine.ELASTIC_JOB.getName() + "/" + shardingContexts.getJobName();
        AbstractSpan span = ContextManager.createLocalSpan((String)operateName);
        span.setComponent((Component)ComponentsDefine.ELASTIC_JOB);
        Tags.LOGIC_ENDPOINT.set(span, "{\"logic-span\":true}");
        span.tag(ITEM_TAG, item == null ? "" : String.valueOf(item));
        span.tag(SHARDING_TOTAL_COUNT_TAG, Integer.toString(shardingContexts.getShardingTotalCount()));
        span.tag(TASK_ID_TAG, shardingContexts.getTaskId());
        span.tag(SHARDING_ITEM_PARAMETERS_TAG, shardingContexts.getShardingItemParameters() == null ? "" : shardingContexts.getShardingItemParameters().toString());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

