/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.netty.socketio;

import com.corundumstudio.socketio.SocketIOClient;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class NettySocketIOConnectionInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final AbstractTag<String> FROM_TAG = Tags.ofKey((String)"from");

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        SocketIOClient client = (SocketIOClient)allArguments[0];
        AbstractSpan span = ContextManager.createEntrySpan((String)("SocketIO/" + method.getName()), (ContextCarrier)new ContextCarrier());
        span.setComponent((Component)ComponentsDefine.SOCKET_IO);
        SpanLayer.asHttp((AbstractSpan)span);
        InetSocketAddress remoteAddress = (InetSocketAddress)client.getRemoteAddress();
        String clientAddress = remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
        span.tag(FROM_TAG, clientAddress);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

