/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.network;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.network.Send;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.network.TransportLayers;

public class ByteBufferSend
implements Send {
    private final String destination;
    private final int size;
    protected final ByteBuffer[] buffers;
    private int remaining;
    private boolean pending = false;

    public ByteBufferSend(String destination, ByteBuffer ... buffers) {
        this.destination = destination;
        this.buffers = buffers;
        for (ByteBuffer buffer : buffers) {
            this.remaining += buffer.remaining();
        }
        this.size = this.remaining;
    }

    @Override
    public String destination() {
        return this.destination;
    }

    @Override
    public boolean completed() {
        return this.remaining <= 0 && !this.pending;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        long written = channel.write(this.buffers);
        if (written < 0L) {
            throw new EOFException("Wrote negative bytes to channel. This shouldn't happen.");
        }
        this.remaining = (int)((long)this.remaining - written);
        this.pending = TransportLayers.hasPendingWrites(channel);
        return written;
    }
}

