/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.avro;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.util.Utf8;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class SWServerRPCPlugin
extends RPCPlugin {
    private final String prefix;

    public SWServerRPCPlugin(String prefix) {
        this.prefix = prefix;
    }

    public void serverReceiveRequest(RPCContext context) {
        Map meta = context.requestCallMeta();
        ContextCarrier carrier = new ContextCarrier();
        CarrierItem items = carrier.items();
        while (items.hasNext()) {
            items = items.next();
            ByteBuffer buffer = (ByteBuffer)meta.get(new Utf8(items.getHeadKey()));
            items.setHeadValue(new String(buffer.array(), StandardCharsets.UTF_8));
        }
        String operationName = this.prefix + context.getMessage().getName();
        AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)carrier);
        SpanLayer.asRPCFramework((AbstractSpan)span);
        span.setComponent((Component)ComponentsDefine.AVRO_SERVER);
    }
}

