/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Encodable;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1EncodableVector;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Exception;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1InputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1TaggedObject;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.BERApplicationSpecificParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.BERBitStringParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.BEROctetStringParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.BERSequenceParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.BERSetParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.BERTaggedObjectParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERExternalParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DEROctetStringParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DLApplicationSpecific;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DLBitStringParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DLSequenceParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DLSetParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DLTaggedObjectParser;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DefiniteLengthInputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.InMemoryRepresentable;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.IndefiniteLengthInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;
    private final byte[][] tmpBuffers;

    ASN1StreamParser(InputStream inputStream, int n, byte[][] byArray) {
        this._in = inputStream;
        this._limit = n;
        this.tmpBuffers = byArray;
    }

    public ASN1Encodable readObject() throws IOException {
        int n = this._in.read();
        if (n < 0) {
            return null;
        }
        return this.implParseObject(n);
    }

    ASN1Encodable implParseObject(int n) throws IOException {
        this.set00Check(false);
        int n2 = ASN1InputStream.readTagNumber(this._in, n);
        int n3 = ASN1InputStream.readLength(this._in, this._limit, n2 == 3 || n2 == 4 || n2 == 16 || n2 == 17 || n2 == 8);
        if (n3 < 0) {
            if (0 == (n & 0x20)) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in, this._limit);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(indefiniteLengthInputStream, this._limit, this.tmpBuffers);
            int n4 = n & 0xC0;
            if (0 != n4) {
                if (64 == n4) {
                    return new BERApplicationSpecificParser(n2, aSN1StreamParser);
                }
                return new BERTaggedObjectParser(n4, n2, aSN1StreamParser);
            }
            return aSN1StreamParser.parseImplicitConstructedIL(n2);
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n3, this._limit);
        if (0 == (n & 0xE0)) {
            return this.parseImplicitPrimitive(n2, definiteLengthInputStream);
        }
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(definiteLengthInputStream, definiteLengthInputStream.getLimit(), this.tmpBuffers);
        int n5 = n & 0xC0;
        if (0 != n5) {
            boolean bl;
            boolean bl2 = bl = (n & 0x20) != 0;
            if (64 == n5) {
                return (DLApplicationSpecific)aSN1StreamParser.loadTaggedDL(n5, n2, bl);
            }
            return new DLTaggedObjectParser(n5, n2, bl, aSN1StreamParser);
        }
        return aSN1StreamParser.parseImplicitConstructedDL(n2);
    }

    ASN1Primitive loadTaggedDL(int n, int n2, boolean bl) throws IOException {
        if (!bl) {
            byte[] byArray = ((DefiniteLengthInputStream)this._in).toByteArray();
            return ASN1TaggedObject.createPrimitive(n, n2, byArray);
        }
        ASN1EncodableVector aSN1EncodableVector = this.readVector();
        return ASN1TaggedObject.createConstructedDL(n, n2, aSN1EncodableVector);
    }

    ASN1Primitive loadTaggedIL(int n, int n2) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = this.readVector();
        return ASN1TaggedObject.createConstructedIL(n, n2, aSN1EncodableVector);
    }

    ASN1Encodable parseImplicitConstructedDL(int n) throws IOException {
        switch (n) {
            case 3: {
                return new BERBitStringParser(this);
            }
            case 8: {
                return new DERExternalParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 17: {
                return new DLSetParser(this);
            }
            case 16: {
                return new DLSequenceParser(this);
            }
        }
        throw new ASN1Exception("unknown DL object encountered: 0x" + Integer.toHexString(n));
    }

    ASN1Encodable parseImplicitConstructedIL(int n) throws IOException {
        switch (n) {
            case 3: {
                return new BERBitStringParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 8: {
                return new DERExternalParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(n));
    }

    ASN1Encodable parseImplicitPrimitive(int n, DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        switch (n) {
            case 3: {
                return new DLBitStringParser(definiteLengthInputStream);
            }
            case 8: {
                throw new ASN1Exception("externals must use constructed encoding (see X.690 8.18)");
            }
            case 4: {
                return new DEROctetStringParser(definiteLengthInputStream);
            }
            case 17: {
                throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
            }
            case 16: {
                throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
            }
        }
        try {
            return ASN1InputStream.createPrimitiveDERObject(n, definiteLengthInputStream, this.tmpBuffers);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        int n = this._in.read();
        if (n < 0) {
            return new ASN1EncodableVector(0);
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        do {
            ASN1Encodable aSN1Encodable;
            if ((aSN1Encodable = this.implParseObject(n)) instanceof InMemoryRepresentable) {
                aSN1EncodableVector.add(((InMemoryRepresentable)((Object)aSN1Encodable)).getLoadedObject());
                continue;
            }
            aSN1EncodableVector.add(aSN1Encodable.toASN1Primitive());
        } while ((n = this._in.read()) >= 0);
        return aSN1EncodableVector;
    }

    private void set00Check(boolean bl) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(bl);
        }
    }
}

