/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.Formulas;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.provider.PolarStereographicA;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class ObliqueStereographic
extends NormalizedProjection {
    private static final long serialVersionUID = -1454098847621943639L;
    final double \u03c70;
    final double sin\u03c70;
    final double cos\u03c70;
    private final double c;
    private final double n;
    private final double g;
    private final double h;

    public ObliqueStereographic(OperationMethod method, Parameters parameters) {
        this(ObliqueStereographic.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, Object> roles = new EnumMap<NormalizedProjection.ParameterRole, Object>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.ObliqueStereographic.LONGITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.referencing.operation.provider.ObliqueStereographic.SCALE_FACTOR);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.ObliqueStereographic.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.ObliqueStereographic.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, null);
    }

    private ObliqueStereographic(Initializer initializer) {
        super(initializer, null);
        double \u03c60 = Math.toRadians(initializer.getAndStore(org.apache.sis.referencing.operation.provider.ObliqueStereographic.LATITUDE_OF_ORIGIN));
        double sin\u03c60 = Math.sin(\u03c60);
        double \u212fsin\u03c60 = this.eccentricity * sin\u03c60;
        this.n = Math.sqrt(1.0 + this.eccentricitySquared * Math.pow(Math.cos(\u03c60), 4.0) / (1.0 - this.eccentricitySquared));
        double S1 = (1.0 + sin\u03c60) / (1.0 - sin\u03c60);
        double S2 = (1.0 - \u212fsin\u03c60) / (1.0 + \u212fsin\u03c60);
        double w1 = Math.pow(S1 * Math.pow(S2, this.eccentricity), this.n);
        double sin\u03c71 = (w1 - 1.0) / (w1 + 1.0);
        this.c = (this.n + sin\u03c60) * (1.0 - sin\u03c71) / ((this.n - sin\u03c60) * (1.0 + sin\u03c71));
        double w2 = this.c * w1;
        this.sin\u03c70 = (w2 - 1.0) / (w2 + 1.0);
        this.\u03c70 = Math.asin(this.sin\u03c70);
        this.cos\u03c70 = Math.cos(this.\u03c70);
        this.g = Math.tan(0.7853981633974483 - this.\u03c70 / 2.0);
        this.h = 2.0 * Math.tan(this.\u03c70) + this.g;
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        normalize.convertAfter(0, this.n, null);
        DoubleDouble R2 = initializer.radiusOfConformalSphere(sin\u03c60).scalb(1);
        denormalize.convertBefore(0, (Number)R2, null);
        denormalize.convertBefore(1, (Number)R2, null);
    }

    ObliqueStereographic(ObliqueStereographic other) {
        super(null, other);
        this.\u03c70 = other.\u03c70;
        this.sin\u03c70 = other.sin\u03c70;
        this.cos\u03c70 = other.cos\u03c70;
        this.c = other.c;
        this.n = other.n;
        this.g = other.g;
        this.h = other.h;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"\u03c7\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.\u03c70};
    }

    @Override
    public MathTransform createMapProjection(MathTransformProvider.Context parameters) throws FactoryException {
        Double \u03c60;
        if (Double.isNaN(this.\u03c70) && (\u03c60 = this.context.getValue(org.apache.sis.referencing.operation.provider.ObliqueStereographic.LATITUDE_OF_ORIGIN)) != null && Math.abs(Math.abs(\u03c60) - 90.0) < 8.999280057595393E-8) {
            return PolarStereographicA.provider().createMathTransform(parameters);
        }
        if (this.eccentricity == 0.0) {
            return this.context.completeTransform(parameters.getFactory(), new Spherical(this));
        }
        return this.completeWithWraparound(parameters);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u039b = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        double \u212fsin\u03c6 = this.eccentricity * sin\u03c6;
        double Sa = (1.0 + sin\u03c6) / (1.0 - sin\u03c6);
        double Sb = (1.0 - \u212fsin\u03c6) / (1.0 + \u212fsin\u03c6);
        double w = this.c * Math.pow(Sa * Math.pow(Sb, this.eccentricity), this.n);
        double sin\u03c7 = (w - 1.0) / (w + 1.0);
        double cos\u03c7 = Math.sqrt(1.0 - sin\u03c7 * sin\u03c7);
        double cos\u039b = Math.cos(\u039b);
        double sin\u039b = Math.sin(\u039b);
        double sin\u03c7sin\u03c70 = sin\u03c7 * this.sin\u03c70;
        double cos\u03c7cos\u03c70 = cos\u03c7 * this.cos\u03c70;
        double B = 1.0 + sin\u03c7sin\u03c70 + cos\u03c7cos\u03c70 * cos\u039b;
        if (dstPts != null) {
            dstPts[dstOff] = cos\u03c7 * sin\u039b / B;
            dstPts[dstOff + 1] = (sin\u03c7 * this.cos\u03c70 - cos\u03c7 * this.sin\u03c70 * cos\u039b) / B;
        }
        if (!derivate) {
            return null;
        }
        double cos\u03c6 = Math.cos(\u03c6);
        double d\u03c7_d\u03c6 = (1.0 / cos\u03c6 - cos\u03c6 * this.eccentricitySquared / (1.0 - \u212fsin\u03c6 * \u212fsin\u03c6)) * 2.0 * this.n * Math.sqrt(w) / (w + 1.0);
        double B2 = B * B;
        double d = (cos\u03c7cos\u03c70 + cos\u039b * (sin\u03c7sin\u03c70 + 1.0)) / B2;
        double t = sin\u039b * (sin\u03c7 + this.sin\u03c70) / B2;
        return new Matrix2(d * cos\u03c7, -t * d\u03c7_d\u03c6, t * cos\u03c7, d * d\u03c7_d\u03c6);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double i = Math.atan2(x, this.h + y);
        double j = Math.atan2(x, this.g - y) - i;
        double \u03bb = j + 2.0 * i;
        double sin\u03c7 = Math.sin(this.\u03c70 + 2.0 * Math.atan(y - x * Math.tan(j / 2.0)));
        double \u03c8 = Math.log((1.0 + sin\u03c7) / ((1.0 - sin\u03c7) * this.c)) / (2.0 * this.n);
        double \u03c6 = 2.0 * Math.atan(Math.exp(\u03c8)) - 1.5707963267948966;
        double he = this.eccentricity / 2.0;
        double ome = 1.0 - this.eccentricitySquared;
        for (int it = 0; it < 18; ++it) {
            double \u212fsin\u03c6 = this.eccentricity * Math.sin(\u03c6);
            double \u03c8i = Math.log(Math.tan(\u03c6 / 2.0 + 0.7853981633974483) * Math.pow((1.0 - \u212fsin\u03c6) / (1.0 + \u212fsin\u03c6), he));
            double \u0394\u03c6 = (\u03c8 - \u03c8i) * Math.cos(\u03c6) * (1.0 - \u212fsin\u03c6 * \u212fsin\u03c6) / ome;
            \u03c6 += \u0394\u03c6;
            if (Math.abs(\u0394\u03c6) > 3.926676682852614E-10) continue;
            dstPts[dstOff] = \u03bb;
            dstPts[dstOff + 1] = \u03c6;
            return;
        }
        throw new ProjectionException(Resources.format((short)46));
    }

    static final class Spherical
    extends ObliqueStereographic {
        private static final long serialVersionUID = -1454098847621943639L;

        protected Spherical(ObliqueStereographic other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03bb = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double sin\u03c6 = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double sin\u03bb = Math.sin(\u03bb);
            double cos\u03bb = Math.cos(\u03bb);
            double sin\u03c6sin\u03c60 = sin\u03c6 * this.sin\u03c70;
            double cos\u03c6cos\u03c60 = cos\u03c6 * this.cos\u03c70;
            double cos\u03c6sin\u03bb = cos\u03c6 * sin\u03bb;
            double B = 1.0 + sin\u03c6sin\u03c60 + cos\u03c6cos\u03c60 * cos\u03bb;
            if (dstPts != null) {
                dstPts[dstOff] = cos\u03c6sin\u03bb / B;
                dstPts[dstOff + 1] = (sin\u03c6 * this.cos\u03c70 - cos\u03c6 * this.sin\u03c70 * cos\u03bb) / B;
            }
            if (!derivate) {
                return null;
            }
            double B2 = B * B;
            double d = (cos\u03c6cos\u03c60 + cos\u03bb * (sin\u03c6sin\u03c60 + 1.0)) / B2;
            double t = sin\u03bb * (sin\u03c6 + this.sin\u03c70) / B2;
            return new Matrix2(d * cos\u03c6, -t, t * cos\u03c6, d);
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double \u03c6;
            double \u03bb;
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double \u03c1 = Formulas.fastHypot(x, y);
            if (\u03c1 == 0.0) {
                \u03bb = 0.0;
                \u03c6 = this.\u03c70;
            } else {
                double c = 2.0 * Math.atan(\u03c1);
                double cosc = Math.cos(c);
                double sinc = Math.sin(c);
                \u03bb = Math.atan2(x * sinc, cosc * this.cos\u03c70 * \u03c1 - y * sinc * this.sin\u03c70);
                \u03c6 = Math.asin(cosc * this.sin\u03c70 + y * sinc * this.cos\u03c70 / \u03c1);
            }
            dstPts[dstOff] = \u03bb;
            dstPts[dstOff + 1] = \u03c6;
        }
    }
}

