/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.polaris;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join(isSingleton=false)
public class PolarisInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisInstanceRegisterRepository.class);
    private ConsumerAPI consumerAPI;
    private ProviderAPI providerAPI;
    private String namespace;

    public void init(RegisterConfig config) {
        Configuration configuration = this.buildConfiguration(config);
        SDKContext sdkContext = SDKContext.initContextByConfig((Configuration)configuration);
        this.consumerAPI = DiscoveryAPIFactory.createConsumerAPIByContext((SDKContext)sdkContext);
        this.providerAPI = DiscoveryAPIFactory.createProviderAPIByContext((SDKContext)sdkContext);
        this.namespace = config.getProps().getProperty("namespace", "default");
    }

    private Configuration buildConfiguration(RegisterConfig config) {
        String serverLists = config.getServerLists();
        return ConfigAPIFactory.createConfigurationByAddress((String[])new String[]{serverLists});
    }

    public void persistInstance(InstanceEntity instance) {
        InstanceRegisterRequest req = new InstanceRegisterRequest();
        req.setInstanceId(this.buildInstanceNodeName(instance));
        req.setWeight(Integer.valueOf(1));
        req.setHost(instance.getHost());
        req.setPort(instance.getPort());
        req.setService(instance.getAppName());
        req.setNamespace(this.namespace);
        try {
            this.providerAPI.registerInstance(req);
        }
        catch (PolarisException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    public List<InstanceEntity> selectInstances(String selectKey) {
        ArrayList<InstanceEntity> result = new ArrayList<InstanceEntity>();
        GetHealthyInstancesRequest req = new GetHealthyInstancesRequest();
        req.setService(selectKey);
        req.setNamespace(this.namespace);
        try {
            InstancesResponse response = this.consumerAPI.getHealthyInstances(req);
            ((Stream)Arrays.stream(response.getInstances()).sequential()).forEach(instance -> result.add(this.convertFromInstance((Instance)instance)));
        }
        catch (Exception e) {
            LOGGER.error("getInstanceRegisterDTOS error", (Throwable)e);
        }
        return result;
    }

    private InstanceEntity convertFromInstance(Instance instance) {
        InstanceEntity instanceEntity = new InstanceEntity();
        instanceEntity.setPort(Integer.valueOf(instance.getPort()));
        instanceEntity.setHost(instance.getHost());
        instanceEntity.setAppName(instance.getService());
        instanceEntity.setUri(URI.create(String.format("%s://%s:%s", instance.getProtocol(), instance.getHost(), instance.getPort())));
        return instanceEntity;
    }

    public void close() {
        try {
            this.consumerAPI.close();
            this.providerAPI.close();
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }
}

