/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.attoparser.AbstractChainedMarkupHandler;
import org.attoparser.HtmlNames;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.ParseStatus;
import org.attoparser.config.ParseConfiguration;
import org.attoparser.util.TextUtil;

final class MarkupEventProcessorHandler
extends AbstractChainedMarkupHandler {
    private static final int DEFAULT_STACK_LEN = 10;
    private static final int DEFAULT_ATTRIBUTE_NAMES_LEN = 3;
    private ParseStatus status;
    private boolean useStack;
    private boolean autoOpen;
    private boolean autoClose;
    private boolean requireBalancedElements;
    private boolean requireNoUnmatchedCloseElements;
    private ParseConfiguration.PrologParseConfiguration prologParseConfiguration;
    private ParseConfiguration.UniqueRootElementPresence uniqueRootElementPresence;
    private boolean caseSensitive;
    private boolean requireWellFormedAttributeValues;
    private boolean requireUniqueAttributesInElement;
    private boolean validateProlog;
    private boolean prologPresenceForbidden;
    private boolean xmlDeclarationPresenceForbidden;
    private boolean doctypePresenceForbidden;
    private StructureNamesRepository structureNamesRepository;
    private char[][] elementStack;
    private int elementStackSize;
    private boolean validPrologXmlDeclarationRead = false;
    private boolean validPrologDocTypeRead = false;
    private boolean elementRead = false;
    private char[] rootElementName = null;
    private char[][] currentElementAttributeNames = null;
    private int currentElementAttributeNamesSize = 0;
    private boolean closeElementIsMatched = true;

    MarkupEventProcessorHandler(IMarkupHandler handler) {
        super(handler);
    }

    @Override
    public void setParseStatus(ParseStatus status) {
        this.status = status;
        super.setParseStatus(status);
    }

    @Override
    public void setParseConfiguration(ParseConfiguration parseConfiguration) {
        this.caseSensitive = parseConfiguration.isCaseSensitive();
        this.useStack = ParseConfiguration.ElementBalancing.NO_BALANCING != parseConfiguration.getElementBalancing() || parseConfiguration.isUniqueAttributesInElementRequired() || parseConfiguration.isNoUnmatchedCloseElementsRequired() || ParseConfiguration.UniqueRootElementPresence.NOT_VALIDATED != parseConfiguration.getUniqueRootElementPresence();
        this.autoOpen = ParseConfiguration.ElementBalancing.AUTO_OPEN_CLOSE == parseConfiguration.getElementBalancing();
        this.autoClose = ParseConfiguration.ElementBalancing.AUTO_OPEN_CLOSE == parseConfiguration.getElementBalancing() || ParseConfiguration.ElementBalancing.AUTO_CLOSE == parseConfiguration.getElementBalancing();
        this.requireBalancedElements = ParseConfiguration.ElementBalancing.REQUIRE_BALANCED == parseConfiguration.getElementBalancing();
        this.requireNoUnmatchedCloseElements = this.requireBalancedElements || parseConfiguration.isNoUnmatchedCloseElementsRequired();
        this.prologParseConfiguration = parseConfiguration.getPrologParseConfiguration();
        this.prologParseConfiguration.validateConfiguration();
        this.uniqueRootElementPresence = parseConfiguration.getUniqueRootElementPresence();
        this.requireWellFormedAttributeValues = parseConfiguration.isXmlWellFormedAttributeValuesRequired();
        this.requireUniqueAttributesInElement = parseConfiguration.isUniqueAttributesInElementRequired();
        this.validateProlog = this.prologParseConfiguration.isValidateProlog();
        this.prologPresenceForbidden = this.prologParseConfiguration.getPrologPresence().isForbidden();
        this.xmlDeclarationPresenceForbidden = this.prologParseConfiguration.getXmlDeclarationPresence().isRequired();
        this.doctypePresenceForbidden = this.prologParseConfiguration.getDoctypePresence().isRequired();
        if (this.useStack) {
            this.elementStack = new char[10][];
            this.elementStackSize = 0;
            this.structureNamesRepository = new StructureNamesRepository();
        } else {
            this.elementStack = null;
            this.elementStackSize = 0;
            this.structureNamesRepository = null;
        }
        super.setParseConfiguration(parseConfiguration);
    }

    @Override
    public void handleDocumentEnd(long endTimeNanos, long totalTimeNanos, int line, int col) throws ParseException {
        if (this.requireBalancedElements && this.elementStackSize > 0) {
            char[] popped = this.popFromStack();
            throw new ParseException("Malformed markup: element \"" + new String(popped, 0, popped.length) + "\" is never closed (no closing tag at the end of document)");
        }
        if (!this.elementRead && (this.validPrologDocTypeRead && this.uniqueRootElementPresence.isDependsOnPrologDoctype() || this.uniqueRootElementPresence.isRequiredAlways())) {
            throw new ParseException("Malformed markup: no root element present");
        }
        if (this.useStack) {
            this.cleanStack(line, col);
        }
        this.getNext().handleDocumentEnd(endTimeNanos, totalTimeNanos, line, col);
    }

    @Override
    public void handleXmlDeclaration(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int versionOffset, int versionLen, int versionLine, int versionCol, int encodingOffset, int encodingLen, int encodingLine, int encodingCol, int standaloneOffset, int standaloneLen, int standaloneLine, int standaloneCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        if (this.validateProlog && (this.prologPresenceForbidden || this.xmlDeclarationPresenceForbidden)) {
            throw new ParseException("An XML Declaration has been found, but it wasn't allowed", line, col);
        }
        if (this.validateProlog) {
            if (this.validPrologXmlDeclarationRead) {
                throw new ParseException("Malformed markup: Only one XML Declaration can appear in document", line, col);
            }
            if (this.validPrologDocTypeRead) {
                throw new ParseException("Malformed markup: XML Declaration must appear before DOCTYPE", line, col);
            }
            if (this.elementRead) {
                throw new ParseException("Malformed markup: XML Declaration must appear before any elements in document", line, col);
            }
        }
        if (this.validateProlog) {
            this.validPrologXmlDeclarationRead = true;
        }
        this.getNext().handleXmlDeclaration(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, versionOffset, versionLen, versionLine, versionCol, encodingOffset, encodingLen, encodingLine, encodingCol, standaloneOffset, standaloneLen, standaloneLine, standaloneCol, outerOffset, outerLen, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        if (this.useStack) {
            if (this.elementStackSize == 0) {
                this.checkValidRootElement(buffer, nameOffset, nameLen, line, col);
            }
            if (this.requireUniqueAttributesInElement) {
                this.currentElementAttributeNames = null;
                this.currentElementAttributeNamesSize = 0;
            }
        }
        this.status.autoOpenCloseDone = false;
        this.status.autoOpenParents = null;
        this.status.autoOpenLimits = null;
        this.status.autoCloseRequired = null;
        this.status.autoCloseLimits = null;
        this.status.avoidStacking = true;
        this.getNext().handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
        if (this.useStack) {
            if (this.status.autoOpenParents != null || this.status.autoCloseRequired != null) {
                if (this.status.autoCloseRequired != null) {
                    this.autoClose(this.status.autoCloseRequired, this.status.autoCloseLimits, line, col);
                }
                if (this.status.autoOpenParents != null) {
                    this.autoOpen(this.status.autoOpenParents, this.status.autoOpenLimits, line, col);
                }
                this.status.autoOpenCloseDone = true;
                this.getNext().handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
            }
            if (!this.status.avoidStacking) {
                this.pushToStack(buffer, nameOffset, nameLen);
            }
        } else if (this.status.autoOpenParents != null || this.status.autoCloseRequired != null) {
            this.status.autoOpenCloseDone = true;
            this.getNext().handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
        }
        this.status.autoOpenCloseDone = true;
    }

    @Override
    public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        this.elementRead = true;
        this.getNext().handleStandaloneElementEnd(buffer, nameOffset, nameLen, minimized, line, col);
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        if (this.useStack) {
            if (this.elementStackSize == 0) {
                this.checkValidRootElement(buffer, nameOffset, nameLen, line, col);
            }
            if (this.requireUniqueAttributesInElement) {
                this.currentElementAttributeNames = null;
                this.currentElementAttributeNamesSize = 0;
            }
        }
        this.status.autoOpenCloseDone = false;
        this.status.autoOpenParents = null;
        this.status.autoOpenLimits = null;
        this.status.autoCloseRequired = null;
        this.status.autoCloseLimits = null;
        this.status.avoidStacking = false;
        this.getNext().handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
        if (this.useStack) {
            if (this.status.autoOpenParents != null || this.status.autoCloseRequired != null) {
                if (this.status.autoCloseRequired != null) {
                    this.autoClose(this.status.autoCloseRequired, this.status.autoCloseLimits, line, col);
                }
                if (this.status.autoOpenParents != null) {
                    this.autoOpen(this.status.autoOpenParents, this.status.autoOpenLimits, line, col);
                }
                this.status.autoOpenCloseDone = true;
                this.getNext().handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
            }
            if (!this.status.avoidStacking) {
                this.pushToStack(buffer, nameOffset, nameLen);
            }
        } else if (this.status.autoOpenParents != null || this.status.autoCloseRequired != null) {
            this.status.autoOpenCloseDone = true;
            this.getNext().handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
        }
    }

    @Override
    public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.elementRead = true;
        this.getNext().handleOpenElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleAutoOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        throw new IllegalStateException("handleAutoOpenElementStart should never be called on MarkupEventProcessor, as these events should originate in this class");
    }

    @Override
    public void handleAutoOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        throw new IllegalStateException("handleAutoOpenElementEnd should never be called on MarkupEventProcessor, as these events should originate in this class");
    }

    @Override
    public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        if (this.useStack) {
            this.closeElementIsMatched = this.checkStackForElement(buffer, nameOffset, nameLen, line, col);
            if (this.requireUniqueAttributesInElement) {
                this.currentElementAttributeNames = null;
                this.currentElementAttributeNamesSize = 0;
            }
            if (this.closeElementIsMatched) {
                this.getNext().handleCloseElementStart(buffer, nameOffset, nameLen, line, col);
                return;
            }
            this.getNext().handleUnmatchedCloseElementStart(buffer, nameOffset, nameLen, line, col);
            return;
        }
        this.getNext().handleCloseElementStart(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.elementRead = true;
        if (this.useStack && !this.closeElementIsMatched) {
            this.getNext().handleUnmatchedCloseElementEnd(buffer, nameOffset, nameLen, line, col);
            return;
        }
        this.getNext().handleCloseElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleAutoCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        throw new IllegalStateException("handleAutoCloseElementStart should never be called on MarkupEventProcessor, as these events should originate in this class");
    }

    @Override
    public void handleAutoCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        throw new IllegalStateException("handleAutoCloseElementEnd should never be called on MarkupEventProcessor, as these events should originate in this class");
    }

    @Override
    public void handleUnmatchedCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        throw new IllegalStateException("handleUnmatchedCloseElementStart should never be called on MarkupEventProcessor, as these events should originate in this class");
    }

    @Override
    public void handleUnmatchedCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        throw new IllegalStateException("handleUnmatchedCloseElementEnd should never be called on MarkupEventProcessor, as these events should originate in this class");
    }

    @Override
    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws ParseException {
        if (this.useStack && this.requireUniqueAttributesInElement) {
            if (this.currentElementAttributeNames == null) {
                this.currentElementAttributeNames = new char[3][];
            }
            for (int i = 0; i < this.currentElementAttributeNamesSize; ++i) {
                if (!TextUtil.equals(this.caseSensitive, this.currentElementAttributeNames[i], 0, this.currentElementAttributeNames[i].length, buffer, nameOffset, nameLen)) continue;
                throw new ParseException("Malformed markup: Attribute \"" + new String(buffer, nameOffset, nameLen) + "\" appears more than once in element", nameLine, nameCol);
            }
            if (this.currentElementAttributeNamesSize == this.currentElementAttributeNames.length) {
                char[][] newCurrentElementAttributeNames = new char[this.currentElementAttributeNames.length + 3][];
                System.arraycopy(this.currentElementAttributeNames, 0, newCurrentElementAttributeNames, 0, this.currentElementAttributeNames.length);
                this.currentElementAttributeNames = newCurrentElementAttributeNames;
            }
            this.currentElementAttributeNames[this.currentElementAttributeNamesSize] = this.structureNamesRepository.getStructureName(buffer, nameOffset, nameLen);
            ++this.currentElementAttributeNamesSize;
        }
        if (this.requireWellFormedAttributeValues) {
            if (operatorLen == 0) {
                throw new ParseException("Malformed markup: Attribute \"" + new String(buffer, nameOffset, nameLen) + "\" must include an equals (=) sign and a value surrounded by quotes", operatorLine, operatorCol);
            }
            if (valueOuterLen == 0 || valueOuterLen == valueContentLen) {
                throw new ParseException("Malformed markup: Value for attribute \"" + new String(buffer, nameOffset, nameLen) + "\" must be surrounded by quotes", valueLine, valueCol);
            }
        }
        this.getNext().handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
    }

    @Override
    public void handleDocType(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int elementNameOffset, int elementNameLen, int elementNameLine, int elementNameCol, int typeOffset, int typeLen, int typeLine, int typeCol, int publicIdOffset, int publicIdLen, int publicIdLine, int publicIdCol, int systemIdOffset, int systemIdLen, int systemIdLine, int systemIdCol, int internalSubsetOffset, int internalSubsetLen, int internalSubsetLine, int internalSubsetCol, int outerOffset, int outerLen, int outerLine, int outerCol) throws ParseException {
        if (this.validateProlog) {
            if (this.prologPresenceForbidden || this.doctypePresenceForbidden) {
                throw new ParseException("A DOCTYPE clause has been found, but it wasn't allowed", outerLine, outerCol);
            }
            if (this.validPrologDocTypeRead) {
                throw new ParseException("Malformed markup: Only one DOCTYPE clause can appear in document", outerLine, outerCol);
            }
            if (this.elementRead) {
                throw new ParseException("Malformed markup: DOCTYPE must appear before any elements in document", outerLine, outerCol);
            }
            if (this.prologParseConfiguration.isRequireDoctypeKeywordsUpperCase()) {
                int i;
                int maxi;
                if (keywordLen > 0) {
                    maxi = keywordOffset + keywordLen;
                    for (i = keywordOffset; i < maxi; ++i) {
                        if (!Character.isLowerCase(buffer[i])) continue;
                        throw new ParseException("Malformed markup: DOCTYPE requires upper-case keywords (\"" + new String(buffer, keywordOffset, keywordLen) + "\" was found)", outerLine, outerCol);
                    }
                }
                if (typeLen > 0) {
                    maxi = typeOffset + typeLen;
                    for (i = typeOffset; i < maxi; ++i) {
                        if (!Character.isLowerCase(buffer[i])) continue;
                        throw new ParseException("Malformed markup: DOCTYPE requires upper-case keywords (\"" + new String(buffer, typeOffset, typeLen) + "\" was found)", outerLine, outerCol);
                    }
                }
            }
        }
        if (this.useStack) {
            this.rootElementName = this.structureNamesRepository.getStructureName(buffer, elementNameOffset, elementNameLen);
        }
        if (this.validateProlog) {
            this.validPrologDocTypeRead = true;
        }
        this.getNext().handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, publicIdOffset, publicIdLen, publicIdLine, publicIdCol, systemIdOffset, systemIdLen, systemIdLine, systemIdCol, internalSubsetOffset, internalSubsetLen, internalSubsetLine, internalSubsetCol, outerOffset, outerLen, outerLine, outerCol);
    }

    private void checkValidRootElement(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        if (!this.validateProlog) {
            if (this.elementRead && this.uniqueRootElementPresence.isRequiredAlways()) {
                throw new ParseException("Malformed markup: Only one root element is allowed", line, col);
            }
            return;
        }
        if (this.validPrologDocTypeRead) {
            if (this.elementRead) {
                throw new ParseException("Malformed markup: Only one root element (with name \"" + new String(this.rootElementName) + "\" is allowed", line, col);
            }
            if (!TextUtil.equals(this.caseSensitive, this.rootElementName, 0, this.rootElementName.length, buffer, offset, len)) {
                throw new ParseException("Malformed markup: Root element should be \"" + new String(this.rootElementName) + "\", but \"" + new String(buffer, offset, len) + "\" has been found", line, col);
            }
        }
    }

    private boolean checkStackForElement(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        int peekDelta = 0;
        char[] peek = this.peekFromStack(peekDelta);
        while (peek != null) {
            if (TextUtil.equals(this.caseSensitive, peek, 0, peek.length, buffer, offset, len)) {
                for (int i = 0; i < peekDelta; ++i) {
                    peek = this.popFromStack();
                    if (!this.autoClose) {
                        throw new ParseException("Malformed markup: element \"" + new String(peek, 0, peek.length) + "\" is never closed", line, col);
                    }
                    this.getNext().handleAutoCloseElementStart(peek, 0, peek.length, line, col);
                    this.getNext().handleAutoCloseElementEnd(peek, 0, peek.length, line, col);
                }
                this.popFromStack();
                return true;
            }
            if (this.requireBalancedElements) {
                throw new ParseException("Malformed markup: element \"" + new String(peek, 0, peek.length) + "\" is never closed", line, col);
            }
            peek = this.peekFromStack(++peekDelta);
        }
        if (this.requireNoUnmatchedCloseElements) {
            throw new ParseException("Malformed markup: closing element \"" + new String(buffer, offset, len) + "\" is never open", line, col);
        }
        return false;
    }

    private void cleanStack(int line, int col) throws ParseException {
        if (this.elementStackSize > 0) {
            char[] popped = this.popFromStack();
            while (popped != null) {
                if (!this.autoClose) {
                    throw new ParseException("Malformed markup: element \"" + new String(popped, 0, popped.length) + "\" is never closed", line, col);
                }
                this.getNext().handleAutoCloseElementStart(popped, 0, popped.length, line, col);
                this.getNext().handleAutoCloseElementEnd(popped, 0, popped.length, line, col);
                popped = this.popFromStack();
            }
        }
    }

    private void autoClose(char[][] autoCloseElements, char[][] autoCloseLimits, int line, int col) throws ParseException {
        int n;
        int peekDelta = 0;
        int unstackCount = 0;
        char[] peek = this.peekFromStack(peekDelta);
        while (peek != null) {
            int i;
            if (autoCloseLimits != null) {
                i = 0;
                n = autoCloseLimits.length;
                while (n-- != 0) {
                    if (TextUtil.equals(this.caseSensitive, autoCloseLimits[i], peek)) {
                        peek = null;
                        break;
                    }
                    ++i;
                }
            }
            if (peek == null) continue;
            i = 0;
            n = autoCloseElements.length;
            while (n-- != 0) {
                if (TextUtil.equals(this.caseSensitive, autoCloseElements[i], peek)) {
                    unstackCount = peekDelta + 1;
                    break;
                }
                ++i;
            }
            peek = this.peekFromStack(++peekDelta);
        }
        n = unstackCount;
        while (n-- != 0) {
            peek = this.popFromStack();
            if (this.requireBalancedElements) {
                throw new ParseException("Malformed markup: element \"" + new String(peek, 0, peek.length) + "\" is not closed where it should be", line, col);
            }
            if (!this.autoClose) continue;
            this.getNext().handleAutoCloseElementStart(peek, 0, peek.length, line, col);
            this.getNext().handleAutoCloseElementEnd(peek, 0, peek.length, line, col);
        }
    }

    private void autoOpen(char[][] autoOpenParents, char[][] autoOpenLimits, int line, int col) throws ParseException {
        int i;
        int n;
        char[] peek;
        if (!this.autoOpen) {
            return;
        }
        int parentInsertCount = 0;
        if (autoOpenLimits == null) {
            if (this.elementStackSize >= autoOpenParents.length) {
                return;
            }
            peek = this.peekFromStack(0);
            if (peek == null) {
                parentInsertCount = autoOpenParents.length;
            } else {
                n = autoOpenParents.length;
                while (peek != null && n-- != 0) {
                    if (!TextUtil.equals(this.caseSensitive, autoOpenParents[n], peek)) continue;
                    parentInsertCount = autoOpenParents.length - n - 1;
                    break;
                }
            }
            if (parentInsertCount == 0) {
                return;
            }
        } else {
            peek = this.peekFromStack(0);
            if (peek != null) {
                i = 0;
                n = autoOpenLimits.length;
                while (n-- != 0) {
                    if (TextUtil.equals(this.caseSensitive, autoOpenLimits[i], peek)) {
                        return;
                    }
                    ++i;
                }
            }
            parentInsertCount = autoOpenParents.length;
        }
        n = parentInsertCount;
        i = autoOpenParents.length - parentInsertCount;
        while (n-- != 0) {
            this.getNext().handleAutoOpenElementStart(autoOpenParents[i], 0, autoOpenParents[i].length, line, col);
            this.getNext().handleAutoOpenElementEnd(autoOpenParents[i], 0, autoOpenParents[i].length, line, col);
            this.pushToStack(autoOpenParents[i], 0, autoOpenParents[i].length);
            ++i;
        }
    }

    private void pushToStack(char[] buffer, int offset, int len) {
        if (this.elementStackSize == this.elementStack.length) {
            this.growStack();
        }
        this.elementStack[this.elementStackSize] = this.structureNamesRepository.getStructureName(buffer, offset, len);
        ++this.elementStackSize;
    }

    private char[] peekFromStack(int delta) {
        if (this.elementStackSize <= delta) {
            return null;
        }
        return this.elementStack[this.elementStackSize - 1 - delta];
    }

    private char[] popFromStack() {
        if (this.elementStackSize == 0) {
            return null;
        }
        char[] popped = this.elementStack[this.elementStackSize - 1];
        this.elementStack[this.elementStackSize - 1] = null;
        --this.elementStackSize;
        return popped;
    }

    private void growStack() {
        int newStackLen = this.elementStack.length + 10;
        char[][] newStack = new char[newStackLen][];
        System.arraycopy(this.elementStack, 0, newStack, 0, this.elementStack.length);
        this.elementStack = newStack;
    }

    static final class StandardNamesRepository {
        private static final char[][] REPOSITORY;

        static char[] getStructureName(char[] text, int offset, int len) {
            int index = TextUtil.binarySearch(true, REPOSITORY, text, offset, len);
            if (index < 0) {
                char[] structureName = new char[len];
                System.arraycopy(text, offset, structureName, 0, len);
                return structureName;
            }
            return REPOSITORY[index];
        }

        private StandardNamesRepository() {
        }

        static {
            ArrayList<String> names = new ArrayList<String>(150);
            names.addAll(HtmlNames.ALL_STANDARD_ELEMENT_NAMES);
            for (String name : HtmlNames.ALL_STANDARD_ELEMENT_NAMES) {
                names.add(name.toUpperCase());
            }
            names.addAll(HtmlNames.ALL_STANDARD_ATTRIBUTE_NAMES);
            for (String name : HtmlNames.ALL_STANDARD_ATTRIBUTE_NAMES) {
                names.add(name.toUpperCase());
            }
            Collections.sort(names);
            REPOSITORY = new char[names.size()][];
            for (int i = 0; i < names.size(); ++i) {
                String name;
                name = (String)names.get(i);
                StandardNamesRepository.REPOSITORY[i] = name.toCharArray();
            }
        }
    }

    static final class StructureNamesRepository {
        private static final int REPOSITORY_INITIAL_LEN = 100;
        private static final int REPOSITORY_INITIAL_INC = 20;
        private char[][] repository = new char[100][];
        private int repositorySize = 0;

        StructureNamesRepository() {
        }

        char[] getStructureName(char[] text, int offset, int len) {
            int index = TextUtil.binarySearch(true, this.repository, 0, this.repositorySize, text, offset, len);
            if (index >= 0) {
                return this.repository[index];
            }
            return this.storeStructureName(index, text, offset, len);
        }

        private char[] storeStructureName(int index, char[] text, int offset, int len) {
            if (this.repositorySize == this.repository.length) {
                char[][] newRepository = new char[this.repository.length + 20][];
                Arrays.fill((Object[])newRepository, null);
                System.arraycopy(this.repository, 0, newRepository, 0, this.repositorySize);
                this.repository = newRepository;
            }
            int insertionIndex = (index + 1) * -1;
            char[] structureName = StandardNamesRepository.getStructureName(text, offset, len);
            System.arraycopy(this.repository, insertionIndex, this.repository, insertionIndex + 1, this.repositorySize - insertionIndex);
            this.repository[insertionIndex] = structureName;
            ++this.repositorySize;
            return structureName;
        }
    }
}

