/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register;

import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.utils.PortUtils;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class ClientRegisterConfigImpl
implements ClientRegisterConfig {
    private final Properties props;
    private Integer port;
    private String host;
    private String appName;
    private final Environment env;
    private final ApplicationContext applicationContext;
    private final RpcTypeEnum rpcTypeEnum;

    public ClientRegisterConfigImpl(ShenyuClientConfig shenyuClientConfig, RpcTypeEnum rpcTypeEnum, ApplicationContext applicationContext, Environment env) {
        this.props = ((ShenyuClientConfig.ClientPropertiesConfig)shenyuClientConfig.getClient().get(rpcTypeEnum.getName())).getProps();
        this.applicationContext = applicationContext;
        this.rpcTypeEnum = rpcTypeEnum;
        this.env = env;
    }

    @Override
    public Integer getPort() {
        if (Objects.isNull(this.port)) {
            this.port = Optional.ofNullable(this.props.getProperty("port")).map(Integer::parseInt).orElseGet(() -> PortUtils.findPort((BeanFactory)this.applicationContext.getAutowireCapableBeanFactory()));
        }
        return this.port;
    }

    @Override
    public String getHost() {
        if (Objects.isNull(this.host)) {
            this.host = this.props.getProperty("host");
            this.host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        }
        return this.host;
    }

    @Override
    public String getAppName() {
        if (Objects.isNull(this.appName)) {
            this.appName = Optional.ofNullable(this.props.getProperty("appName")).orElseGet(() -> this.env.getProperty("spring.application.name"));
        }
        return this.appName;
    }

    @Override
    public String getContextPath() {
        return Optional.ofNullable(this.props.getProperty("contextPath")).map(UriUtils::repairData).orElse("");
    }

    @Override
    public String getIpAndPort() {
        return this.props.getProperty("ipAndPort");
    }

    @Override
    public Boolean getAddPrefixed() {
        return Optional.ofNullable(this.props.getProperty("addPrefixed")).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    public RpcTypeEnum getRpcTypeEnum() {
        return this.rpcTypeEnum;
    }
}

