/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.selector;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.BatchChangedEvent;
import org.apache.shenyu.common.utils.ListUtil;

public class BatchSelectorDeletedEvent
extends BatchChangedEvent {
    private final List<String> deletedIds;
    private final List<PluginDO> plugins;
    private final Map<String, PluginDO> pluginMap;
    private final Map<String, SelectorDO> selectorDataMap;

    public BatchSelectorDeletedEvent(Collection<SelectorDO> source, String operator, List<PluginDO> plugins) {
        super(source, null, EventTypeEnum.SELECTOR_DELETE, operator);
        this.deletedIds = ListUtil.map(source, BaseDO::getId);
        this.plugins = plugins;
        this.pluginMap = ListUtil.toMap(plugins, BaseDO::getId);
        this.selectorDataMap = ListUtil.toMap(source, BaseDO::getId);
    }

    @Override
    public String buildContext() {
        String selector = ((Collection)this.getSource()).stream().map(s -> ((SelectorDO)s).getSelectorName()).collect(Collectors.joining(","));
        String namespaceId = ((Collection)this.getSource()).stream().filter(s -> StringUtils.isNotEmpty((CharSequence)((SelectorDO)s).getNamespaceId())).map(s -> ((SelectorDO)s).getNamespaceId()).findAny().orElse("649330b6-c2d7-4edc-be8e-8a54df9eb385");
        return String.format("the namespace [%s] selector[%s] is %s", namespaceId, selector, StringUtils.lowerCase((String)this.getType().getType().toString()));
    }

    public List<SelectorDO> getSelectors() {
        return ((Collection)this.getSource()).stream().map(SelectorDO.class::cast).collect(Collectors.toList());
    }

    public PluginDO findPluginBySelectorId(String selectorId) {
        return Optional.ofNullable(this.selectorDataMap.get(selectorId)).flatMap(selectorDO -> Optional.ofNullable(this.pluginMap.get(selectorDO.getPluginId()))).orElse(null);
    }

    public List<PluginDO> getPlugins() {
        return this.plugins;
    }

    public List<String> getDeletedIds() {
        return this.deletedIds;
    }
}

