/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.sharding.strategy.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.strategy.JobShardingStrategy;

public final class AverageAllocationJobShardingStrategy
implements JobShardingStrategy {
    @Override
    public Map<JobInstance, List<Integer>> sharding(List<JobInstance> jobInstances, String jobName, int shardingTotalCount) {
        if (jobInstances.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<JobInstance, List<Integer>> result = this.shardingAliquot(jobInstances, shardingTotalCount);
        this.addAliquant(jobInstances, shardingTotalCount, result);
        return result;
    }

    private Map<JobInstance, List<Integer>> shardingAliquot(List<JobInstance> shardingUnits, int shardingTotalCount) {
        LinkedHashMap<JobInstance, List<Integer>> result = new LinkedHashMap<JobInstance, List<Integer>>(shardingUnits.size(), 1.0f);
        int itemCountPerSharding = shardingTotalCount / shardingUnits.size();
        int count = 0;
        for (JobInstance each : shardingUnits) {
            ArrayList<Integer> shardingItems = new ArrayList<Integer>(itemCountPerSharding + 1);
            for (int i = count * itemCountPerSharding; i < (count + 1) * itemCountPerSharding; ++i) {
                shardingItems.add(i);
            }
            result.put(each, shardingItems);
            ++count;
        }
        return result;
    }

    private void addAliquant(List<JobInstance> shardingUnits, int shardingTotalCount, Map<JobInstance, List<Integer>> shardingResults) {
        int aliquant = shardingTotalCount % shardingUnits.size();
        int count = 0;
        for (Map.Entry<JobInstance, List<Integer>> entry : shardingResults.entrySet()) {
            if (count < aliquant) {
                entry.getValue().add(shardingTotalCount / shardingUnits.size() * shardingUnits.size() + count);
            }
            ++count;
        }
    }

    public String getType() {
        return "AVG_ALLOCATION";
    }

    public boolean isDefault() {
        return true;
    }
}

