/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;

public class ClientRestArgsFilter
implements HttpClientFilter {
    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public boolean enabledForTransport(String transport) {
        return HttpClientFilter.super.enabledForTransport(transport) || "websocket".equals(transport);
    }

    @Override
    public CompletableFuture<Void> beforeSendRequestAsync(Invocation invocation, HttpServletRequestEx requestEx) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        RestClientRequest restClientRequest = (RestClientRequest)invocation.getHandlerContext().get("servicecomb-invocation-hanlder-requestclient");
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        try {
            RestCodec.argsToRest(invocation.getSwaggerArguments(), swaggerRestOperation, restClientRequest);
            requestEx.setBodyBuffer(restClientRequest.getBodyBuffer());
            result.complete(null);
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public Response afterReceiveResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        return null;
    }
}

