/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.netcdfParser;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import ucar.unidata.io.RandomAccessFile;

public class HDFSRandomAccessFile
extends RandomAccessFile {
    protected URI fsURI;
    protected Path filePath;
    protected FSDataInputStream hfile;
    protected FileStatus fileStatus;

    public HDFSRandomAccessFile(String fileSystemURI, String location) throws IOException {
        this(fileSystemURI, location, 8092);
    }

    public HDFSRandomAccessFile(String fileSystemURI, String location, int bufferSize) throws IOException {
        super(bufferSize);
        this.fsURI = URI.create(fileSystemURI);
        this.filePath = new Path(location);
        this.location = location;
        if (RandomAccessFile.debugLeaks) {
            RandomAccessFile.openFiles.add(location);
        }
        FileSystem fs = FileSystem.get((URI)this.fsURI, (Configuration)new Configuration());
        this.hfile = fs.open(this.filePath);
        this.fileStatus = fs.getFileStatus(this.filePath);
    }

    public void flush() {
    }

    public synchronized void close() throws IOException {
        super.close();
        this.hfile.close();
    }

    public long getLastModified() {
        return this.fileStatus.getModificationTime();
    }

    public long length() throws IOException {
        return this.fileStatus.getLen();
    }

    protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
        int n = this.hfile.read(pos, b, offset, len);
        return n;
    }

    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        long need;
        byte[] buf = new byte[4096];
        this.hfile.seek(offset);
        int count = 0;
        for (need = nbytes; need > 0L && count != -1; need -= (long)count) {
            dest.write(ByteBuffer.wrap(buf, 0, count));
            count = this.hfile.read(buf, 0, 4096);
        }
        return nbytes - need;
    }
}

