/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.writer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.HorizCoordSys;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.writer.CoverageSubsetter2;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Optional;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.LatLonProjection;

@Deprecated
public class CFGridCoverageWriter2 {
    private static final Logger logger = LoggerFactory.getLogger(CFGridCoverageWriter2.class);
    private static final boolean show = false;
    private static final String BOUNDS = "_bounds";
    private static final String BOUNDS_DIM = "bounds_dim";

    public static Optional<Long> write(CoverageCollection gdsOrg, List<String> gridNames, SubsetParams subset, boolean tryToAddLatLon2D, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        Preconditions.checkNotNull(writer);
        CFGridCoverageWriter2 writer2 = new CFGridCoverageWriter2();
        return writer2.writeFile(gdsOrg, gridNames, subset, tryToAddLatLon2D, false, writer);
    }

    public static Optional<Long> getSizeOfOutput(CoverageCollection gdsOrg, List<String> gridNames, SubsetParams subset, boolean tryToAddLatLon2D) throws IOException, InvalidRangeException {
        CFGridCoverageWriter2 writer2 = new CFGridCoverageWriter2();
        NetcdfFileWriter writer = NetcdfFileWriter.createNew(null, false);
        return writer2.writeFile(gdsOrg, gridNames, subset, tryToAddLatLon2D, true, writer);
    }

    private Optional<Long> writeFile(CoverageCollection gdsOrg, List<String> gridNames, SubsetParams subsetParams, boolean tryToAddLatLon2D, boolean testSizeOnly, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        Optional<CoverageCollection> opt;
        if (gridNames == null) {
            gridNames = new LinkedList<String>();
            for (Coverage coverage : gdsOrg.getCoverages()) {
                gridNames.add(coverage.getName());
            }
        }
        if (subsetParams == null) {
            subsetParams = new SubsetParams();
        }
        if (!(opt = CoverageSubsetter2.makeCoverageDatasetSubset(gdsOrg, gridNames, subsetParams)).isPresent()) {
            return Optional.empty(opt.getErrorMessage());
        }
        CoverageCollection subsetDataset = opt.get();
        this.addGlobalAttributes(subsetDataset, writer);
        this.addDimensions(subsetDataset, writer);
        this.addCoordinateAxes(subsetDataset, writer);
        this.addCoverages(subsetDataset, writer);
        this.addCoordTransforms(subsetDataset, writer);
        boolean shouldAddLatLon2D = this.shouldAddLatLon2D(tryToAddLatLon2D, subsetDataset);
        if (shouldAddLatLon2D) {
            this.addLatLon2D(subsetDataset, writer);
        }
        this.addCFAnnotations(subsetDataset, writer, shouldAddLatLon2D);
        long totalSizeOfVars = 0L;
        Group rootGroup = writer.addGroup(null, null);
        for (Variable var : rootGroup.getVariables()) {
            totalSizeOfVars += var.getSize() * (long)var.getElementSize();
        }
        if (!testSizeOnly) {
            writer.setLargeFile(this.isLargeFile(totalSizeOfVars));
            writer.create();
            this.writeCoordinateData(subsetDataset, writer);
            this.writeCoverageData(gdsOrg, subsetParams, subsetDataset, writer);
            if (shouldAddLatLon2D) {
                this.writeLatLon2D(subsetDataset, writer);
            }
            writer.close();
        }
        return Optional.of(totalSizeOfVars);
    }

    private boolean shouldAddLatLon2D(boolean tryToAddLatLon2D, CoverageCollection subsetDataset) {
        if (!tryToAddLatLon2D) {
            return false;
        }
        HorizCoordSys horizCoordSys = subsetDataset.getHorizCoordSys();
        if (horizCoordSys.isLatLon2D()) {
            return false;
        }
        if (!horizCoordSys.isProjection()) {
            return false;
        }
        ProjectionImpl proj = horizCoordSys.getTransform().getProjection();
        return !(proj instanceof LatLonProjection);
    }

    private boolean isLargeFile(long total_size) {
        boolean isLargeFile = false;
        long maxSize = Integer.MAX_VALUE;
        if (total_size > maxSize) {
            logger.debug("Request size = {} Mbytes", (Object)(total_size / 1000L / 1000L));
            isLargeFile = true;
        }
        return isLargeFile;
    }

    private void addGlobalAttributes(CoverageCollection gds, NetcdfFileWriter writer) {
        for (Attribute att : gds.getGlobalAttributes()) {
            if (att.getShortName().equals("file_format") || att.getShortName().equals("_CoordSysBuilder")) continue;
            writer.addGroupAttribute(null, att);
        }
        Attribute att = gds.findAttributeIgnoreCase("Conventions");
        if (att == null || !att.getStringValue().startsWith("CF-")) {
            writer.addGroupAttribute(null, new Attribute("Conventions", "CF-1.0"));
        }
        writer.addGroupAttribute(null, new Attribute("History", "Translated to CF-1.0 Conventions by Netcdf-Java CDM (CFGridCoverageWriter2)\nOriginal Dataset = " + gds.getName() + "; Translation Date = " + CalendarDate.present()));
        LatLonRect llbb = gds.getLatlonBoundingBox();
        if (llbb != null) {
            writer.addGroupAttribute(null, new Attribute("geospatial_lat_min", llbb.getLatMin()));
            writer.addGroupAttribute(null, new Attribute("geospatial_lat_max", llbb.getLatMax()));
            writer.addGroupAttribute(null, new Attribute("geospatial_lon_min", llbb.getLonMin()));
            writer.addGroupAttribute(null, new Attribute("geospatial_lon_max", llbb.getLonMax()));
        }
    }

    private void addDimensions(CoverageCollection subsetDataset, NetcdfFileWriter writer) {
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            Dimension d;
            if (axis.getDependenceType() == CoverageCoordAxis.DependenceType.independent) {
                d = writer.addDimension(null, axis.getName(), axis.getNcoords());
                dimHash.put(axis.getName(), d);
            }
            if (!axis.isInterval() || null != dimHash.get(BOUNDS_DIM)) continue;
            d = writer.addDimension(null, BOUNDS_DIM, 2);
            dimHash.put(BOUNDS_DIM, d);
        }
    }

    private void addCoordinateAxes(CoverageCollection subsetDataset, NetcdfFileWriter writer) {
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            String dims = axis.getDependenceType() == CoverageCoordAxis.DependenceType.independent ? axis.getName() : (axis.getDependenceType() == CoverageCoordAxis.DependenceType.scalar ? "" : axis.getDependsOn());
            boolean hasBounds = false;
            if (axis.isInterval()) {
                Variable vb = writer.addVariable(null, axis.getName() + BOUNDS, axis.getDataType(), dims + " " + BOUNDS_DIM);
                vb.addAttribute(new Attribute("units", axis.getUnits()));
                hasBounds = true;
            }
            Variable v = writer.addVariable(null, axis.getName(), axis.getDataType(), dims);
            this.addVariableAttributes(v, axis.getAttributeContainer());
            v.addAttribute(new Attribute("units", axis.getUnits()));
            if (hasBounds) {
                v.addAttribute(new Attribute("bounds", axis.getName() + BOUNDS));
            }
            if (axis.getAxisType() != AxisType.TimeOffset) continue;
            v.addAttribute(new Attribute("standard_name", "forecast_period"));
        }
    }

    private void addCoverages(CoverageCollection subsetDataset, NetcdfFileWriter writer) {
        for (Coverage grid : subsetDataset.getCoverages()) {
            Variable v = writer.addVariable(null, grid.getName(), grid.getDataType(), grid.getIndependentAxisNamesOrdered());
            this.addVariableAttributes(v, grid.attributes());
        }
    }

    private void addVariableAttributes(Variable v, AttributeContainer atts) {
        for (Attribute att : atts) {
            if (att.getShortName().startsWith("_Coordinate") || att.getShortName().startsWith("_Chunk")) continue;
            v.addAttribute(att);
        }
    }

    private void addCoordTransforms(CoverageCollection subsetDataset, NetcdfFileWriter writer) {
        for (CoverageTransform ct : subsetDataset.getCoordTransforms()) {
            Variable ctv = writer.addVariable(null, ct.getName(), DataType.INT, "");
            for (Attribute att : ct.attributes()) {
                ctv.addAttribute(att);
            }
        }
    }

    private void addLatLon2D(CoverageCollection subsetDataset, NetcdfFileWriter writer) {
        HorizCoordSys horizCoordSys = subsetDataset.getHorizCoordSys();
        CoverageCoordAxis1D xAxis = horizCoordSys.getXAxis();
        CoverageCoordAxis1D yAxis = horizCoordSys.getYAxis();
        Dimension xDim = writer.findDimension(xAxis.getName());
        Dimension yDim = writer.findDimension(yAxis.getName());
        assert (xDim != null) : "We should've added X dimension in addDimensions().";
        assert (yDim != null) : "We should've added Y dimension in addDimensions().";
        List<Dimension> dims = Arrays.asList(yDim, xDim);
        Variable latVar = writer.addVariable("lat", DataType.DOUBLE, dims);
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = writer.addVariable("lon", DataType.DOUBLE, dims);
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
    }

    private void addCFAnnotations(CoverageCollection gds, NetcdfFileWriter writer, boolean shouldAddLatLon2D) {
        for (Coverage grid : gds.getCoverages()) {
            CoverageCoordSys gcs = grid.getCoordSys();
            Variable newV = writer.findVariable(grid.getName());
            if (newV == null) {
                logger.error("CFGridCoverageWriter2 cant find " + grid.getName() + " in writer ");
                continue;
            }
            Formatter coordsAttribValFormatter = new Formatter();
            for (String axisName : grid.getCoordSys().getAxisNames()) {
                coordsAttribValFormatter.format("%s ", axisName);
            }
            if (shouldAddLatLon2D) {
                assert (writer.findVariable("lat") != null) : "We should've added lat variable in addLatLon2D()";
                assert (writer.findVariable("lon") != null) : "We should've added lon variable in addLatLon2D()";
                coordsAttribValFormatter.format("lat lon", new Object[0]);
            }
            newV.addAttribute(new Attribute("coordinates", coordsAttribValFormatter.toString()));
            CoverageTransform ct = gcs.getHorizTransform();
            if (ct == null || !ct.isHoriz()) continue;
            newV.addAttribute(new Attribute("grid_mapping", ct.getName()));
        }
        for (CoverageCoordAxis axis : gds.getCoordAxes()) {
            Variable newV = writer.findVariable(axis.getName());
            if (newV == null) {
                logger.error("CFGridCoverageWriter2 cant find " + axis.getName() + " in writer ");
                continue;
            }
            if (axis.getAxisType() == AxisType.Lat) {
                newV.addAttribute(new Attribute("units", "degrees_north"));
                newV.addAttribute(new Attribute("standard_name", "latitude"));
            }
            if (axis.getAxisType() == AxisType.Lon) {
                newV.addAttribute(new Attribute("units", "degrees_east"));
                newV.addAttribute(new Attribute("standard_name", "longitude"));
            }
            if (axis.getAxisType() == AxisType.GeoX) {
                newV.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            }
            if (axis.getAxisType() == AxisType.GeoY) {
                newV.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            }
            if (axis.getAxisType() != AxisType.Ensemble) continue;
            newV.addAttribute(new Attribute("standard_name", "realization"));
        }
    }

    private void writeCoordinateData(CoverageCollection subsetDataset, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            Variable v = writer.findVariable(axis.getName());
            if (v != null) {
                writer.write(v, axis.getCoordsAsArray());
            } else {
                logger.error("CFGridCoverageWriter2 No variable for {}%n", (Object)axis.getName());
            }
            if (!axis.isInterval()) continue;
            Variable vb = writer.findVariable(axis.getName() + BOUNDS);
            writer.write(vb, axis.getCoordBoundsAsArray());
        }
    }

    private void writeCoverageData(CoverageCollection gdsOrg, SubsetParams subsetParams, CoverageCollection subsetDataset, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        for (Coverage coverage : subsetDataset.getCoverages()) {
            Coverage coverageOrg = gdsOrg.findCoverage(coverage.getName());
            GeoReferencedArray array = coverageOrg.readData(subsetParams);
            this.checkConformance(coverage, array, gdsOrg.getName());
            Variable v = writer.findVariable(coverage.getName());
            writer.write(v, array.getData());
        }
    }

    private void writeLatLon2D(CoverageCollection subsetDataset, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        HorizCoordSys horizCoordSys = subsetDataset.getHorizCoordSys();
        CoverageCoordAxis1D xAxis = horizCoordSys.getXAxis();
        CoverageCoordAxis1D yAxis = horizCoordSys.getYAxis();
        ProjectionImpl proj = horizCoordSys.getTransform().getProjection();
        double[] xData = (double[])xAxis.getCoordsAsArray().get1DJavaArray(DataType.DOUBLE);
        double[] yData = (double[])yAxis.getCoordsAsArray().get1DJavaArray(DataType.DOUBLE);
        int numX = xData.length;
        int numY = yData.length;
        double[] latData = new double[numX * numY];
        double[] lonData = new double[numX * numY];
        for (int i = 0; i < numY; ++i) {
            for (int j = 0; j < numX; ++j) {
                ProjectionPoint projPoint = ProjectionPoint.create(xData[j], yData[i]);
                LatLonPoint latlonPoint = proj.projToLatLon(projPoint);
                latData[i * numX + j] = latlonPoint.getLatitude();
                lonData[i * numX + j] = latlonPoint.getLongitude();
            }
        }
        Variable latVar = writer.findVariable("lat");
        assert (latVar != null) : "We should have added lat var in addLatLon2D().";
        Array latDataArray = Array.factory(DataType.DOUBLE, new int[]{numY, numX}, (Object)latData);
        writer.write(latVar, latDataArray);
        Variable lonVar = writer.findVariable("lon");
        assert (lonVar != null) : "We should have added lon var in addLatLon2D().";
        Array lonDataArray = Array.factory(DataType.DOUBLE, new int[]{numY, numX}, (Object)lonData);
        writer.write(lonVar, lonDataArray);
    }

    private void checkConformance(Coverage gridSubset, GeoReferencedArray geo, String where) {
        CoverageCoordSys csys = gridSubset.getCoordSys();
        CoverageCoordSys csysData = geo.getCoordSysForData();
        Section s2 = new Section(csys.getShape());
        Section so = new Section(csysData.getShape());
        boolean ok = s2.conformal(so);
        int[] dataShape = geo.getData().getShape();
        Section sdata = new Section(dataShape);
        boolean ok2 = s2.conformal(sdata);
        if (!ok || !ok2) {
            logger.warn("CFGridCoverageWriter2 checkConformance fails " + where);
        }
    }
}

