/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

public abstract class BackgroundUpdate<E> {
    boolean busy = false;
    boolean needsRefresh = true;
    E lastUpdate;

    public BackgroundUpdate() {
        this.changed();
    }

    public E get() {
        if (this.needsRefresh) {
            this.changed();
        }
        return this.lastUpdate;
    }

    public void changed() {
        this.needsRefresh = true;
        if (this.grabBusy()) {
            new Thread(){

                @Override
                public void run() {
                    while (BackgroundUpdate.this.needsRefresh) {
                        try {
                            BackgroundUpdate.this.lastUpdate = BackgroundUpdate.this.update();
                        }
                        catch (Throwable th) {
                            System.err.println("while background update was running, it encountered:");
                            th.printStackTrace();
                        }
                        BackgroundUpdate.this.needsRefresh = false;
                    }
                    BackgroundUpdate.this.setBusy(false);
                }
            }.start();
        }
    }

    private synchronized boolean grabBusy() {
        if (this.busy) {
            return false;
        }
        this.busy = true;
        return true;
    }

    private synchronized void setBusy(boolean s2) {
        this.busy = s2;
    }

    protected abstract E update();
}

