/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class AutoEnumCombo
extends JPanel {
    ValueSet vs;
    Enum[] values;
    String label;
    private JComboBox combo;
    private JLabel nameLabel;

    public AutoEnumCombo() {
        this.initComponents();
    }

    public AutoEnumCombo(Enum num, ValueSet vs) {
        this(num, vs, "name", (Enum[])num.getClass().getEnumConstants());
    }

    public AutoEnumCombo(Enum num, ValueSet vs, String label) {
        this(num, vs, label, (Enum[])num.getClass().getEnumConstants());
    }

    public AutoEnumCombo(Enum num, ValueSet vs, String label, Enum[] values) {
        this.vs = vs;
        this.values = values;
        this.label = label;
        this.initComponents();
        DefaultComboBoxModel<Enum> dcbm = new DefaultComboBoxModel<Enum>();
        for (Enum e : values) {
            dcbm.addElement(e);
        }
        this.combo.setModel(dcbm);
        this.combo.setSelectedItem(num);
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoEnumCombo.this.comboActionPerformed(evt);
            }
        });
    }

    public void fire() {
        this.vs.valueSet(this.values[this.combo.getSelectedIndex()]);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.combo = new JComboBox();
        this.nameLabel.setText(this.label);
        this.combo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.combo, 0, 349, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.combo, -2, -1, -2).addComponent(this.nameLabel)));
    }

    private void comboActionPerformed(ActionEvent evt) {
        Enum num = (Enum)this.combo.getSelectedItem();
        try {
            this.vs.valueSet(num);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static interface ValueSet {
        public void valueSet(Enum var1);
    }
}

