/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.twak.utils.Mathz;

public class AutoDoubleSlider
extends JPanel {
    Field f;
    Object o;
    JFormattedTextField textField;
    JSlider slider;
    private Runnable update;
    private boolean onDrag = true;
    boolean updating = false;

    public AutoDoubleSlider(Object o, String field, String name, double min2, double max) {
        this(o, field, name, min2, max, null);
    }

    public AutoDoubleSlider(Object o, String field, String name, final double min2, final double max, Runnable update) {
        this.update = update;
        try {
            UIManager.put("Slider.paintValue", Boolean.FALSE);
            this.o = o;
            this.f = o.getClass().getField(field);
            double initialVal = this.f.getDouble(o);
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel(name), "West");
            int scale = 1000;
            double i = Mathz.clamp(initialVal, min2, max);
            this.slider = new JSlider(0, (int)((max - min2) * 1000.0), (int)((i - min2) * 1000.0));
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (AutoDoubleSlider.this.updating) {
                        return;
                    }
                    if (AutoDoubleSlider.this.onDrag || !AutoDoubleSlider.this.slider.getValueIsAdjusting()) {
                        double val = (double)AutoDoubleSlider.this.slider.getValue() / (double)(AutoDoubleSlider.this.slider.getMaximum() - AutoDoubleSlider.this.slider.getMinimum());
                        AutoDoubleSlider.this.updating = true;
                        AutoDoubleSlider.this.set(val * (max - min2) + min2, max, min2);
                        AutoDoubleSlider.this.updating = false;
                    }
                }
            });
            this.add((Component)this.slider, "Center");
            this.textField = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.textField.setValue(initialVal);
            this.textField.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!AutoDoubleSlider.this.updating) {
                        AutoDoubleSlider.this.set(((Number)AutoDoubleSlider.this.textField.getValue()).doubleValue(), max, min2);
                    }
                }
            });
            this.textField.setPreferredSize(new Dimension(50, this.textField.getMinimumSize().height));
            this.add((Component)this.textField, "East");
            this.setPreferredSize(this.textField.getPreferredSize());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(double value, double max, double min2) {
        try {
            int v;
            this.f.set(this.o, value);
            if (!this.textField.getValue().equals(value)) {
                this.textField.setValue(value);
            }
            if ((v = (int)((value - min2) / (max - min2) * (double)(this.slider.getMaximum() - this.slider.getMinimum()) + (double)this.slider.getMinimum())) != this.slider.getValue()) {
                this.slider.setValue(v);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            this.updated(value);
        }
    }

    public AutoDoubleSlider notWhileDragging() {
        this.onDrag = false;
        return this;
    }

    public void updated(double value) {
        this.update.run();
    }
}

