/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.triangulate;

import org.twak.utils.triangulate.HashSet;
import org.twak.utils.triangulate.ObjectArray;
import org.twak.utils.triangulate.PolyVertex;

public class EarCutTriangulator {
    private static final int DEFAULT_POLY_SIZE = 6;
    private static ObjectArray vertexCache = new ObjectArray();
    private HashSet concaveVertices;
    private float[] faceNormal;
    private float[] working2dCoords;
    private PolyVertex[] tmpArray;

    EarCutTriangulator() {
        this(6);
    }

    EarCutTriangulator(int size) {
        this.concaveVertices = new HashSet(size);
        this.faceNormal = new float[3];
        this.working2dCoords = new float[6];
        this.tmpArray = new PolyVertex[size];
    }

    public static int triangulateConcavePolygon(float[] coords, int startIndex, int numVertex, int[] coordIndex, int[] coordOutput, float[] normal) {
        return new EarCutTriangulator(100).triangulateConcavePolygon(coords, startIndex, numVertex, coordIndex, 0, null, 0, null, 0, null, coordOutput, null, null, null, normal);
    }

    public int triangulateConcavePolygon(float[] coords, int startIndex, int numVertex, int[] coordIndex, int firstNormalIndex, int[] normalIndex, int firstColorIndex, int[] colorIndex, int firstTexCoordIndex, int[] texCoordIndex, int[] coordOutput, int[] normalOutput, int[] colorOutput, int[] texCoordOutput, float[] normal) {
        if (numVertex < 3) {
            return 0;
        }
        if (numVertex == 3) {
            coordOutput[0] = coordIndex[startIndex];
            coordOutput[1] = coordIndex[startIndex + 1];
            coordOutput[2] = coordIndex[startIndex + 2];
            if (normalOutput != null) {
                normalOutput[0] = normalIndex[firstNormalIndex];
                normalOutput[1] = normalIndex[firstNormalIndex + 1];
                normalOutput[2] = normalIndex[firstNormalIndex + 2];
            }
            if (colorOutput != null) {
                colorOutput[0] = colorIndex[firstColorIndex];
                colorOutput[1] = colorIndex[firstColorIndex + 1];
                colorOutput[2] = colorIndex[firstColorIndex + 2];
            }
            if (texCoordOutput != null) {
                texCoordOutput[0] = texCoordIndex[firstTexCoordIndex];
                texCoordOutput[1] = texCoordIndex[firstTexCoordIndex + 1];
                texCoordOutput[2] = texCoordIndex[firstTexCoordIndex + 2];
            }
            return 1;
        }
        this.faceNormal[0] = normal[0];
        this.faceNormal[1] = normal[1];
        this.faceNormal[2] = normal[2];
        if (numVertex > this.tmpArray.length) {
            this.tmpArray = new PolyVertex[numVertex];
        }
        int index = coordIndex[startIndex];
        PolyVertex first = EarCutTriangulator.newVertex();
        first.x = coords[index * 3];
        first.y = coords[index * 3 + 1];
        first.z = coords[index * 3 + 2];
        first.vertexIndex = index;
        if (colorIndex != null) {
            first.colorIndex = colorIndex[firstColorIndex];
        }
        if (normalIndex != null) {
            first.normalIndex = normalIndex[firstNormalIndex];
        }
        if (texCoordIndex != null) {
            first.texCoordIndex = texCoordIndex[firstTexCoordIndex];
        }
        if (!EarCutTriangulator.isConvexVertex(coords, coordIndex[startIndex + numVertex - 1] * 3, coordIndex[startIndex] * 3, coordIndex[startIndex + 1] * 3, this.faceNormal)) {
            this.concaveVertices.add(first);
        }
        PolyVertex current = first;
        PolyVertex prev = first;
        int inc = 1;
        for (int i = startIndex + 1; i < startIndex + numVertex - 1; ++i) {
            index = coordIndex[i];
            current = EarCutTriangulator.newVertex();
            current.x = coords[index * 3];
            current.y = coords[index * 3 + 1];
            current.z = coords[index * 3 + 2];
            current.vertexIndex = index;
            if (colorIndex != null) {
                current.colorIndex = colorIndex[firstColorIndex + inc];
            }
            if (normalIndex != null) {
                current.normalIndex = normalIndex[firstNormalIndex + inc];
            }
            if (texCoordIndex != null) {
                current.texCoordIndex = texCoordIndex[firstTexCoordIndex + inc];
            }
            if (!EarCutTriangulator.isConvexVertex(coords, coordIndex[i - 1] * 3, coordIndex[i] * 3, coordIndex[i + 1] * 3, this.faceNormal)) {
                this.concaveVertices.add(current);
            }
            current.prev = prev;
            prev.next = current;
            prev = current;
            ++inc;
        }
        index = coordIndex[startIndex + numVertex - 1];
        if (coords[index * 3] == coords[coordIndex[startIndex] * 3] && coords[index * 3 + 1] == coords[coordIndex[startIndex] * 3 + 1] && coords[index * 3 + 2] == coords[coordIndex[startIndex] * 3 + 2]) {
            current.next = first;
            first.prev = current;
        } else {
            PolyVertex last = EarCutTriangulator.newVertex();
            last.x = coords[index * 3];
            last.y = coords[index * 3 + 1];
            last.z = coords[index * 3 + 2];
            last.vertexIndex = index;
            if (colorIndex != null) {
                last.colorIndex = colorIndex[firstColorIndex + numVertex - 1];
            }
            if (normalIndex != null) {
                last.normalIndex = normalIndex[firstNormalIndex + numVertex - 1];
            }
            if (texCoordIndex != null) {
                last.texCoordIndex = texCoordIndex[firstTexCoordIndex + numVertex - 1];
            }
            if (!EarCutTriangulator.isConvexVertex(coords, coordIndex[startIndex + numVertex - 2] * 3, coordIndex[startIndex + numVertex - 1] * 3, coordIndex[startIndex] * 3, this.faceNormal)) {
                this.concaveVertices.add(last);
            }
            first.prev = last;
            last.next = first;
            last.prev = current;
            current.next = last;
        }
        return this.triangulate(first, coordOutput, normalOutput, colorOutput, texCoordOutput);
    }

    public int triangulateConcavePolygon(float[] coords, int startIndex, int numVertex, int firstNormalIndex, int firstColorIndex, int firstTexCoordIndex, int[] coordOutput, int[] normalOutput, int[] colorOutput, int[] texCoordOutput, float[] normal) {
        if (numVertex < 3) {
            return 0;
        }
        if (numVertex == 3) {
            coordOutput[0] = startIndex;
            coordOutput[1] = startIndex + 3;
            coordOutput[2] = startIndex + 6;
            if (normalOutput != null) {
                normalOutput[0] = firstNormalIndex;
                normalOutput[1] = firstNormalIndex + 3;
                normalOutput[2] = firstNormalIndex + 6;
            }
            if (colorOutput != null) {
                colorOutput[0] = firstColorIndex;
                colorOutput[1] = firstColorIndex + 3;
                colorOutput[2] = firstColorIndex + 6;
            }
            if (texCoordOutput != null) {
                texCoordOutput[0] = firstTexCoordIndex;
                texCoordOutput[1] = firstTexCoordIndex + 3;
                texCoordOutput[2] = firstTexCoordIndex + 6;
            }
            return 1;
        }
        this.faceNormal[0] = normal[0];
        this.faceNormal[1] = normal[1];
        this.faceNormal[2] = normal[2];
        if (numVertex > this.tmpArray.length) {
            this.tmpArray = new PolyVertex[numVertex];
        }
        PolyVertex first = EarCutTriangulator.newVertex();
        first.x = coords[startIndex];
        first.y = coords[startIndex + 1];
        first.z = coords[startIndex + 2];
        first.vertexIndex = startIndex;
        first.colorIndex = firstColorIndex;
        first.normalIndex = firstNormalIndex;
        first.texCoordIndex = firstTexCoordIndex;
        if (!EarCutTriangulator.isConvexVertex(coords, startIndex + (numVertex - 1) * 3, startIndex, startIndex + 3, this.faceNormal)) {
            this.concaveVertices.add(first);
        }
        PolyVertex current = first;
        PolyVertex prev = first;
        int vtx = startIndex + 3;
        int inc = 3;
        for (int i = 1; i < numVertex - 1; ++i) {
            current = EarCutTriangulator.newVertex();
            current.x = coords[vtx];
            current.y = coords[vtx + 1];
            current.z = coords[vtx + 2];
            current.vertexIndex = vtx;
            current.colorIndex = firstColorIndex + inc;
            current.normalIndex = firstNormalIndex + inc;
            current.texCoordIndex = firstTexCoordIndex + inc;
            if (!EarCutTriangulator.isConvexVertex(coords, vtx - 3, vtx, vtx + 3, this.faceNormal)) {
                this.concaveVertices.add(current);
            }
            current.prev = prev;
            prev.next = current;
            prev = current;
            vtx += 3;
            inc += 3;
        }
        if (coords[vtx] == coords[startIndex] && coords[vtx + 1] == coords[startIndex + 1] && coords[vtx + 2] == coords[startIndex + 2]) {
            current.next = first;
            first.prev = current;
        } else {
            PolyVertex last = EarCutTriangulator.newVertex();
            last.x = coords[vtx];
            last.y = coords[vtx + 1];
            last.z = coords[vtx + 2];
            last.vertexIndex = vtx;
            last.colorIndex = firstColorIndex + inc;
            last.normalIndex = firstNormalIndex + inc;
            last.texCoordIndex = firstTexCoordIndex + inc;
            if (!EarCutTriangulator.isConvexVertex(coords, vtx - 3, vtx, startIndex, this.faceNormal)) {
                this.concaveVertices.add(last);
            }
            first.prev = last;
            last.next = first;
            last.prev = current;
            current.next = last;
        }
        return this.triangulate(first, coordOutput, normalOutput, colorOutput, texCoordOutput);
    }

    public void clearCachedObjects() {
        vertexCache.clear();
    }

    private int triangulate(PolyVertex first, int[] coordOutput, int[] normalOutput, int[] colorOutput, int[] texCoordOutput) {
        int output_index = 0;
        int cnt = 0;
        int maxCnt = coordOutput.length / 3;
        maxCnt *= maxCnt;
        PolyVertex current = first.next.next;
        while (current != first) {
            PolyVertex prev_vtx = current.prev;
            boolean is_tri = false;
            if (++cnt > maxCnt) {
                System.out.println("Endless loop in Triangulation detected");
                System.out.println("Possible causes: ");
                System.out.println("  The normals are not correct");
                System.out.println("  Non-planar polygons");
                System.out.println("  Self-intersecting polygons");
                System.out.println("  Degenerate polygons with all coincident vertices");
                this.concaveVertices.clear();
                return -output_index / 3;
            }
            is_tri = this.isTriangle(current);
            if (this.isEar(prev_vtx) && !is_tri) {
                if (this.isCoincident(prev_vtx)) {
                    prev_vtx.prev.next = current;
                    current.prev = prev_vtx.prev;
                    if (prev_vtx == first) {
                        current = current.next;
                    }
                    prev_vtx.next = null;
                    prev_vtx.prev = null;
                    EarCutTriangulator.freeVertex(prev_vtx);
                    continue;
                }
                coordOutput[output_index] = current.prev.prev.vertexIndex;
                coordOutput[output_index + 1] = current.prev.vertexIndex;
                coordOutput[output_index + 2] = current.vertexIndex;
                if (normalOutput != null) {
                    normalOutput[output_index] = current.prev.prev.normalIndex;
                    normalOutput[output_index + 1] = current.prev.normalIndex;
                    normalOutput[output_index + 2] = current.normalIndex;
                }
                if (colorOutput != null) {
                    colorOutput[output_index] = current.prev.prev.colorIndex;
                    colorOutput[output_index + 1] = current.prev.colorIndex;
                    colorOutput[output_index + 2] = current.colorIndex;
                }
                if (texCoordOutput != null) {
                    texCoordOutput[output_index] = current.prev.prev.texCoordIndex;
                    texCoordOutput[output_index + 1] = current.prev.texCoordIndex;
                    texCoordOutput[output_index + 2] = current.texCoordIndex;
                }
                output_index += 3;
                prev_vtx.prev.next = current;
                current.prev = prev_vtx.prev;
                if (this.concaveVertices.contains(current) && this.isConvexVertex(current.prev, current, current.next)) {
                    this.concaveVertices.remove(current);
                }
                if (this.concaveVertices.contains(prev_vtx) && this.isConvexVertex(prev_vtx.prev, prev_vtx, prev_vtx.next)) {
                    this.concaveVertices.remove(current);
                }
                if (prev_vtx == first) {
                    current = current.next;
                }
                prev_vtx.next = null;
                prev_vtx.prev = null;
                EarCutTriangulator.freeVertex(prev_vtx);
                continue;
            }
            if (is_tri) {
                coordOutput[output_index] = current.prev.prev.vertexIndex;
                coordOutput[output_index + 1] = current.prev.vertexIndex;
                coordOutput[output_index + 2] = current.vertexIndex;
                if (normalOutput != null) {
                    normalOutput[output_index] = current.prev.prev.normalIndex;
                    normalOutput[output_index + 1] = current.prev.normalIndex;
                    normalOutput[output_index + 2] = current.normalIndex;
                }
                if (colorOutput != null) {
                    colorOutput[output_index] = current.prev.prev.colorIndex;
                    colorOutput[output_index + 1] = current.prev.colorIndex;
                    colorOutput[output_index + 2] = current.colorIndex;
                }
                if (texCoordOutput != null) {
                    texCoordOutput[output_index] = current.prev.prev.texCoordIndex;
                    texCoordOutput[output_index + 1] = current.prev.texCoordIndex;
                    texCoordOutput[output_index + 2] = current.texCoordIndex;
                }
                output_index += 3;
                PolyVertex p = current.next;
                if (p.next != current) {
                    PolyVertex p1 = p.next;
                    p1.next = null;
                    p1.prev = null;
                    EarCutTriangulator.freeVertex(p1);
                }
                p.next = null;
                p.prev = null;
                EarCutTriangulator.freeVertex(p);
                current.next = null;
                current.prev = null;
                EarCutTriangulator.freeVertex(current);
                current = null;
                break;
            }
            current = current.next;
        }
        this.concaveVertices.clear();
        return output_index / 3;
    }

    private boolean isEar(PolyVertex p) {
        int num_concaves = this.concaveVertices.size();
        if (num_concaves == 0) {
            return true;
        }
        if (this.isConvexVertex(p.prev, p, p.next)) {
            this.tmpArray = this.concaveVertices.toArray(this.tmpArray);
            boolean found_vertex = false;
            for (int i = 0; i < num_concaves; ++i) {
                PolyVertex cp = this.tmpArray[i];
                if (cp == p || cp == p.prev || cp == p.next || !this.isPointInTriangle(cp, p.prev, p, p.next) || cp.x == p.x && cp.y == p.y && cp.z == p.z || cp.x == p.prev.x && cp.y == p.prev.y && cp.z == p.prev.z || cp.x == p.next.x && cp.y == p.next.y && cp.z == p.next.z) continue;
                found_vertex = true;
                break;
            }
            return !found_vertex;
        }
        return false;
    }

    private boolean isTriangle(PolyVertex p) {
        return p.next == p || p.next.next == p || p.next.next.next == p;
    }

    private boolean isConvexVertex(PolyVertex p0, PolyVertex p, PolyVertex p1) {
        float y1 = p.y - p0.y;
        float z2 = p1.z - p.z;
        float z1 = p.z - p0.z;
        float y2 = p1.y - p.y;
        float cross_x = y1 * z2 - z1 * y2;
        float x2 = p1.x - p.x;
        float x1 = p.x - p0.x;
        float cross_y = z1 * x2 - x1 * z2;
        float cross_z = x1 * y2 - y1 * x2;
        float dot = cross_x * this.faceNormal[0] + cross_y * this.faceNormal[1] + cross_z * this.faceNormal[2];
        return dot >= 0.0f;
    }

    private static boolean isConvexVertex(float[] coords, int p0, int p, int p1, float[] normal) {
        float y1 = coords[p + 1] - coords[p0 + 1];
        float z2 = coords[p1 + 2] - coords[p + 2];
        float z1 = coords[p + 2] - coords[p0 + 2];
        float y2 = coords[p1 + 1] - coords[p + 1];
        float cross_x = y1 * z2 - z1 * y2;
        float x2 = coords[p1] - coords[p];
        float x1 = coords[p] - coords[p0];
        float cross_y = z1 * x2 - x1 * z2;
        float cross_z = x1 * y2 - y1 * x2;
        float dot = cross_x * normal[0] + cross_y * normal[1] + cross_z * normal[2];
        return dot >= 0.0f;
    }

    private boolean isPointInTriangle(PolyVertex suspect, PolyVertex p0, PolyVertex p, PolyVertex p1) {
        double abs_nrm_x = this.faceNormal[0] >= 0.0f ? (double)this.faceNormal[0] : (double)(-this.faceNormal[0]);
        double abs_nrm_y = this.faceNormal[1] >= 0.0f ? (double)this.faceNormal[1] : (double)(-this.faceNormal[1]);
        double abs_nrm_z = this.faceNormal[2] >= 0.0f ? (double)this.faceNormal[2] : (double)(-this.faceNormal[2]);
        int dom_axis = abs_nrm_x > abs_nrm_y ? 0 : 1;
        if (dom_axis == 0) {
            if (abs_nrm_x < abs_nrm_z) {
                dom_axis = 2;
            }
        } else if (abs_nrm_y < abs_nrm_z) {
            dom_axis = 2;
        }
        switch (dom_axis) {
            case 0: {
                this.working2dCoords[5] = p1.z - suspect.z;
                this.working2dCoords[4] = p1.y - suspect.y;
                this.working2dCoords[3] = p.z - suspect.z;
                this.working2dCoords[2] = p.y - suspect.y;
                this.working2dCoords[1] = p0.z - suspect.z;
                this.working2dCoords[0] = p0.y - suspect.y;
                break;
            }
            case 1: {
                this.working2dCoords[5] = p1.z - suspect.z;
                this.working2dCoords[4] = p1.x - suspect.x;
                this.working2dCoords[3] = p.z - suspect.z;
                this.working2dCoords[2] = p.x - suspect.x;
                this.working2dCoords[1] = p0.z - suspect.z;
                this.working2dCoords[0] = p0.x - suspect.x;
                break;
            }
            case 2: {
                this.working2dCoords[5] = p1.y - suspect.y;
                this.working2dCoords[4] = p1.x - suspect.x;
                this.working2dCoords[3] = p.y - suspect.y;
                this.working2dCoords[2] = p.x - suspect.x;
                this.working2dCoords[1] = p0.y - suspect.y;
                this.working2dCoords[0] = p0.x - suspect.x;
            }
        }
        int crossings = 0;
        int sh = (double)this.working2dCoords[1] < 0.0 ? -1 : 1;
        for (int i = 0; i < 3; ++i) {
            float dist;
            int j = (i + 1) % 3;
            int i_u = i * 2;
            int j_u = j * 2;
            int i_v = i * 2 + 1;
            int j_v = j * 2 + 1;
            int nsh = (double)this.working2dCoords[j_v] < 0.0 ? -1 : 1;
            if (sh == nsh) continue;
            if ((double)this.working2dCoords[i_u] > 0.0 && (double)this.working2dCoords[j_u] > 0.0) {
                ++crossings;
            } else if (((double)this.working2dCoords[i_u] > 0.0 || (double)this.working2dCoords[j_u] > 0.0) && (dist = this.working2dCoords[i_u] - this.working2dCoords[i_v] * (this.working2dCoords[j_u] - this.working2dCoords[i_u]) / (this.working2dCoords[j_v] - this.working2dCoords[i_v])) > 0.0f) {
                ++crossings;
            }
            sh = nsh;
        }
        return crossings % 2 == 1;
    }

    private boolean isCoincident(PolyVertex vtx) {
        float x1 = vtx.x - vtx.prev.x;
        float y1 = vtx.y - vtx.prev.y;
        float z1 = vtx.z - vtx.prev.z;
        float x2 = vtx.x - vtx.next.x;
        float y2 = vtx.y - vtx.next.y;
        float z2 = vtx.z - vtx.next.z;
        float cross_x = y1 * z2 - z1 * y2;
        float cross_y = z1 * x2 - x1 * z2;
        float cross_z = x1 * y2 - y1 * x2;
        return cross_x == 0.0f && cross_y == 0.0f && cross_z == 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolyVertex newVertex() {
        PolyVertex ret_val = null;
        ObjectArray objectArray = vertexCache;
        synchronized (objectArray) {
            ret_val = vertexCache.size() == 0 ? new PolyVertex() : (PolyVertex)vertexCache.remove(0);
        }
        return ret_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void freeVertex(PolyVertex e) {
        ObjectArray objectArray = vertexCache;
        synchronized (objectArray) {
            vertexCache.add(e);
        }
    }
}

