/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point2d;
import org.twak.utils.Line;
import org.twak.utils.collections.MultiMap;

public class Graph2D
extends MultiMap<Point2d, Line> {
    public Graph2D(Collection<Line> sliceTri) {
        sliceTri.stream().forEach(i -> this.add((Line)i));
    }

    public Graph2D() {
    }

    public Graph2D apply(AffineTransform at) {
        Graph2D out = new Graph2D();
        HashMap<Point2d, Point2d> seenPts = new HashMap<Point2d, Point2d>();
        for (List lines : this.map.values()) {
            for (Line l : lines) {
                Point2d end;
                Point2d start = (Point2d)seenPts.get(l.start);
                if (start == null) {
                    start = Graph2D.transform(l.start, at);
                    seenPts.put(l.start, start);
                }
                if ((end = (Point2d)seenPts.get(l.end)) == null) {
                    end = Graph2D.transform(l.end, at);
                    seenPts.put(l.end, end);
                }
                Line l2 = new Line(start, end);
                out.put(start, l2);
                out.put(end, l2);
            }
        }
        return out;
    }

    public void removeInnerEdges() {
        HashSet<Line> togo = new HashSet<Line>();
        for (Point2d pt : this.keySet()) {
            for (Line l1 : this.get(pt)) {
                for (Line l2 : this.get(pt)) {
                    if (!l1.start.equals(l2.end) || !l2.start.equals(l1.end)) continue;
                    togo.add(l1);
                    togo.add(l2);
                }
            }
        }
        for (Line l : togo) {
            this.remove(l.start, l);
            this.remove(l.end, l);
        }
    }

    private static Point2d transform(Point2d a, AffineTransform at) {
        double[] coords = new double[]{a.x, a.y};
        at.transform(coords, 0, coords, 0, 1);
        return new Point2d(coords[0], coords[1]);
    }

    public Set<Line> allLines() {
        HashSet<Line> seenLines = new HashSet<Line>();
        for (List l : this.map.values()) {
            seenLines.addAll(l);
        }
        return seenLines;
    }

    public void add(Line l) {
        this.put(l.start, l);
        this.put(l.end, l);
    }

    public void add(Point2d a, Point2d b) {
        Line l = new Line(a, b);
        this.put(l.start, l);
        this.put(l.end, l);
    }

    public void addAll(Iterable<Line> portal) {
        for (Line l : portal) {
            this.add(l);
        }
    }

    public void remove(Line line) {
        this.remove(line.start, line);
        this.remove(line.end, line);
    }

    public void removeAll(Iterable<Line> togo) {
        for (Line l : togo) {
            this.remove(l);
        }
    }

    public void mergeContiguous(double tolRads) {
        HashSet togo = new HashSet(this.keySet());
        while (!togo.isEmpty()) {
            Point2d pt = (Point2d)togo.iterator().next();
            togo.remove(pt);
            ArrayList lines = new ArrayList(this.get(pt));
            for (int ai = 0; ai < lines.size(); ++ai) {
                for (int bi = 0; bi < ai; ++bi) {
                    Line l;
                    Line b;
                    Line a = (Line)lines.get(ai);
                    if (!(a.absAngle(b = (Line)lines.get(bi)) < tolRads)) continue;
                    if (a.end.equals(b.start)) {
                        l = new Line(a.start, b.end);
                        togo.add(a.end);
                    } else {
                        if (!b.end.equals(a.start)) continue;
                        l = new Line(b.start, a.end);
                        togo.add(b.end);
                    }
                    this.remove(a);
                    this.remove(b);
                    this.add(l);
                    togo.add(l.start);
                    togo.add(l.end);
                }
            }
        }
    }
}

