/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.twak.utils.Cache;
import org.twak.utils.collections.MultiMap;
import org.twak.utils.collections.SetCorrespondence;

public class ManyManyMap<A, B> {
    private MultiMap<A, B> forwards = new MultiMap();
    private MultiMap<B, A> backwards = new MultiMap();

    public void addForwards(A from, B to) {
        this.forwards.put(from, to);
        this.backwards.put(to, from);
    }

    public List<B> getNext(A from) {
        return this.forwards.get(from);
    }

    public List<A> getPrev(B to) {
        return this.backwards.get(to);
    }

    public Set<A> getSrcSet() {
        return this.forwards.keySet();
    }

    public Set<A> getDestSet() {
        return this.forwards.keySet();
    }

    public SetCorrespondence<A, B> toSetCorrespondence() {
        SetCorrespondence<Object, Object> out = new SetCorrespondence<Object, Object>();
        for (A a : this.forwards.keySet()) {
            for (B b : this.forwards.get(a)) {
                out.put(a, b);
            }
        }
        for (Object b : this.backwards.keySet()) {
            for (Object a : this.backwards.get(b)) {
                out.put(a, b);
            }
        }
        return out;
    }

    public ManyManyMap<B, A> getFlipShallow() {
        ManyManyMap<A, B> out = new ManyManyMap<A, B>();
        out.backwards = this.forwards;
        out.forwards = this.backwards;
        return out;
    }

    public class ConvertOutputCollection<C> {
        Cache<B, Collection<C>> converter;

        public ConvertOutputCollection(Cache<B, Collection<C>> converter) {
            this.converter = converter;
        }

        public ManyManyMap<A, C> get() {
            ManyManyMap out = new ManyManyMap();
            for (Map.Entry es : ManyManyMap.this.forwards.map.entrySet()) {
                for (Object b : es.getValue()) {
                    out.forwards.putAll(es.getKey(), (Iterable)this.converter.get(b), true);
                }
            }
            for (Map.Entry es : ManyManyMap.this.backwards.map.entrySet()) {
                for (Object c : this.converter.get(es.getKey())) {
                    out.backwards.putAll(c, new ArrayList(es.getValue()), true);
                }
            }
            return out;
        }
    }

    public class ConvertInputCollection<C> {
        Cache<A, Collection<C>> converter;

        public ConvertInputCollection(Cache<A, Collection<C>> converter) {
            this.converter = converter;
        }

        public ManyManyMap<C, B> get() {
            ManyManyMap out = new ManyManyMap();
            for (Map.Entry es : ManyManyMap.this.forwards.map.entrySet()) {
                for (C c : this.converter.get(es.getKey())) {
                    out.forwards.putAll(c, new ArrayList(es.getValue()), true);
                }
            }
            for (Map.Entry es : ManyManyMap.this.backwards.map.entrySet()) {
                for (Object a : es.getValue()) {
                    out.backwards.putAll(es.getKey(), (Iterable)this.converter.get(a), true);
                }
            }
            return out;
        }
    }
}

