/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.twak.utils.collections.Listz;

public class Get<E>
implements Collector<E, TreeSet<E>, E> {
    ToDouble<E> toDouble;
    boolean max;

    public static <E> Get<E> max(ToDouble<E> toDouble) {
        return new Get<E>(toDouble, true);
    }

    public static <E> Get<E> min(ToDouble<E> toDouble) {
        return new Get<E>(toDouble, false);
    }

    public Get(ToDouble<E> toDouble, boolean max) {
        this.toDouble = toDouble;
        this.max = max;
    }

    @Override
    public Supplier<TreeSet<E>> supplier() {
        return () -> new TreeSet(new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                return -Double.compare(Get.this.toDouble.toDouble(a), Get.this.toDouble.toDouble(b));
            }
        });
    }

    @Override
    public BiConsumer<TreeSet<E>, E> accumulator() {
        return (l, v) -> l.add(v);
    }

    @Override
    public BinaryOperator<TreeSet<E>> combiner() {
        return (a, b) -> {
            TreeSet out = new TreeSet();
            out.addAll(a);
            out.addAll(b);
            return out;
        };
    }

    @Override
    public Function<TreeSet<E>, E> finisher() {
        return l -> this.max ? l.pollFirst() : l.pollLast();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }

    public static void main(String[] args) {
        List s2 = Listz.from("one", "three", "four", "one bazillion", "0");
        System.out.println("longest " + (String)s2.stream().collect(new Get<String>(f -> f.length(), true)));
        System.out.println("shortest " + (String)s2.stream().collect(new Get<String>(f -> f.length(), false)));
    }

    public static interface ToDouble<F> {
        public double toDouble(F var1);
    }
}

