/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.LinkedHashMap;
import java.util.Map;
import org.twak.utils.Cache;
import org.twak.utils.collections.ManyManyMap;

public class DHash<A, B> {
    public Map<A, B> ab = new LinkedHashMap<A, B>();
    public Map<B, A> ba = new LinkedHashMap<B, A>();

    public void clear() {
        this.ab.clear();
        this.ba.clear();
    }

    public void put(A a, B b) {
        this.ab.put(a, b);
        this.ba.put(b, a);
    }

    public B get(A a) {
        return this.ab.get(a);
    }

    public A teg(B b) {
        return this.ba.get(b);
    }

    public boolean containsA(A a) {
        return this.ab.containsKey(a);
    }

    public boolean containsB(B b) {
        return this.ba.containsKey(b);
    }

    public int hashCode() {
        return this.ab.hashCode() + this.ba.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DHash) {
            DHash o = (DHash)obj;
            return o.ab.equals(this.ab) && o.ba.equals(this.ba);
        }
        return false;
    }

    public void removeA(A a) {
        this.ba.remove(this.get(a));
        this.ab.remove(a);
    }

    public void removeB(B b) {
        this.ba.remove(b);
        this.ab.remove(this.teg(b));
    }

    public ManyManyMap<A, B> toManyMany() {
        ManyManyMap<A, Object> out = new ManyManyMap<A, Object>();
        for (A a : this.ab.keySet()) {
            out.addForwards(a, this.ab.get(a));
        }
        for (Object b : this.ba.keySet()) {
            assert (out.getPrev(b) == this.ba.get(b));
        }
        return out;
    }

    public DHash<A, B> shallowDupe() {
        DHash<A, B> out = new DHash<A, B>();
        out.ab.putAll(this.ab);
        out.ba.putAll(this.ba);
        return out;
    }

    public void remapB(Cache<B, B> cache) {
        LinkedHashMap<B, A> newBA = new LinkedHashMap<B, A>();
        LinkedHashMap<A, B> newAB = new LinkedHashMap<A, B>();
        for (Map.Entry<A, B> e : this.ab.entrySet()) {
            B newB = cache.get(e.getValue());
            if (newB == null) continue;
            newBA.put(newB, e.getKey());
            newAB.put(e.getKey(), newB);
        }
        this.ba = newBA;
        this.ab = newAB;
    }

    public Cache<A, B> asCache() {
        return new Cache<A, B>(){

            @Override
            public B create(A i) {
                throw new Error();
            }

            @Override
            public B get(A in) {
                return DHash.this.ab.get(in);
            }
        };
    }
}

