/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public abstract class DumbCluster1D<E>
extends ArrayList<Cluster<E>> {
    public DumbCluster1D() {
    }

    public DumbCluster1D(double tol, Collection<E> thingsIn) {
        this.setup(tol, thingsIn);
    }

    public void setup(double tol, Collection<E> thingsIn) {
        Cluster t;
        ArrayList<E> things = new ArrayList<E>(thingsIn);
        Collections.sort(things, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return Double.compare(DumbCluster1D.this.toDouble(o1), DumbCluster1D.this.toDouble(o2));
            }
        });
        List dists = things.stream().map(e -> new Cluster<Object>(e, this.toDouble(e))).collect(Collectors.toList());
        for (int i = 0; i < dists.size(); ++i) {
            if (i > 0) {
                ((Cluster)dists.get((int)i)).p = (Cluster)dists.get(i - 1);
            }
            if (i >= dists.size() - 1) continue;
            ((Cluster)dists.get((int)i)).n = (Cluster)dists.get(i + 1);
        }
        TreeSet<Cluster> byGap = new TreeSet<Cluster>(dists);
        while (byGap.size() > 1 && !((t = (Cluster)byGap.first()).gap() > tol)) {
            t.mergeDownOrUp(byGap);
        }
        for (Cluster t2 : byGap) {
            t2.mean = t2.vals.stream().mapToDouble(x -> x).average().getAsDouble();
            this.add(t2);
        }
        Collections.sort(this, new Comparator<Cluster>(){

            @Override
            public int compare(Cluster o1, Cluster o2) {
                return Double.compare(o2.max, o1.max);
            }
        });
    }

    public abstract double toDouble(E var1);

    public static class Cluster<E>
    implements Comparable<Cluster<E>> {
        public Set<Double> vals = new HashSet<Double>();
        public Set<E> things = new HashSet();
        public double max;
        public double min;
        public double mean;
        Cluster n;
        Cluster p;

        public Cluster(E e, double v1) {
            this.min = this.max = v1;
            this.vals.add(v1);
            this.things.add(e);
        }

        double gap() {
            double out = Double.MAX_VALUE;
            if (this.n != null) {
                out = Math.min(out, this.n.min - this.max);
            }
            if (this.p != null) {
                out = Math.min(out, this.min - this.p.max);
            }
            return out;
        }

        @Override
        public int compareTo(Cluster o) {
            Cluster t = o;
            int out = Double.compare(this.gap(), t.gap());
            if (out != 0) {
                return out;
            }
            return Double.compare(this.min, t.min);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public void mergeDownOrUp(TreeSet<Cluster> byGap) {
            byGap.remove(this);
            if (this.p == null || this.n != null && this.n.min - this.max < this.min - this.p.max) {
                byGap.remove(this.n);
                this.max = this.n.max;
                this.vals.addAll(this.n.vals);
                this.things.addAll(this.n.things);
                this.n = this.n.n;
                if (this.n != null) {
                    this.n.p = this;
                    byGap.remove(this.n);
                    byGap.add(this.n);
                }
            } else {
                byGap.remove(this.p);
                this.min = this.p.min;
                this.vals.addAll(this.p.vals);
                this.things.addAll(this.p.things);
                this.p = this.p.p;
                if (this.p != null) {
                    this.p.n = this;
                    byGap.remove(this.p);
                    byGap.add(this.p);
                }
            }
            byGap.add(this);
        }
    }
}

