/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.ui;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.HeightEvent;
import org.twak.camp.Machine;
import org.twak.camp.Output;
import org.twak.camp.Skeleton;
import org.twak.camp.SkeletonCapUpdate;
import org.twak.camp.debug.DebugDevice;
import org.twak.camp.offset.FindNOCorner;
import org.twak.camp.offset.Offset;
import org.twak.camp.offset.OffsetSkeleton;
import org.twak.camp.ui.DirectionHeightEvent;
import org.twak.utils.Cache;
import org.twak.utils.collections.DHash;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.SetCorrespondence;

public class HorizontalHeightEvent
extends DirectionHeightEvent {
    double length;
    public HeightEvent next = null;
    @Deprecated
    public double finalHeight;

    public HorizontalHeightEvent(Machine machine, double height, double length) {
        super(machine, height, 0.0);
        this.length = length;
        this.next = null;
    }

    public void whenDone(Skeleton skel) {
    }

    @Override
    public boolean process(Skeleton skel) {
        List<Edge> toChange = this.machine.findOurEdges(skel);
        SkeletonCapUpdate update = new SkeletonCapUpdate(skel);
        LoopL<Corner> cap = update.getCap(this.height);
        DebugDevice.dump("horiz initial cap", cap);
        double step = 100.0;
        OffsetSkeleton<Machine> offsetSkel = new OffsetSkeleton<Machine>(cap, step);
        offsetSkel.registerProfile(this.machine, Math.atan(this.length / step), 0);
        Offset offset = offsetSkel.getResults().get(0);
        LoopL<Corner> offsetLoops = offset.shape;
        FindNOCorner findNOCorner = new FindNOCorner(offset, cap){

            @Override
            public boolean didThisOldCornerRemainUnchanged(Corner oldC) {
                return oldC.prevL.machine != HorizontalHeightEvent.this.machine && oldC.nextL.machine != HorizontalHeightEvent.this.machine;
            }
        };
        SetCorrespondence<Corner, Corner> nOSegmentsUpdate = findNOCorner.nOSegmentsUpdate;
        DHash<Corner, Corner> nOCorner = findNOCorner.nOCorner;
        for (Corner neuC : offsetLoops.eIterator()) {
            Set<Corner> matchingSegs = nOSegmentsUpdate.getSetA(neuC);
            for (Corner oldC : matchingSegs) {
                if (oldC.nextL.machine != this.machine) continue;
                nOSegmentsUpdate.removeA(neuC);
            }
        }
        update.update(offsetLoops, nOSegmentsUpdate, nOCorner);
        Cache<Corner, Corner> cache = new Cache<Corner, Corner>(){

            @Override
            public Corner create(Corner i) {
                return new Corner(i.x, i.y, HorizontalHeightEvent.this.height);
            }
        };
        LinkedHashMap<Corner, Corner> baseCornerToOldFace = new LinkedHashMap<Corner, Corner>();
        for (Output.Face f : offsetSkel.outputSkeleton.output.faces.values()) {
            List<Corner> oldParent = offsetSkel.getInputEdge(f);
            Corner baseCorner = update.getOldBaseLookup().get((Corner)oldParent.get((int)0)).nextL.start;
            Edge e = new Edge((Corner)cache.get(f.edge.end), (Corner)cache.get(f.edge.start));
            e.start.nextC = e.end;
            e.end.prevC = e.end;
            e.setAngle(this.length > 0.0 ? 0.7853981633974483 : -0.7853981633974483);
            skel.output.newEdge(e, baseCorner, this.profileFeatures);
            skel.output.newDefiningSegment(e.start);
            baseCornerToOldFace.put(baseCorner, e.start);
            e.uphill = e.direction();
            e.uphill.normalize();
            e.uphill.set(-e.uphill.y, e.uphill.x, 0.0);
            for (Output.SharedEdge se : f.edges.eIterator()) {
                Point3d start = se.getStart(f);
                Point3d end = se.getEnd(f);
                skel.output.addOutputSideTo(false, (Tuple3d)new Point3d(start.x, start.y, this.height), new Point3d(end.x, end.y, this.height), e);
            }
        }
        for (Corner c : skel.liveCorners) {
            List<Corner> sc;
            Iterator<Corner> iterator;
            if (c.nextL.machine != this.machine || !(iterator = (sc = offset.nOSegments.getNext(c)).iterator()).hasNext()) continue;
            Corner cc = iterator.next();
            Corner base = update.getOldBaseLookup().get(cc);
            skel.output.setParent(c.nextL.start, (Corner)baseCornerToOldFace.get(base.nextL.start));
        }
        skel.refindAllFaceEventsLater();
        skel.validate();
        DebugDevice.dump("post-horizontal", skel);
        this.machine.findNextHeight(skel);
        this.whenDone(skel);
        if (this.next != null) {
            this.next.process(skel);
        }
        return true;
    }
}

