/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.offset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Tuple3d;
import org.twak.camp.Corner;
import org.twak.camp.CornerClone;
import org.twak.camp.Edge;
import org.twak.camp.HeightEvent;
import org.twak.camp.Machine;
import org.twak.camp.Output;
import org.twak.camp.Skeleton;
import org.twak.camp.offset.Offset;
import org.twak.camp.ui.DirectionHeightEvent;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.collections.ManyManyMap;
import org.twak.utils.collections.SetCorrespondence;

public class OffsetSkeleton<E extends Machine> {
    private List<Offset> output;
    public Map<E, OffsetMachine> profileOffset = new LinkedHashMap<E, OffsetMachine>();
    public Map<OffsetMachine, E> offsetProfile = new LinkedHashMap<OffsetMachine, E>();
    public double interval;
    LoopL<Corner> corners;
    int machinesCount = 0;
    int machinesOutstanding = 0;
    int lastStep = -1;
    SetCorrespondence<Corner, Corner> oldInputSegments;
    public Skeleton outputSkeleton;
    public DebugIntermediate debugIntermediate;

    public OffsetSkeleton() {
    }

    public OffsetSkeleton(LoopL<Corner> corners, double interval) {
        this.interval = interval;
        this.setup(corners, interval);
    }

    public void setup(LoopL<Corner> corners, double interval) {
        CornerClone cc = new CornerClone(corners);
        this.corners = cc.output;
        this.oldInputSegments = cc.nOSegments;
    }

    public void registerProfile(E profile, double angle, int step) {
        assert (profile != null);
        double height = (double)step * this.interval;
        OffsetMachine om = this.profileOffset.get(profile);
        if (om == null) {
            om = new OffsetMachine();
            this.profileOffset.put(profile, om);
            this.offsetProfile.put(om, profile);
            ++this.machinesCount;
        }
        om.addHeightEvent(new DirectionHeightEvent(om, height, angle));
        if (step > this.lastStep) {
            this.lastStep = step;
        }
    }

    public List<Offset> getResults() {
        this.output = new ArrayList<Offset>();
        HashMap<Machine, Machine> unspecifiedNewMachineOld = new HashMap<Machine, Machine>();
        for (Corner c : this.corners.eIterator()) {
            Edge e = c.nextL;
            Machine m3 = this.profileOffset.get(e.machine);
            if (m3 == null) {
                m3 = new Machine(0.0);
                unspecifiedNewMachineOld.put(m3, e.machine);
                e.machine = m3;
                continue;
            }
            e.machine = m3;
        }
        this.outputSkeleton = new Skeleton(this.corners, (double)(this.lastStep + 1) * this.interval, true);
        this.outputSkeleton.name = "offset";
        InstanceHeightEvent last = null;
        for (int i = 0; i <= this.lastStep; ++i) {
            last = new InstanceHeightEvent(i);
            this.outputSkeleton.qu.add(last);
        }
        if (last != null) {
            last.endHere = true;
        }
        this.outputSkeleton.skeleton();
        if (this.debugIntermediate != null) {
            this.debugIntermediate.debugIntermediate(this.outputSkeleton);
        }
        for (Offset offset : this.output) {
            for (Edge e : Edge.uniqueEdges(offset.shape)) {
                assert (e.machine != null);
                Machine origMachine = (Machine)this.offsetProfile.get(e.machine);
                e.machine = origMachine != null ? origMachine : (Machine)unspecifiedNewMachineOld.get(e.machine);
                e.machine.addEdge(e, this.outputSkeleton);
            }
        }
        return this.output;
    }

    public List<Corner> getInputEdge(Output.Face f) {
        Edge first = this.outputSkeleton.output.getGreatestGrandParent((Output.Face)f).edge;
        return new ArrayList<Corner>(this.oldInputSegments.getSetA(first.start));
    }

    public static LoopL<Corner> shrink(LoopL<Edge> in, double dist) {
        LoopL<Corner> lc = new LoopL.Map<Corner>(in){

            @Override
            public Corner map(Loopable<Edge> input) {
                input.get().start.nextL = input.get();
                input.get().end.prevL = input.get();
                input.get().start.nextC = input.get().end;
                input.get().end.prevC = input.get().start;
                return input.get().start;
            }
        }.run();
        OffsetSkeleton<Machine> os = new OffsetSkeleton<Machine>(lc, 100.0);
        HashSet<Machine> allMachines = new HashSet<Machine>();
        for (Edge e : in.eIterator()) {
            allMachines.add(e.machine);
        }
        for (Machine m3 : allMachines) {
            os.registerProfile(m3, Math.atan(dist / 100.0), 0);
        }
        List<Offset> res = os.getResults();
        if (res.isEmpty()) {
            return new LoopL<Corner>();
        }
        return res.get((int)0).shape;
    }

    public class OffsetMachine
    extends Machine {
        public OffsetMachine() {
            this.events.clear();
        }
    }

    public class InstanceHeightEvent
    implements HeightEvent {
        int step;
        double height;
        boolean endHere = false;

        public InstanceHeightEvent(int step) {
            this.step = step;
            this.height = Math.nextAfter((double)(step + 1) * OffsetSkeleton.this.interval, -1.0);
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean process(Skeleton skel) {
            ManyManyMap outputOldSegments;
            LoopL<Corner> copy = skel.capCopy(this.height);
            ManyManyMap<Corner, Corner> manyManyMap = skel.segmentMap;
            Objects.requireNonNull(manyManyMap);
            ManyManyMap manyManyMap2 = outputOldSegments = new ManyManyMap.ConvertInputCollection<Corner>(manyManyMap, skel.getSegmentOriginator()).get();
            Objects.requireNonNull(manyManyMap2);
            ManyManyMap<Corner, Corner> inputCapSegments = new ManyManyMap.ConvertInputCollection<Corner>(manyManyMap2, OffsetSkeleton.this.oldInputSegments.asCache()).get();
            inputCapSegments = inputCapSegments.getFlipShallow();
            OffsetSkeleton.this.output.add(new Offset(copy, inputCapSegments));
            if (this.endHere) {
                for (Corner c : skel.liveCorners) {
                    Corner top = skel.cornerMap.teg(c);
                    skel.output.addOutputSideTo(c, (Tuple3d)top, c.nextL, c.prevL);
                    skel.output.addOutputSideTo(true, (Tuple3d)top, top.nextC, c.nextL);
                }
                skel.liveEdges.clear();
                skel.liveCorners.clear();
                skel.qu.clearFaceEvents();
            }
            return false;
        }
    }

    public static interface DebugIntermediate {
        public void debugIntermediate(Skeleton var1);
    }
}

