/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.vecmath.Point2d;
import org.twak.camp.Output;
import org.twak.camp.ui.Bar;
import org.twak.camp.ui.PointEditor;
import org.twak.utils.LContext;
import org.twak.utils.Mathz;
import org.twak.utils.collections.Loop;

public class MedialPointEditor
extends PointEditor {
    boolean changed = true;
    boolean busy = false;
    Output output;
    double lastMaxdist = 100.0;

    public MedialPointEditor() {
        this.setLayout(new BorderLayout());
        JButton b = new JButton("save");
        this.add((Component)b, "North");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferedImage heightMap = new BufferedImage(MedialPointEditor.this.getMaxDim(), MedialPointEditor.this.getMaxDim(), 2);
                MedialPointEditor.this.paintPointEditor((Graphics2D)heightMap.getGraphics(), RenderOption.HEIGHTFIELD);
                BufferedImage alphaMap = new BufferedImage(MedialPointEditor.this.getMaxDim(), MedialPointEditor.this.getMaxDim(), 2);
                MedialPointEditor.this.paintPointEditor((Graphics2D)alphaMap.getGraphics(), RenderOption.ALPHA);
                try {
                    ImageIO.write((RenderedImage)heightMap, "png", new File("/media/ubuntu_disk/tmp/medialAxis/heightMap.png"));
                    ImageIO.write((RenderedImage)alphaMap, "png", new File("/media/ubuntu_disk/tmp/medialAxis/alphaMap.png"));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    int getMaxDim() {
        return Math.max(this.getWidth(), this.getHeight());
    }

    @Override
    public void movePoint(LContext<Bar> ctx, Point2d pt, Point2d location, MouseEvent evt) {
        this.changed = true;
        super.movePoint(ctx, pt, location, evt);
    }

    @Override
    public void remove(LContext<Bar> ctx, Point2d dragged) {
        this.changed = true;
        super.remove(ctx, dragged);
    }

    @Override
    public void addBetween(LContext<Bar> ctx, Point l) {
        this.changed = true;
        super.addBetween(ctx, l);
    }

    @Override
    public void painting(Point2d location, Point2d offset, MouseEvent evt) {
        this.repaint();
    }

    @Override
    public void paintPointEditor(Graphics2D g2) {
        this.paintPointEditor(g2, RenderOption.UI);
    }

    public void paintPointEditor(Graphics2D g2, RenderOption drawBorder) {
        g2.setColor(Color.white);
        if (drawBorder == RenderOption.HEIGHTFIELD) {
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Polygon border = new Polygon();
        for (Loop loop : this.edges) {
            for (Bar bar : loop) {
                border.addPoint(this.ma.toX(bar.start.x), this.ma.toY(bar.start.y));
            }
        }
        if (drawBorder != RenderOption.ALPHA) {
            if (!this.isDragging()) {
                double max = this.lastMaxdist;
                this.lastMaxdist = 0.0;
                for (int x = 0; x < this.getMaxDim(); ++x) {
                    for (int y = 0; y < this.getMaxDim(); ++y) {
                        double shortestDist = 3.4028234663852886E38;
                        Bar nearestBar = null;
                        int timeSeen = 0;
                        Point ptI = new Point(x, y);
                        if (!border.contains(ptI)) continue;
                        Point2d pt = this.ma.from(ptI);
                        for (Loop loop : this.edges) {
                            for (Bar bar : loop) {
                                double dist = bar.distance(pt);
                                if (!(dist < shortestDist)) continue;
                                if (shortestDist - dist < 2.0) {
                                    ++timeSeen;
                                }
                                shortestDist = dist;
                                nearestBar = bar;
                            }
                        }
                        this.lastMaxdist = Math.max(this.lastMaxdist, shortestDist);
                        int v = 255 - (int)(shortestDist * 255.0 / max);
                        v = Mathz.clamp(v, 0, 255);
                        g2.setColor(new Color(v, v, v));
                        g2.fillRect(x, y, 1, 1);
                    }
                }
            }
        } else {
            g2.setColor(new Color(128, 128, 128));
            g2.fill(border);
        }
        g2.setColor(new Color(0, 168, 40));
        if (drawBorder == RenderOption.UI) {
            g2.draw(border);
        }
    }

    static enum RenderOption {
        UI,
        HEIGHTFIELD,
        ALPHA;

    }
}

