/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.debug;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Output;
import org.twak.camp.ui.Bar;
import org.twak.camp.ui.PointEditor;
import org.twak.utils.Cache;
import org.twak.utils.LContext;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.ui.Colourz;
import org.twak.utils.ui.Rainbow;

public abstract class DebugPointEditor
extends PointEditor {
    LoopL<Corner> corners = null;
    Output output;
    Map<Point2d, Corner> cornerMap = new HashMap<Point2d, Corner>();
    Map<Bar, Edge> edgeMap = new HashMap<Bar, Edge>();
    Map<Corner, Color> highlights = new HashMap<Corner, Color>();
    Map<Edge, Color> highlightEdges = new HashMap<Edge, Color>();

    public DebugPointEditor(LoopL<Corner> c, Output output) {
        this.output = output;
        this.setupCorners(c);
        this.addMouseMotionListener(new HoverListener());
    }

    @Override
    protected void createInitial() {
        this.edges.clear();
        this.cornerMap.clear();
        this.edgeMap.clear();
        Cache<Corner, Point2d> cache = new Cache<Corner, Point2d>(){

            @Override
            public Point2d create(Corner i) {
                Point2d out = new Point2d(i.x, i.y);
                DebugPointEditor.this.cornerMap.put(out, i);
                return out;
            }
        };
        for (Loop loop : this.corners) {
            Loop<Bar> loop2 = new Loop<Bar>();
            this.edges.add(loop2);
            for (Corner c : loop) {
                Bar b = new Bar((Point2d)cache.get(c), (Point2d)cache.get(c.nextC));
                this.edgeMap.put(b, c.nextL);
                loop2.append(b);
            }
        }
    }

    @Override
    public void paintPointEditor(Graphics2D g2) {
        if (this.output != null && this.output.faces != null) {
            g2.setColor(new Color(0, 100, 100));
            g2.setStroke(new BasicStroke(4.0f));
            for (Output.Face face : this.output.faces.values()) {
                g2.setColor(new Color(50, 50, 50));
                g2.setStroke(new BasicStroke(3.0f));
                for (Output.SharedEdge sharedEdge : face.definingSE) {
                    Point3d s2 = sharedEdge.getStart(face);
                    Object e = sharedEdge.getEnd(face);
                    this.drawLine((Graphics)g2, s2, (Point3d)e);
                }
                g2.setColor(new Color(100, 100, 100));
                g2.setStroke(new BasicStroke(1.0f));
                for (Point3d point3d : face.results.map.keySet()) {
                    for (Point3d p2 : face.results.map.get(point3d)) {
                        this.drawLine((Graphics)g2, point3d, p2);
                    }
                }
            }
        }
        g2.setStroke(new BasicStroke(5.0f));
        for (Edge e : this.highlightEdges.keySet()) {
            g2.setColor(this.highlightEdges.get(e));
            this.drawLine(g2, e.start.x, e.start.y, e.end.x, e.end.y);
        }
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Colourz.transparent(Color.green, 140));
        for (Loop e2 : this.edges) {
            for (Bar bar : e2) {
            }
        }
        HashMap<Point3d, Integer> vCount = new HashMap<Point3d, Integer>();
        int j = 0;
        for (Loop loop : this.corners) {
            g2.setColor(Rainbow.getColour(j++));
            for (Loopable lc : loop.loopableIterator()) {
                Corner c1 = (Corner)lc.get();
                Corner c2 = (Corner)lc.getNext().get();
                this.drawLine(g2, c1.x, c1.y, c2.x, c2.y);
                for (Corner c : new Corner[]{c1}) {
                    Integer res = (Integer)vCount.get(new Point3d(c));
                    if (res == null) {
                        res = new Integer(0);
                    }
                    vCount.put(new Point3d(c), new Integer(res + 1));
                }
            }
        }
        g2.setColor(Color.black);
        g2.setBackground(Color.orange);
        for (Point3d point3d : vCount.keySet()) {
            g2.drawString(((Integer)vCount.get(point3d)).toString(), this.ma.toX(point3d.x) + 5, this.ma.toY(point3d.y) + 5);
        }
        g2.setColor(Color.green.darker().darker());
        for (Loop loop : this.edges) {
            for (Object e : loop) {
                this.drawPixel((Graphics)g2, ((Bar)e).start);
            }
        }
        for (Corner corner : this.highlights.keySet()) {
            g2.setColor(this.highlights.get(corner));
            this.drawPixel((Graphics)g2, new Point2d(corner.x, corner.y));
        }
    }

    private void setupCorners(LoopL<Corner> c) {
        this.corners = c;
        super.setup();
    }

    @Override
    public void movePoint(LContext<Bar> ctx, Point2d pt, Point2d location, MouseEvent evt) {
    }

    @Override
    protected boolean allowRemove(LContext<Bar> ctx, Point2d corner) {
        return false;
    }

    @Override
    public void addBetween(LContext<Bar> ctx, Point l) {
    }

    public abstract void hoverOver(Corner var1);

    public abstract void hoverOver(Edge var1);

    public abstract void hoverOver(Output.Face var1, Output var2);

    public void setHightLights(Map<Corner, Color> map) {
        this.highlights = map;
        this.repaint();
    }

    public class HoverListener
    extends MouseAdapter {
        @Override
        public void mouseMoved(MouseEvent e) {
            DebugPointEditor.this.highlightEdges.clear();
            double tol = DebugPointEditor.this.ma.fromZoom(10.0);
            Point2d from = DebugPointEditor.this.ma.from(e);
            LContext<Bar> bar = DebugPointEditor.this.getNearest(from, tol);
            if (bar != null) {
                for (Point2d p : new Point2d[]{bar.get().start, bar.get().end}) {
                    if (!(p.distance(from) < tol)) continue;
                    Corner corner = DebugPointEditor.this.cornerMap.get(p);
                    DebugPointEditor.this.highlightEdges.put(corner.nextL, Color.green.darker());
                    DebugPointEditor.this.highlightEdges.put(corner.prevL, Color.red.darker());
                    DebugPointEditor.this.hoverOver(corner);
                    return;
                }
                DebugPointEditor.this.hoverOver(DebugPointEditor.this.edgeMap.get(bar.get()));
            } else if (DebugPointEditor.this.output != null) {
                if (DebugPointEditor.this.corners.isEmpty()) {
                    for (Output.Face f : DebugPointEditor.this.output.faces.values()) {
                        Corner s2 = f.edge.start;
                        Corner ee = f.edge.end;
                        Bar b = new Bar(new Point2d(s2.x, s2.y), new Point2d(ee.x, ee.y));
                        if (!(b.distance(from) < tol)) continue;
                        DebugPointEditor.this.hoverOver(f, DebugPointEditor.this.output);
                    }
                }
                DebugPointEditor.this.hoverOver((Edge)null);
                return;
            }
        }
    }
}

