/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Tag;

public interface EdgeCreator {
    public List<Corner> getEdges(Edge var1, Corner var2, Corner var3);

    public Set<Tag> getFeaturesFor(Edge var1);

    public static class DefaultEdgeCreator
    implements EdgeCreator {
        @Override
        public List<Corner> getEdges(Edge old, Corner startH, Corner endH) {
            ArrayList<Corner> out = new ArrayList<Corner>();
            startH.nextL = old;
            endH.prevL = old;
            out.add(startH);
            out.add(endH);
            return out;
        }

        @Override
        public Set<Tag> getFeaturesFor(Edge edgeH) {
            return new HashSet<Tag>();
        }
    }
}

