/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import org.tinspin.index.rtree.RTreeEntry;
import org.tinspin.index.rtree.RTreeNode;

class RTreeNodeLeaf<T>
extends RTreeNode<T> {
    private ArrayList<RTreeEntry<T>> entries = new ArrayList();

    public RTreeNodeLeaf(int dim) {
        super(dim);
    }

    @Override
    public void addEntry(RTreeEntry<T> e) {
        this.entries.add(e);
        if (this.entries.size() > 1) {
            this.extendMBB(e);
        } else {
            this.setMBB(e);
        }
    }

    @Override
    public ArrayList<RTreeEntry<T>> getEntries() {
        return this.entries;
    }

    @Override
    public void clear() {
        this.entries.clear();
        this.resetMBB();
    }

    @Override
    public boolean hasSpace() {
        return this.entries.size() < 10;
    }

    @Override
    public String toString() {
        double[] len = new double[this.min().length];
        Arrays.setAll(len, i -> this.max()[i] - this.min()[i]);
        return "NodeData;n=" + this.entries.size() + ";min/max=" + Arrays.toString(this.min()) + "/" + Arrays.toString(this.max()) + ";lengths=" + Arrays.toString(len) + ";id=" + System.identityHashCode(this);
    }

    @Override
    public boolean isUnderfull() {
        return this.entries.size() < 2;
    }
}

