/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.Index;
import org.tinspin.index.rtree.Filter;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeEntry;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;
import org.tinspin.index.rtree.RTreeNodeLeaf;

class RTreeMixedQuery<T>
implements Iterator<Index.BoxEntryKnn<T>> {
    private final RTree<T> tree;
    private final double[] center;
    private final BoxDistance dist;
    private final BoxDistance closestDist;
    private final PriorityQueue<RTreeNodeWrapper<T>> queue = new PriorityQueue();
    private final Filter filter;
    private RTreeEntryWrapper<T> next;
    private RTreeEntryWrapper<T> current;
    private double distanceOfLastReturnedNode = Double.NEGATIVE_INFINITY;
    private List<RTreeNodeWrapper<T>> nodesAlreadyReturnedWithSameDist = new ArrayList<RTreeNodeWrapper<T>>();
    private int remove_pointerLoss;
    private int remove_hit;

    public RTreeMixedQuery(RTree<T> tree, double[] center, Filter filter, BoxDistance dist, BoxDistance closestDist) {
        this.tree = tree;
        this.center = center;
        this.closestDist = closestDist;
        this.filter = filter;
        this.dist = dist;
        this.init();
    }

    private void init() {
        this.insert(this.tree.getRoot());
    }

    private RTreeNodeWrapper<T> insert(RTreeNode<T> node) {
        if (!this.filter.intersects(node.min(), node.max())) {
            return null;
        }
        RTreeNodeWrapper<T> wrapped = new RTreeNodeWrapper<T>(node, this.closestDist.dist(this.center, node.min(), node.max()));
        this.queue.add(wrapped);
        return wrapped;
    }

    private RTreeEntryWrapper<T> findNext() {
        RTreeEntryWrapper nextElement = null;
        while (nextElement == null && !this.queue.isEmpty()) {
            RTreeNodeWrapper<T> top = this.queue.poll();
            RTreeEntry ent = top.node;
            if (ent instanceof RTreeNodeDir) {
                this.processNode((RTreeNodeDir)ent);
            } else if (ent instanceof RTreeNodeLeaf) {
                this.processNode((RTreeNodeLeaf)ent);
            } else {
                assert (top.value() != null);
                nextElement = (RTreeEntryWrapper)top;
            }
            if (nextElement == null) continue;
            if (nextElement.dist() > this.distanceOfLastReturnedNode) {
                this.distanceOfLastReturnedNode = nextElement.dist();
                this.nodesAlreadyReturnedWithSameDist.clear();
                continue;
            }
            if (nextElement.dist() < this.distanceOfLastReturnedNode) {
                nextElement = null;
                continue;
            }
            if (!this.nodesAlreadyReturnedWithSameDist.contains(nextElement)) continue;
            nextElement = null;
        }
        if (nextElement != null) {
            this.nodesAlreadyReturnedWithSameDist.add(nextElement);
        }
        return nextElement;
    }

    private void processNode(RTreeNodeDir<T> node) {
        ArrayList<RTreeNode<T>> children = node.getChildren();
        assert (node.value() == null);
        assert (children.size() > 0);
        for (int i = 0; i < children.size(); ++i) {
            this.insert(children.get(i));
        }
    }

    private boolean processNode(RTreeNodeLeaf<T> node) {
        ArrayList<RTreeEntry<T>> entries = node.getEntries();
        assert (node.value() == null);
        for (int i = 0; i < entries.size(); ++i) {
            RTreeEntry<T> ent = entries.get(i);
            assert (!(ent instanceof RTreeNode));
            this.insert(ent, node, i);
        }
        return !entries.isEmpty();
    }

    private void insert(RTreeEntry<T> ent, RTreeNodeLeaf<T> parent, int idx) {
        if (!this.filter.matches(ent)) {
            return;
        }
        assert (parent.getParent() == null || this.isTreeNode(parent));
        assert (!(ent instanceof RTreeNode));
        double distance = this.dist.dist(this.center, ent.min(), ent.max());
        if (distance < this.distanceOfLastReturnedNode) {
            return;
        }
        RTreeEntryWrapper<T> wrapped = new RTreeEntryWrapper<T>(ent, distance, idx, parent);
        if (distance == this.distanceOfLastReturnedNode && this.nodesAlreadyReturnedWithSameDist.contains(wrapped)) {
            return;
        }
        this.queue.add(wrapped);
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.findNext();
        }
        return this.next != null;
    }

    @Override
    public Index.BoxEntryKnn<T> next() {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        this.current = this.next;
        this.next = null;
        return this.current;
    }

    public String toString() {
        return "RTreeMixedQuery [queueSize=" + this.queueSize() + ", rm.loss=" + this.remove_pointerLoss + ", rm.hit=" + this.remove_hit + ", center=" + Arrays.toString(this.center) + ", dist=" + this.dist + "]";
    }

    int queueSize() {
        return this.queue.size();
    }

    public void remove(RTreeEntryWrapper<T> e) {
        RTreeEntry toDelete = e.node;
        int pos = e.idx;
        RTreeNodeLeaf parent = e.parent;
        if (parent.getEntries().size() <= pos || toDelete != parent.getEntries().get(pos)) {
            pos = parent.getEntries().indexOf(toDelete);
        }
        if (pos == -1 || parent.getParent() == null) {
            if ($assertionsDisabled || this.remove_pointerLoss++ <= 0) {
                // empty if block
            }
            if (this.tree.remove(e.min(), e.max()) == null) {
                throw new IllegalStateException("Node not found");
            }
        } else {
            if ($assertionsDisabled || this.remove_hit++ <= 0) {
                // empty if block
            }
            assert (this.isTreeNode(parent));
            this.tree.deleteFromNode(parent, pos);
        }
    }

    private boolean isTreeNode(RTreeNode<T> parent) {
        if (parent == this.tree.getRoot()) {
            return true;
        }
        if (!parent.getParent().getChildren().contains(parent)) {
            return false;
        }
        return this.isTreeNode(parent.getParent());
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.remove(this.current);
        this.checkQueueAfterRemove();
    }

    void checkQueueAfterRemove() {
        ArrayList toReinsert = new ArrayList();
        Iterator<RTreeNodeWrapper<T>> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            RTreeNodeWrapper<T> e = iterator.next();
            RTreeEntry node = e.node;
            if (!(node instanceof RTreeNode)) continue;
            double actualDist = this.closestDist.dist(this.center, node.min(), node.max());
            if (!(e.dist() > actualDist)) continue;
            iterator.remove();
            toReinsert.add(new RTreeNodeWrapper(node, actualDist));
        }
        if (!toReinsert.isEmpty()) {
            this.queue.addAll(toReinsert);
        }
    }

    private static class RTreeEntryWrapper<T>
    extends RTreeNodeWrapper<T> {
        int idx;
        RTreeNodeLeaf<T> parent;

        RTreeEntryWrapper(RTreeEntry<T> node, double distance, int idx, RTreeNodeLeaf<T> parent) {
            super(node, distance);
            this.idx = idx;
            this.parent = parent;
        }
    }

    private static class RTreeNodeWrapper<T>
    extends Index.BoxEntryKnn<T>
    implements Comparable<RTreeNodeWrapper<T>> {
        RTreeEntry<T> node;

        RTreeNodeWrapper(RTreeEntry<T> node, double distance) {
            super(node.min(), node.max(), node.value(), distance);
            this.node = node;
        }

        @Override
        public double[] min() {
            return this.node.min();
        }

        public String toString() {
            return "RTreeNodeWrapper [lower()=" + Arrays.toString(this.min()) + ", upper()=" + Arrays.toString(this.max()) + ", value()=" + this.value() + ", dist()=" + this.dist() + "]";
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RTreeNodeWrapper other = (RTreeNodeWrapper)obj;
            return !(this.node == null ? other.node != null : !this.node.equals(other.node));
        }

        @Override
        public int compareTo(RTreeNodeWrapper<T> o) {
            return Double.compare(this.dist(), o.dist());
        }
    }
}

