/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.Arrays;
import org.tinspin.index.Index;

public class RTreeEntry<T>
extends Index.BoxEntry<T> {
    public static <T> RTreeEntry<T> createBox(double[] min2, double[] max, T value) {
        return new RTreeEntry<T>(min2, max, value);
    }

    public static <T> RTreeEntry<T> createPoint(double[] point, T value) {
        return new RTreeEntry<T>(point, point, value);
    }

    RTreeEntry(double[] min2, double[] max, T val) {
        super(min2, max, val);
    }

    double calcOverlap(RTreeEntry<T> e) {
        double area = 1.0;
        for (int i = 0; i < this.min().length; ++i) {
            double d = Math.min(this.max()[i], e.max()[i]) - Math.max(this.min()[i], e.min()[i]);
            if (d <= 0.0) {
                return 0.0;
            }
            area *= d;
        }
        return area;
    }

    public boolean checkInclusion(double[] min2, double[] max2) {
        for (int i = 0; i < this.min().length; ++i) {
            if (!(this.min()[i] > min2[i]) && !(this.max()[i] < max2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean checkExactMatch(double[] min2, double[] max2) {
        for (int i = 0; i < this.min().length; ++i) {
            if (this.min()[i] == min2[i] && this.max()[i] == max2[i]) continue;
            return false;
        }
        return true;
    }

    public double calcArea() {
        double area = 1.0;
        for (int i = 0; i < this.min().length; ++i) {
            double d = this.max()[i] - this.min()[i];
            area *= d;
        }
        return area;
    }

    public void setToCover(RTreeEntry<T> e1, RTreeEntry<T> e2) {
        for (int i = 0; i < this.min().length; ++i) {
            this.min()[i] = Math.min(e1.min()[i], e2.min()[i]);
            this.max()[i] = Math.max(e1.max()[i], e2.max()[i]);
        }
    }

    public static double calcVolume(RTreeEntry<?> e) {
        return RTreeEntry.calcVolume(e.min(), e.max());
    }

    public static double calcVolume(double[] min2, double[] max) {
        double v = 1.0;
        for (int d = 0; d < min2.length; ++d) {
            v *= max[d] - min2[d];
        }
        return v;
    }

    public static void calcBoundingBox(RTreeEntry<?>[] entries, int start, int end, double[] minOut, double[] maxOut) {
        System.arraycopy(entries[start].min(), 0, minOut, 0, minOut.length);
        System.arraycopy(entries[start].max(), 0, maxOut, 0, maxOut.length);
        for (int i = start + 1; i < end; ++i) {
            for (int d = 0; d < minOut.length; ++d) {
                minOut[d] = Math.min(minOut[d], entries[i].min()[d]);
                maxOut[d] = Math.max(maxOut[d], entries[i].max()[d]);
            }
        }
    }

    public static double calcOverlap(double[] min1, double[] max1, double[] min2, double[] max2) {
        double area = 1.0;
        for (int i = 0; i < min1.length; ++i) {
            double d = Math.min(max1[i], max2[i]) - Math.max(min1[i], min2[i]);
            if (d <= 0.0) {
                return 0.0;
            }
            area *= d;
        }
        return area;
    }

    public static boolean checkOverlap(double[] min2, double[] max, RTreeEntry<?> e) {
        for (int i = 0; i < min2.length; ++i) {
            if (!(min2[i] > e.max()[i]) && !(max[i] < e.min()[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean calcIncludes(double[] minOut, double[] maxOut, double[] minIn, double[] maxIn) {
        for (int i = 0; i < minOut.length; ++i) {
            if (!(minOut[i] > minIn[i]) && !(maxOut[i] < maxIn[i])) continue;
            return false;
        }
        return true;
    }

    public static double calcDeadspace(RTreeEntry<?>[] entries, int start, int end, double[] minOut, double[] maxOut) {
        Arrays.fill(minOut, Double.POSITIVE_INFINITY);
        Arrays.fill(maxOut, Double.NEGATIVE_INFINITY);
        double volumeSum = 0.0;
        for (int i = start; i < end; ++i) {
            double v = 1.0;
            for (int d = 0; d < minOut.length; ++d) {
                minOut[d] = Math.min(minOut[d], entries[i].min()[d]);
                maxOut[d] = Math.max(maxOut[d], entries[i].max()[d]);
                v *= entries[i].max()[d] - entries[i].min()[d];
            }
            volumeSum += v;
        }
        return RTreeEntry.calcVolume(minOut, maxOut) - volumeSum;
    }

    public static double calcMargin(double[] min2, double[] max2) {
        double d = 0.0;
        for (int i = 0; i < min2.length; ++i) {
            d += max2[i] - min2[i];
        }
        return d;
    }

    public static double calcCenterDistance(RTreeEntry<?> e1, RTreeEntry<?> e2) {
        double[] min1 = e1.min();
        double[] max1 = e1.max();
        double[] min2 = e2.min();
        double[] max2 = e2.max();
        double dist = 0.0;
        for (int i = 0; i < min1.length; ++i) {
            double d = min1[i] + max1[i] - (min2[i] + max2[i]);
            dist += (d *= 0.5) * d;
        }
        return Math.sqrt(dist);
    }

    public String toString() {
        double[] len = new double[this.min().length];
        Arrays.setAll(len, i -> this.max()[i] - this.min()[i]);
        return Arrays.toString(this.min()) + "/" + Arrays.toString(this.max()) + ";len=" + Arrays.toString(len) + ";v=" + this.value();
    }

    protected void set(RTreeEntry<T> e) {
        super.set(e.min(), e.max(), e.value());
    }
}

