/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import java.util.NoSuchElementException;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.qtplain.QNode;
import org.tinspin.index.qtplain.QUtil;
import org.tinspin.index.util.MinHeap;
import org.tinspin.index.util.MinMaxHeap;

public class QIteratorKnn<T>
implements Index.PointIteratorKnn<T> {
    private final QNode<T> root;
    private final PointDistance distFn;
    private final Index.PointFilterKnn<T> filterFn;
    MinHeap<NodeDistT> queueN = MinHeap.create((t1, t2) -> t1.dist < t2.dist);
    MinMaxHeap<Index.PointEntryKnn<T>> queueV = MinMaxHeap.create((t1, t2) -> t1.dist() < t2.dist());
    double maxNodeDist = Double.POSITIVE_INFINITY;
    private Index.PointEntryKnn<T> current;
    private int remaining;
    private double[] center;
    private double currentDistance;

    QIteratorKnn(QNode<T> root, int minResults, double[] center, PointDistance distFn, Index.PointFilterKnn<T> filterFn) {
        this.filterFn = filterFn;
        this.distFn = distFn;
        this.root = root;
        this.reset(center, minResults);
    }

    @Override
    public Index.PointIteratorKnn<T> reset(double[] center, int minResults) {
        this.center = center;
        this.currentDistance = Double.MAX_VALUE;
        this.remaining = minResults;
        this.maxNodeDist = Double.POSITIVE_INFINITY;
        this.current = null;
        if (minResults <= 0 || this.root == null) {
            return this;
        }
        this.queueN.clear();
        this.queueV.clear();
        this.queueN.push(new NodeDistT(0.0, this.root));
        this.findNextElement();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public Index.PointEntryKnn<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Index.PointEntryKnn<T> ret = this.current;
        this.findNextElement();
        return ret;
    }

    public double distance() {
        return this.currentDistance;
    }

    private void findNextElement() {
        while (!(this.remaining <= 0 || this.queueN.isEmpty() && this.queueV.isEmpty())) {
            boolean useV;
            boolean bl = useV = !this.queueV.isEmpty();
            if (useV && !this.queueN.isEmpty()) {
                boolean bl2 = useV = this.queueV.peekMin().dist() <= this.queueN.peekMin().dist;
            }
            if (useV) {
                Index.PointEntryKnn<T> result = this.queueV.peekMin();
                this.queueV.popMin();
                --this.remaining;
                this.current = result;
                this.currentDistance = result.dist();
                return;
            }
            NodeDistT top = this.queueN.peekMin();
            this.queueN.popMin();
            QNode node = top.node;
            double dNode = top.dist;
            if (dNode > this.maxNodeDist && this.queueV.size() >= this.remaining) continue;
            if (node.isLeaf()) {
                for (Index.PointEntry pointEntry : node.getEntries()) {
                    double d;
                    if (!this.filterFn.test(pointEntry, d = this.distFn.dist(this.center, pointEntry.point())) || !(d <= this.maxNodeDist)) continue;
                    this.queueV.push(new Index.PointEntryKnn(pointEntry, d));
                    if (this.queueV.size() < this.remaining) continue;
                    if (this.queueV.size() > this.remaining) {
                        this.queueV.popMax();
                    }
                    double dMax = this.queueV.peekMax().dist();
                    this.maxNodeDist = Math.min(this.maxNodeDist, dMax);
                }
                continue;
            }
            for (QNode qNode : node.getChildNodes()) {
                double dist = QUtil.distToRectNode(this.center, qNode.getCenter(), qNode.getRadius(), this.distFn);
                if (!(dist <= this.maxNodeDist)) continue;
                this.queueN.push(new NodeDistT(dist, qNode));
            }
        }
        this.current = null;
        this.currentDistance = Double.MAX_VALUE;
    }

    private class NodeDistT {
        double dist;
        QNode<T> node;

        public NodeDistT(double dist, QNode<T> node) {
            this.dist = dist;
            this.node = node;
        }
    }
}

