/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.kdtree;

import java.util.NoSuchElementException;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.kdtree.Node;
import org.tinspin.index.util.MinHeap;
import org.tinspin.index.util.MinMaxHeap;

public class KDIteratorKnn<T>
implements Index.PointIteratorKnn<T> {
    private final Node<T> root;
    private final PointDistance distFn;
    private final Index.PointFilterKnn<T> filterFn;
    MinHeap<NodeDist<T>> queueN = MinHeap.create((t1, t2) -> t1.closestDist < t2.closestDist);
    MinMaxHeap<Index.PointEntryKnn<T>> queueV = MinMaxHeap.create((t1, t2) -> t1.dist() < t2.dist());
    double maxNodeDist = Double.POSITIVE_INFINITY;
    private Index.PointEntryKnn<T> current;
    private int remaining;
    private double[] center;
    private double currentDistance;

    KDIteratorKnn(Node<T> root, int minResults, double[] center, PointDistance distFn, Index.PointFilterKnn<T> filterFn) {
        this.filterFn = filterFn;
        this.distFn = distFn;
        this.root = root;
        this.reset(center, minResults);
    }

    @Override
    public Index.PointIteratorKnn<T> reset(double[] center, int minResults) {
        this.center = center;
        this.currentDistance = Double.MAX_VALUE;
        this.remaining = minResults;
        this.maxNodeDist = Double.POSITIVE_INFINITY;
        this.current = null;
        if (minResults <= 0 || this.root == null) {
            return this;
        }
        this.queueN.clear();
        this.queueV.clear();
        double[] closest = (double[])center.clone();
        this.queueN.push(new NodeDist<T>(this.distFn.dist(center, closest), this.root, closest));
        this.findNextElement();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public Index.PointEntryKnn<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Index.PointEntryKnn<T> ret = this.current;
        this.findNextElement();
        return ret;
    }

    public double distance() {
        return this.currentDistance;
    }

    private void findNextElement() {
        while (!(this.remaining <= 0 || this.queueN.isEmpty() && this.queueV.isEmpty())) {
            boolean useV;
            boolean bl = useV = !this.queueV.isEmpty();
            if (useV && !this.queueN.isEmpty()) {
                boolean bl2 = useV = this.queueV.peekMin().dist() <= this.queueN.peekMin().closestDist;
            }
            if (useV) {
                Index.PointEntryKnn<T> result = this.queueV.peekMin();
                this.queueV.popMin();
                --this.remaining;
                this.current = result;
                this.currentDistance = result.dist();
                return;
            }
            NodeDist<T> entry = this.queueN.peekMin();
            this.queueN.popMin();
            if (entry.closestDist > this.maxNodeDist && this.queueV.size() >= this.remaining) continue;
            Node node = entry.node;
            double d = this.distFn.dist(this.center, node.point());
            if (this.filterFn.test(node, d) && d <= this.maxNodeDist) {
                this.queueV.push(new Index.PointEntryKnn(node, d));
                if (this.queueV.size() >= this.remaining) {
                    if (this.queueV.size() > this.remaining) {
                        this.queueV.popMax();
                    }
                    double dMax = this.queueV.peekMax().dist();
                    this.maxNodeDist = Math.min(this.maxNodeDist, dMax);
                }
            }
            if (node.getLo() != null) {
                this.createEntryLo(entry);
            }
            if (node.getHi() == null) continue;
            this.createEntryHi(entry);
        }
        this.current = null;
        this.currentDistance = Double.POSITIVE_INFINITY;
    }

    void createEntryHi(NodeDist<T> entry) {
        double newClosestDist;
        double[] newClosest;
        double splitX;
        Node node = entry.node;
        int splitDim = node.getDim();
        if (this.center[splitDim] < (splitX = node.point()[splitDim])) {
            newClosest = (double[])entry.closest.clone();
            newClosest[splitDim] = splitX;
            newClosestDist = this.distFn.dist(newClosest, this.center);
        } else {
            newClosest = entry.closest;
            newClosestDist = entry.closestDist;
        }
        if (newClosestDist <= this.maxNodeDist) {
            this.queueN.push(new NodeDist(newClosestDist, node.getHi(), newClosest));
        }
    }

    void createEntryLo(NodeDist<T> entry) {
        double newClosestDist;
        double[] newClosest;
        double splitX;
        Node node = entry.node;
        int splitDim = node.getDim();
        if (this.center[splitDim] > (splitX = node.point()[splitDim])) {
            newClosest = (double[])entry.closest.clone();
            newClosest[splitDim] = splitX;
            newClosestDist = this.distFn.dist(newClosest, this.center);
        } else {
            newClosest = entry.closest;
            newClosestDist = entry.closestDist;
        }
        if (newClosestDist <= this.maxNodeDist) {
            this.queueN.push(new NodeDist(newClosestDist, node.getLo(), newClosest));
        }
    }

    private static class NodeDist<T> {
        double closestDist;
        Node<T> node;
        double[] closest;

        NodeDist(double closestDist, Node<T> node, double[] closest) {
            this.closestDist = closestDist;
            this.node = node;
            this.closest = closest;
        }
    }
}

