/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.critbit;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tinspin.index.critbit.BitTools;

public class CritBit64<V>
implements Iterable<V> {
    protected static final int DEPTH = 64;
    protected AtomicInfo<V> info = new AtomicInfo();

    protected CritBit64() {
    }

    public static <V> CritBit64<V> create() {
        return new CritBit64<V>();
    }

    /*
     * Enabled aggressive block sorting
     */
    public V put(long key, V val) {
        if (this.info.size == 0) {
            this.info.rootKey = key;
            this.info.rootVal = val;
            ++this.info.size;
            return null;
        }
        if (this.info.size == 1) {
            Node<V> n2 = this.createNode(key, val, this.info.rootKey, this.info.rootVal);
            if (n2 == null) {
                Object prev = this.info.rootVal;
                this.info.rootVal = val;
                return prev;
            }
            this.info.root = n2;
            this.info.rootKey = CritBit64.extractPrefix(key, n2.posDiff - 1);
            this.info.rootVal = null;
            ++this.info.size;
            return null;
        }
        Node n = this.info.root;
        int parentPosDiff = -1;
        long prefix = this.info.rootKey;
        Node parent = null;
        boolean isCurrentChildLo = false;
        while (true) {
            block18: {
                int posDiff;
                if (parentPosDiff + 1 != n.posDiff && (posDiff = CritBit64.compare(key, prefix)) < n.posDiff && posDiff != -1) {
                    Node<Object> newSub;
                    long subPrefix = CritBit64.extractPrefix(prefix, posDiff - 1);
                    if (BitTools.getBit(key, posDiff)) {
                        newSub = new Node<Object>(prefix, null, key, val, posDiff);
                        newSub.lo = n;
                    } else {
                        newSub = new Node<Object>(key, val, prefix, null, posDiff);
                        newSub.hi = n;
                    }
                    if (parent == null) {
                        this.info.rootKey = subPrefix;
                        this.info.root = newSub;
                    } else if (isCurrentChildLo) {
                        parent.loPost = subPrefix;
                        parent.lo = newSub;
                    } else {
                        parent.hiPost = subPrefix;
                        parent.hi = newSub;
                    }
                    ++this.info.size;
                    return null;
                }
                if (BitTools.getBit(key, (int)n.posDiff)) {
                    if (n.hi != null) {
                        prefix = n.hiPost;
                        parent = n;
                        n = n.hi;
                        isCurrentChildLo = false;
                        break block18;
                    } else {
                        Node<V> n2 = this.createNode(key, val, n.hiPost, n.hiVal);
                        if (n2 == null) {
                            Object prev = n.hiVal;
                            n.hiVal = val;
                            return prev;
                        }
                        n.hi = n2;
                        n.hiPost = CritBit64.extractPrefix(key, n2.posDiff - 1);
                        n.hiVal = null;
                        ++this.info.size;
                        return null;
                    }
                }
                if (n.lo != null) {
                    prefix = n.loPost;
                    parent = n;
                    n = n.lo;
                    isCurrentChildLo = true;
                } else {
                    Node<V> n2 = this.createNode(key, val, n.loPost, n.loVal);
                    if (n2 == null) {
                        Object prev = n.loVal;
                        n.loVal = val;
                        return prev;
                    }
                    n.lo = n2;
                    n.loPost = CritBit64.extractPrefix(key, n2.posDiff - 1);
                    n.loVal = null;
                    ++this.info.size;
                    return null;
                }
            }
            parentPosDiff = n.posDiff;
        }
    }

    public void printTree() {
        System.out.println("Tree: \n" + this.toString());
    }

    public String toString() {
        if (this.info.size == 0) {
            return "- -";
        }
        if (this.info.root == null) {
            return "-" + BitTools.toBinary(this.info.rootKey, 64) + " v=" + this.info.rootVal;
        }
        Node n = this.info.root;
        StringBuilder s2 = new StringBuilder();
        this.printNode(n, s2, "", 0, this.info.rootKey);
        return s2.toString();
    }

    private void printNode(Node<V> n, StringBuilder s2, String level, int currentDepth, long infix) {
        char NL = '\n';
        if (currentDepth != n.posDiff) {
            s2.append(level + "n: " + currentDepth + "/" + n.posDiff + " " + BitTools.toBinary(infix, 64) + NL);
        } else {
            s2.append(level + "n: " + currentDepth + "/" + n.posDiff + " i=0" + NL);
        }
        if (n.lo != null) {
            this.printNode(n.lo, s2, level + "-", n.posDiff + 1, n.loPost);
        } else {
            s2.append(level + " " + BitTools.toBinary(n.loPost, 64) + " v=" + n.loVal + NL);
        }
        if (n.hi != null) {
            this.printNode(n.hi, s2, level + "-", n.posDiff + 1, n.hiPost);
        } else {
            s2.append(level + " " + BitTools.toBinary(n.hiPost, 64) + " v=" + n.hiVal + NL);
        }
    }

    public boolean checkTree() {
        if (this.info.root == null) {
            if (this.info.size > 1) {
                System.err.println("root node = null AND size = " + this.info.size);
                return false;
            }
            return true;
        }
        return this.checkNode(this.info.root, 0, this.info.rootKey);
    }

    private boolean checkNode(Node<V> n, int firstBitOfNode, long prefix) {
        if (n.posDiff < firstBitOfNode) {
            System.err.println("prefix with len=0 detected!");
            return false;
        }
        if (n.lo != null) {
            if (!this.doesPrefixMatch(n.posDiff - 1, n.loPost, prefix)) {
                System.err.println("lo: prefix mismatch");
                return false;
            }
            this.checkNode(n.lo, n.posDiff + 1, n.loPost);
        }
        if (n.hi != null) {
            if (!this.doesPrefixMatch(n.posDiff - 1, n.hiPost, prefix)) {
                System.err.println("hi: prefix mismatch");
                return false;
            }
            this.checkNode(n.hi, n.posDiff + 1, n.hiPost);
        }
        return true;
    }

    private Node<V> createNode(long k1, V val1, long k2, V val2) {
        int posDiff = CritBit64.compare(k1, k2);
        if (posDiff == -1) {
            return null;
        }
        if (BitTools.getBit(k2, posDiff)) {
            return new Node<V>(k1, val1, k2, val2, posDiff);
        }
        return new Node<V>(k2, val2, k1, val1, posDiff);
    }

    private static long extractPrefix(long v, int endPos) {
        long inf = v;
        if (endPos < 63) {
            inf &= -1L >>> 1 + endPos ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return inf;
    }

    private boolean doesPrefixMatch(int posDiff, long v, long prefix) {
        if (posDiff > 0) {
            return (v ^ prefix) >>> 64 - posDiff == 0L;
        }
        return true;
    }

    private static int compare(long v1, long v2) {
        return v1 == v2 ? -1 : Long.numberOfLeadingZeros(v1 ^ v2);
    }

    public int size() {
        return this.info.size;
    }

    public boolean contains(long key) {
        if (this.info.size == 0) {
            return false;
        }
        if (this.info.size == 1) {
            return key == this.info.rootKey;
        }
        Node n = this.info.root;
        long prefix = this.info.rootKey;
        while (this.doesPrefixMatch(n.posDiff, key, prefix)) {
            if (BitTools.getBit(key, (int)n.posDiff)) {
                if (n.hi != null) {
                    prefix = n.hiPost;
                    n = n.hi;
                    continue;
                }
                return key == n.hiPost;
            }
            if (n.lo != null) {
                prefix = n.loPost;
                n = n.lo;
                continue;
            }
            return key == n.loPost;
        }
        return false;
    }

    public V get(long key) {
        if (this.info.size == 0) {
            return null;
        }
        if (this.info.size == 1) {
            return key == this.info.rootKey ? (V)this.info.rootVal : null;
        }
        Node n = this.info.root;
        long prefix = this.info.rootKey;
        while (this.doesPrefixMatch(n.posDiff, key, prefix)) {
            if (BitTools.getBit(key, (int)n.posDiff)) {
                if (n.hi != null) {
                    prefix = n.hiPost;
                    n = n.hi;
                    continue;
                }
                return key == n.hiPost ? (V)n.hiVal : null;
            }
            if (n.lo != null) {
                prefix = n.loPost;
                n = n.lo;
                continue;
            }
            return key == n.loPost ? (V)n.loVal : null;
        }
        return null;
    }

    public V remove(long key) {
        if (this.info.size == 0) {
            return null;
        }
        if (this.info.size == 1) {
            if (key == this.info.rootKey) {
                --this.info.size;
                this.info.rootKey = 0L;
                Object prev = this.info.rootVal;
                this.info.rootVal = null;
                return prev;
            }
            return null;
        }
        Node n = this.info.root;
        Node parent = null;
        boolean isParentHigh = false;
        long prefix = this.info.rootKey;
        while (this.doesPrefixMatch(n.posDiff, key, prefix)) {
            if (BitTools.getBit(key, (int)n.posDiff)) {
                if (n.hi != null) {
                    isParentHigh = true;
                    prefix = n.hiPost;
                    parent = n;
                    n = n.hi;
                    continue;
                }
                if (key != n.hiPost) {
                    return null;
                }
                this.updateParentAfterRemove(parent, n.loPost, n.loVal, n.lo, isParentHigh);
                return n.hiVal;
            }
            if (n.lo != null) {
                isParentHigh = false;
                prefix = n.loPost;
                parent = n;
                n = n.lo;
                continue;
            }
            if (key != n.loPost) {
                return null;
            }
            this.updateParentAfterRemove(parent, n.hiPost, n.hiVal, n.hi, isParentHigh);
            return n.loVal;
        }
        return null;
    }

    private void updateParentAfterRemove(Node<V> parent, long newPost, V newVal, Node<V> newSub, boolean isParentHigh) {
        long l = newPost = newSub == null ? newPost : CritBit64.extractPrefix(newPost, newSub.posDiff - 1);
        if (parent == null) {
            this.info.rootKey = newPost;
            this.info.rootVal = newVal;
            this.info.root = newSub;
        } else if (isParentHigh) {
            parent.hiPost = newPost;
            parent.hiVal = newVal;
            parent.hi = newSub;
        } else {
            parent.loPost = newPost;
            parent.loVal = newVal;
            parent.lo = newSub;
        }
        --this.info.size;
    }

    @Override
    public CBIterator<V> iterator() {
        return new CBIterator().reset(this);
    }

    public QueryIterator<V> query(long min2, long max) {
        return new QueryIterator().reset(this, min2, max);
    }

    public QueryIteratorMask<V> queryWithMask(long min2, long max) {
        return new QueryIteratorMask().reset(this, min2, max);
    }

    public static class Entry<V> {
        private final long key;
        private final V value;

        Entry(long key, V value) {
            this.key = key;
            this.value = value;
        }

        public long key() {
            return this.key;
        }

        public V value() {
            return this.value;
        }
    }

    public static class QueryIteratorMask<V>
    implements Iterator<V> {
        private long minOrig;
        private long maxOrig;
        private long nextKey = 0L;
        private V nextValue = null;
        boolean hasNext = true;
        private final Node<V>[] stack = new Node[64];
        private static final byte READ_LOWER = 0;
        private static final byte READ_UPPER = 1;
        private static final byte RETURN_TO_PARENT = 2;
        private final byte[] readHigherNext = new byte[64];
        private final long[] prefixes = new long[64];
        private int stackTop = -1;

        public QueryIteratorMask<V> reset(CritBit64<V> cb, long minOrig, long maxOrig) {
            this.stackTop = -1;
            this.hasNext = true;
            this.readHigherNext[0] = 0;
            AtomicInfo info = cb.info;
            this.minOrig = minOrig;
            this.maxOrig = maxOrig;
            if (info.size == 0) {
                this.hasNext = false;
                return this;
            }
            if (info.size == 1) {
                this.hasNext = this.checkMatchFullIntoNextVal(info.rootKey, info.rootVal);
                return this;
            }
            Node n = info.root;
            if (!this.checkMatch(info.rootKey, n.posDiff - 1)) {
                this.hasNext = false;
                return this;
            }
            this.stack[++this.stackTop] = info.root;
            this.prefixes[this.stackTop] = info.rootKey;
            this.findNext();
            return this;
        }

        private void findNext() {
            while (this.stackTop >= 0) {
                long valTemp;
                Node<V> n = this.stack[this.stackTop];
                if (this.readHigherNext[this.stackTop] == 0) {
                    this.readHigherNext[this.stackTop] = 1;
                    valTemp = BitTools.set0(this.prefixes[this.stackTop], n.posDiff);
                    if (this.checkMatch(valTemp, n.posDiff)) {
                        if (n.lo == null) {
                            if (this.checkMatchFullIntoNextVal(n.loPost, n.loVal)) {
                                return;
                            }
                        } else {
                            this.stack[++this.stackTop] = n.lo;
                            this.prefixes[this.stackTop] = n.loPost;
                            this.readHigherNext[this.stackTop] = 0;
                            continue;
                        }
                    }
                }
                if (this.readHigherNext[this.stackTop] == 1) {
                    this.readHigherNext[this.stackTop] = 2;
                    valTemp = BitTools.set1(this.prefixes[this.stackTop], n.posDiff);
                    if (this.checkMatch(valTemp, n.posDiff)) {
                        if (n.hi == null) {
                            if (this.checkMatchFullIntoNextVal(n.hiPost, n.hiVal)) {
                                --this.stackTop;
                                return;
                            }
                        } else {
                            this.stack[++this.stackTop] = n.hi;
                            this.prefixes[this.stackTop] = n.hiPost;
                            this.readHigherNext[this.stackTop] = 0;
                            continue;
                        }
                    }
                }
                --this.stackTop;
            }
            this.nextValue = null;
            this.nextKey = 0L;
            this.hasNext = false;
        }

        private boolean checkMatchFullIntoNextVal(long keyTemplate, V value) {
            if (((keyTemplate | this.minOrig) & this.maxOrig) != keyTemplate) {
                return false;
            }
            this.nextValue = value;
            this.nextKey = keyTemplate;
            return true;
        }

        private boolean checkMatch(long keyTemplate, int currentDepth) {
            int toIgnore = 63 - currentDepth;
            return ((keyTemplate | this.minOrig) & this.maxOrig ^ keyTemplate) >>> toIgnore == 0L;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            V ret = this.nextValue;
            this.findNext();
            return ret;
        }

        public long nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long ret = this.nextKey;
            this.findNext();
            return ret;
        }

        public Entry<V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<V> ret = new Entry<V>(this.nextKey, this.nextValue);
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class QueryIterator<V>
    implements Iterator<V> {
        private long minOrig;
        private long maxOrig;
        private long nextKey = 0L;
        private V nextValue = null;
        private boolean hasNext = true;
        private final Node<V>[] stack = new Node[64];
        private static final byte READ_LOWER = 0;
        private static final byte READ_UPPER = 1;
        private static final byte RETURN_TO_PARENT = 2;
        private final byte[] readHigherNext = new byte[64];
        private final long[] prefixes = new long[64];
        private int stackTop = -1;

        public QueryIterator<V> reset(CritBit64<V> cb, long minOrig, long maxOrig) {
            this.stackTop = -1;
            this.hasNext = true;
            this.readHigherNext[0] = 0;
            AtomicInfo info = cb.info;
            this.minOrig = minOrig;
            this.maxOrig = maxOrig;
            if (info.size == 0) {
                this.hasNext = false;
                return this;
            }
            if (info.size == 1) {
                this.hasNext = this.checkMatchFullIntoNextVal(info.rootKey, info.rootVal);
                return this;
            }
            Node n = info.root;
            if (!this.checkMatch(info.rootKey, n.posDiff - 1)) {
                this.hasNext = false;
                return this;
            }
            this.stack[++this.stackTop] = info.root;
            this.prefixes[this.stackTop] = info.rootKey;
            this.findNext();
            return this;
        }

        private void findNext() {
            while (this.stackTop >= 0) {
                long valTemp;
                Node<V> n = this.stack[this.stackTop];
                if (this.readHigherNext[this.stackTop] == 0) {
                    this.readHigherNext[this.stackTop] = 1;
                    valTemp = BitTools.set0(this.prefixes[this.stackTop], n.posDiff);
                    if (this.checkMatch(valTemp, n.posDiff)) {
                        if (n.lo == null) {
                            if (this.checkMatchFullIntoNextVal(n.loPost, n.loVal)) {
                                return;
                            }
                        } else {
                            this.stack[++this.stackTop] = n.lo;
                            this.prefixes[this.stackTop] = n.loPost;
                            this.readHigherNext[this.stackTop] = 0;
                            continue;
                        }
                    }
                }
                if (this.readHigherNext[this.stackTop] == 1) {
                    this.readHigherNext[this.stackTop] = 2;
                    valTemp = BitTools.set1(this.prefixes[this.stackTop], n.posDiff);
                    if (this.checkMatch(valTemp, n.posDiff)) {
                        if (n.hi == null) {
                            if (this.checkMatchFullIntoNextVal(n.hiPost, n.hiVal)) {
                                --this.stackTop;
                                return;
                            }
                        } else {
                            this.stack[++this.stackTop] = n.hi;
                            this.prefixes[this.stackTop] = n.hiPost;
                            this.readHigherNext[this.stackTop] = 0;
                            continue;
                        }
                    }
                }
                --this.stackTop;
            }
            this.nextValue = null;
            this.nextKey = 0L;
            this.hasNext = false;
        }

        private boolean checkMatchFullIntoNextVal(long keyTemplate, V value) {
            if (this.minOrig > keyTemplate || keyTemplate > this.maxOrig) {
                return false;
            }
            this.nextValue = value;
            this.nextKey = keyTemplate;
            return true;
        }

        private boolean checkMatch(long keyTemplate, int currentDepth) {
            int toIgnore = 63 - currentDepth;
            long mask = -1L << toIgnore;
            if ((this.minOrig & mask) > (keyTemplate & mask)) {
                return false;
            }
            return (keyTemplate & mask) <= (this.maxOrig & mask);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            V ret = this.nextValue;
            this.findNext();
            return ret;
        }

        public long nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long ret = this.nextKey;
            this.findNext();
            return ret;
        }

        public Entry<V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<V> ret = new Entry<V>(this.nextKey, this.nextValue);
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class CBIterator<V>
    implements Iterator<V> {
        private long nextKey = 0L;
        private V nextValue = null;
        private boolean hasNext = true;
        private final Node<V>[] stack = new Node[64];
        private static final byte READ_LOWER = 0;
        private static final byte READ_UPPER = 1;
        private static final byte RETURN_TO_PARENT = 2;
        private final byte[] readHigherNext = new byte[64];
        private int stackTop = -1;

        public CBIterator<V> reset(CritBit64<V> cb) {
            this.stackTop = -1;
            this.hasNext = true;
            this.readHigherNext[0] = 0;
            AtomicInfo info = cb.info;
            if (info.size == 0) {
                this.hasNext = false;
                return this;
            }
            if (info.size == 1) {
                this.nextValue = info.rootVal;
                this.nextKey = info.rootKey;
                return this;
            }
            this.stack[++this.stackTop] = info.root;
            this.findNext();
            return this;
        }

        private void findNext() {
            while (this.stackTop >= 0) {
                Node<V> n = this.stack[this.stackTop];
                if (this.readHigherNext[this.stackTop] == 0) {
                    this.readHigherNext[this.stackTop] = 1;
                    if (n.lo == null) {
                        this.nextValue = n.loVal;
                        this.nextKey = n.loPost;
                        return;
                    }
                    this.stack[++this.stackTop] = n.lo;
                    this.readHigherNext[this.stackTop] = 0;
                    continue;
                }
                if (this.readHigherNext[this.stackTop] == 1) {
                    this.readHigherNext[this.stackTop] = 2;
                    if (n.hi == null) {
                        this.nextValue = n.hiVal;
                        this.nextKey = n.hiPost;
                        --this.stackTop;
                        return;
                    }
                    this.stack[++this.stackTop] = n.hi;
                    this.readHigherNext[this.stackTop] = 0;
                    continue;
                }
                --this.stackTop;
            }
            this.nextValue = null;
            this.nextKey = 0L;
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            V ret = this.nextValue;
            this.findNext();
            return ret;
        }

        public long nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long ret = this.nextKey;
            this.findNext();
            return ret;
        }

        public Entry<V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<V> ret = new Entry<V>(this.nextKey, this.nextValue);
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Node<V> {
        V loVal;
        V hiVal;
        Node<V> lo;
        Node<V> hi;
        long loPost;
        long hiPost;
        byte posDiff;

        Node(long loPost, V loVal, long hiPost, V hiVal, int posDiff) {
            this.loPost = loPost;
            this.loVal = loVal;
            this.hiPost = hiPost;
            this.hiVal = hiVal;
            this.posDiff = (byte)posDiff;
        }

        Node(Node<V> original) {
            this.loVal = original.loVal;
            this.hiVal = original.hiVal;
            this.lo = original.lo;
            this.hi = original.hi;
            this.loPost = original.loPost;
            this.hiPost = original.hiPost;
            this.posDiff = original.posDiff;
        }
    }

    protected static class AtomicInfo<V> {
        protected Node<V> root;
        protected long rootKey;
        protected V rootVal;
        protected int size;

        protected AtomicInfo() {
        }

        protected AtomicInfo<V> copy() {
            AtomicInfo<V> c = new AtomicInfo<V>();
            c.root = this.root;
            c.rootKey = this.rootKey;
            c.rootVal = this.rootVal;
            c.size = this.size;
            return c;
        }
    }
}

