/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index;

import org.tinspin.index.Index;
import org.tinspin.index.IndexConfig;
import org.tinspin.index.array.PointArray;
import org.tinspin.index.covertree.CoverTree;
import org.tinspin.index.kdtree.KDTree;
import org.tinspin.index.phtree.PHTreeP;
import org.tinspin.index.qthypercube.QuadTreeKD;
import org.tinspin.index.qthypercube2.QuadTreeKD2;
import org.tinspin.index.qtplain.QuadTreeKD0;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeEntry;
import org.tinspin.index.util.PointMapWrapper;

public interface PointMap<T>
extends Index {
    public void insert(double[] var1, T var2);

    public T remove(double[] var1);

    public T update(double[] var1, double[] var2);

    public boolean contains(double[] var1);

    public T queryExact(double[] var1);

    public Index.PointIterator<T> iterator();

    public Index.PointIterator<T> query(double[] var1, double[] var2);

    default public Index.PointEntryKnn<T> query1nn(double[] center) {
        Index.PointIteratorKnn<T> it = this.queryKnn(center, 1);
        return it.hasNext() ? (Index.PointEntryKnn)it.next() : null;
    }

    public Index.PointIteratorKnn<T> queryKnn(double[] var1, int var2);

    public static interface Factory {
        public static <T> PointMap<T> createArray(int dims, int size) {
            return new PointArray(dims, size);
        }

        public static <T> PointMap<T> createCoverTree(int dims) {
            return CoverTree.create(dims);
        }

        public static <T> PointMap<T> createKdTree(int dims) {
            return KDTree.create(dims);
        }

        public static <T> PointMap<T> createKdTree(IndexConfig cfg) {
            return KDTree.create(cfg);
        }

        public static <T> PointMap<T> createPhTree(int dims) {
            return PHTreeP.create(dims);
        }

        public static <T> PointMap<T> createQuadtree(int dims) {
            return QuadTreeKD0.create(dims);
        }

        public static <T> PointMap<T> createQuadtree(int dims, int maxNodeCapacity, double[] center, double radius) {
            return QuadTreeKD0.create(dims, maxNodeCapacity, center, radius);
        }

        public static <T> PointMap<T> createQuadtreeHC(int dims) {
            return QuadTreeKD.create(dims);
        }

        public static <T> PointMap<T> createQuadtreeHC(int dims, int maxNodeCapacity, double[] center, double radius) {
            return QuadTreeKD.create(dims, maxNodeCapacity, center, radius);
        }

        public static <T> PointMap<T> createQuadtreeHC2(int dims) {
            return QuadTreeKD2.create(dims);
        }

        public static <T> PointMap<T> createQuadtreeHC2(int dims, int maxNodeCapacity, double[] center, double radius) {
            return QuadTreeKD2.create(dims, maxNodeCapacity, center, radius);
        }

        public static <T> PointMap<T> createRStarTree(int dims) {
            return PointMapWrapper.create(RTree.createRStar(dims));
        }

        public static <T> PointMap<T> createAndLoadStrRTree(int dims, RTreeEntry<T>[] entries) {
            RTree<T> tree = RTree.createRStar(dims);
            tree.load(entries);
            return PointMapWrapper.create(tree);
        }
    }
}

