/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.math.BigInteger;
import org.apache.parquet.column.Dictionary;

public final class ParquetDictionary
implements org.apache.spark.sql.execution.vectorized.Dictionary {
    private Dictionary dictionary;
    private boolean needTransform = false;

    public ParquetDictionary(Dictionary dictionary, boolean needTransform) {
        this.dictionary = dictionary;
        this.needTransform = needTransform;
    }

    public int decodeToInt(int id) {
        if (this.needTransform) {
            return (int)this.dictionary.decodeToLong(id);
        }
        return this.dictionary.decodeToInt(id);
    }

    public long decodeToLong(int id) {
        if (this.needTransform) {
            return Integer.toUnsignedLong(this.dictionary.decodeToInt(id));
        }
        return this.dictionary.decodeToLong(id);
    }

    public float decodeToFloat(int id) {
        return this.dictionary.decodeToFloat(id);
    }

    public double decodeToDouble(int id) {
        return this.dictionary.decodeToDouble(id);
    }

    public byte[] decodeToBinary(int id) {
        if (this.needTransform) {
            long signed = this.dictionary.decodeToLong(id);
            return new BigInteger(Long.toUnsignedString(signed)).toByteArray();
        }
        return this.dictionary.decodeToBinary(id).getBytes();
    }
}

