/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2.primitives;

import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.primitives.IntVector;
import org.apache.sedona.shaded.s2.primitives.Ints;
import org.apache.sedona.shaded.s2.primitives.Sorter;

public class IntPairVector {
    private final IntVector firsts;
    private final IntVector seconds;

    public IntPairVector() {
        this.firsts = IntVector.empty();
        this.seconds = IntVector.empty();
    }

    public IntPairVector(IntPairVector other) {
        this.firsts = new IntVector(other.firsts);
        this.seconds = new IntVector(other.seconds);
    }

    public static IntPairVector of(int ... contents) {
        Preconditions.checkArgument(contents.length % 2 == 0);
        IntPairVector result = new IntPairVector();
        for (int i = 0; i < contents.length; i += 2) {
            result.add(contents[i], contents[i + 1]);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntPairVector of ").append(this.firsts.size()).append(" pairs: ");
        for (int i = 0; i < this.firsts.size() && i < 10; ++i) {
            sb.append("(").append(this.firsts.get(i)).append(",").append(this.seconds.get(i)).append("), ");
        }
        if (this.firsts.size() > 10) {
            sb.append("...");
        }
        return sb.toString();
    }

    public void add(int first, int second) {
        this.firsts.add(first);
        this.seconds.add(second);
    }

    public int getFirst(int index) {
        return this.firsts.get(index);
    }

    public int getSecond(int index) {
        return this.seconds.get(index);
    }

    public void setPair(int index, int valFirst, int valSecond) {
        this.firsts.set(index, valFirst);
        this.seconds.set(index, valSecond);
    }

    public void setFirst(int index, int value) {
        this.firsts.set(index, value);
    }

    public void setSecond(int index, int value) {
        this.seconds.set(index, value);
    }

    public int size() {
        return this.firsts.size();
    }

    public void forEach(Ints.IntBiConsumer consumer) {
        for (int i = 0; i < this.size(); ++i) {
            consumer.accept(this.firsts.get(i), this.seconds.get(i));
        }
    }

    public int lowerBound(int first, int second) {
        int low = this.firsts.lowerBound(first);
        if (low == this.size() || this.firsts.get(low) > first) {
            return low;
        }
        Preconditions.checkState(this.firsts.get(low) == first);
        int high = this.firsts.upperBound(first);
        return this.seconds.lowerBound(second, low, high);
    }

    public boolean contains(int first, int second) {
        int firstLower = this.firsts.lowerBound(first);
        if (firstLower == this.firsts.size() || this.firsts.get(firstLower) != first) {
            return false;
        }
        if (firstLower + 8 >= this.firsts.size() || this.firsts.get(firstLower + 8) != first) {
            for (int i = firstLower; i < this.firsts.size() && first == this.firsts.get(i); ++i) {
                if (second != this.seconds.get(i)) continue;
                return true;
            }
            return false;
        }
        int firstUpper = this.firsts.upperBound(first);
        int secondLower = this.seconds.lowerBound(second, firstLower, firstUpper);
        return secondLower < this.seconds.size() && this.seconds.get(secondLower) == second;
    }

    public void swap(IntPairVector other) {
        this.firsts.swap(other.firsts);
        this.seconds.swap(other.seconds);
    }

    public void swap(int indexA, int indexB) {
        this.firsts.swap(indexA, indexB);
        this.seconds.swap(indexA, indexB);
    }

    public void sort(final Ints.IntPairComparator cmp) {
        new Sorter.SortableCollection(){

            @Override
            public int size() {
                return IntPairVector.this.firsts.size();
            }

            @Override
            public void truncate(int end) {
                IntPairVector.this.firsts.truncate(end);
                IntPairVector.this.seconds.truncate(end);
            }

            @Override
            public void swap(int a, int b) {
                IntPairVector.this.firsts.swap(a, b);
                IntPairVector.this.seconds.swap(a, b);
            }

            @Override
            public boolean less(int a, int b) {
                return cmp.comparePair(IntPairVector.this.firsts.get(a), IntPairVector.this.seconds.get(a), IntPairVector.this.firsts.get(b), IntPairVector.this.seconds.get(b)) < 0;
            }
        }.sort();
    }

    public void sort() {
        this.sort((firstA, secondA, firstB, secondB) -> Integer.compare(firstA, firstB) != 0 ? Integer.compare(firstA, firstB) : Integer.compare(secondA, secondB));
    }

    public void ensureCapacity(int newCapacity) {
        this.firsts.ensureCapacity(newCapacity);
        this.seconds.ensureCapacity(newCapacity);
    }

    public void copy(IntPairVector other) {
        this.firsts.copy(other.firsts);
        this.seconds.copy(other.seconds);
    }

    public void clear() {
        this.firsts.clear();
        this.seconds.clear();
    }

    public boolean isEmpty() {
        return this.firsts.isEmpty();
    }

    public boolean isEqualTo(IntPairVector other) {
        return this.firsts.isEqualTo(other.firsts) && this.seconds.isEqualTo(other.seconds);
    }

    public void pushPair(int first, int second) {
        this.firsts.push(first);
        this.seconds.push(second);
    }

    public int peekFirst() {
        return this.firsts.peek();
    }

    public int peekSecond() {
        return this.seconds.peek();
    }

    public void pop() {
        this.firsts.pop();
        this.seconds.pop();
    }
}

