/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.S1ChordAngle;
import org.apache.sedona.shaded.s2.S1Interval;
import org.apache.sedona.shaded.s2.S2Point;

public class S2PolylineSimplifier {
    private S2Point src;
    private S2Point xDir;
    private S2Point yDir;
    private S1Interval window;
    private final ArrayList<RangeToAvoid> rangesToAvoid = new ArrayList();

    public void init(S2Point src) {
        this.src = src;
        this.window = S1Interval.full();
        this.rangesToAvoid.clear();
        S2Point tmp = src.fabs();
        int i = tmp.x < tmp.y ? (tmp.x < tmp.z ? 0 : 2) : (tmp.y < tmp.z ? 1 : 2);
        double[] s2 = new double[]{src.x, src.y, src.z};
        double[] xVector = new double[3];
        double[] yVector = new double[3];
        int j = i == 2 ? 0 : i + 1;
        int k = i == 0 ? 2 : i - 1;
        yVector[i] = 0.0;
        yVector[j] = s2[k];
        yVector[k] = -s2[j];
        xVector[i] = s2[j] * s2[j] + s2[k] * s2[k];
        xVector[j] = -s2[j] * s2[i];
        xVector[k] = -s2[k] * s2[i];
        this.xDir = new S2Point(xVector);
        this.yDir = new S2Point(yVector);
    }

    public boolean extend(S2Point dst) {
        S1ChordAngle edgeLength = new S1ChordAngle(this.src, dst);
        if (edgeLength.greaterThan(S1ChordAngle.RIGHT)) {
            return false;
        }
        double dir = this.getDirection(dst);
        if (!this.window.contains(dir)) {
            return false;
        }
        for (RangeToAvoid range : this.rangesToAvoid) {
            if (!range.interval.contains(dir)) continue;
            return false;
        }
        return true;
    }

    @CanIgnoreReturnValue
    public boolean targetDisc(S2Point point, S1ChordAngle radius) {
        double semiwidth = this.getSemiwidth(point, radius, -1);
        if (semiwidth >= Math.PI) {
            return true;
        }
        if (semiwidth < 0.0) {
            this.window = S1Interval.empty();
            return false;
        }
        double center = this.getDirection(point);
        S1Interval target = S1Interval.fromPoint(center).expanded(semiwidth);
        this.window = this.window.intersection(target);
        for (RangeToAvoid range : this.rangesToAvoid) {
            this.avoidRange(range.interval, range.onLeft);
        }
        this.rangesToAvoid.clear();
        return !this.window.isEmpty();
    }

    @CanIgnoreReturnValue
    public boolean avoidDisc(S2Point point, S1ChordAngle radius, boolean discOnLeft) {
        double semiwidth = this.getSemiwidth(point, radius, 1);
        if (semiwidth >= Math.PI) {
            this.window = S1Interval.empty();
            return false;
        }
        double center = this.getDirection(point);
        double dLeft = discOnLeft ? 1.5707963267948966 : semiwidth;
        double dRight = discOnLeft ? semiwidth : 1.5707963267948966;
        S1Interval avoidInterval = new S1Interval(Platform.IEEEremainder(center - dRight, Math.PI * 2), Platform.IEEEremainder(center + dLeft, Math.PI * 2));
        if (this.window.isFull()) {
            this.rangesToAvoid.add(new RangeToAvoid(avoidInterval, discOnLeft));
            return true;
        }
        this.avoidRange(avoidInterval, discOnLeft);
        return !this.window.isEmpty();
    }

    private double getDirection(S2Point p) {
        return Math.atan2(p.dotProd(this.yDir), p.dotProd(this.xDir));
    }

    private double getSemiwidth(S2Point p, S1ChordAngle r, int roundDirection) {
        double r2 = r.getLength2();
        double a2 = new S1ChordAngle(this.src, p).getLength2();
        if ((a2 -= 7.888609052210118E-31 * (double)roundDirection) <= r2) {
            return Math.PI;
        }
        double sin2R = r2 * (1.0 - 0.25 * r2);
        double sin2A = a2 * (1.0 - 0.25 * a2);
        double semiwidth = Math.asin(Math.sqrt(sin2R / sin2A));
        double error = 2.6645352591003757E-15 + 1.887379141862766E-15 * semiwidth;
        return semiwidth + (double)roundDirection * error;
    }

    private void avoidRange(S1Interval avoidInterval, boolean discOnLeft) {
        assert (!this.window.isFull());
        this.window = this.window.contains(avoidInterval) ? (discOnLeft ? new S1Interval(this.window.lo(), avoidInterval.lo()) : new S1Interval(avoidInterval.hi(), this.window.hi())) : this.window.intersection(avoidInterval.complement());
    }

    private static class RangeToAvoid {
        final S1Interval interval;
        final boolean onLeft;

        public RangeToAvoid(S1Interval avoidInterval, boolean discOnLeft) {
            this.interval = avoidInterval;
            this.onLeft = discOnLeft;
        }
    }
}

