/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2ContainsPointQuery;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2PaddedCell;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Projections;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;
import org.apache.sedona.shaded.s2.primitives.IntVector;

public class S2IndexCellData {
    private S2ShapeIndex index = null;
    private S2ShapeIndex.Cell cell = null;
    private S2CellId cellId;
    private int loadedShapeId;
    private volatile boolean s2cellSet = false;
    private volatile boolean centerSet = false;
    private S2Cell s2cell;
    private S2Point cellCenter;
    private final boolean[] dimWanted = new boolean[]{true, true, true};
    private final IntVector edgeIds = new IntVector();
    private final IntVector chainIds = new IntVector();
    private final IntVector offsets = new IntVector();
    private final ArrayList<S2Point> starts = new ArrayList();
    private final ArrayList<S2Point> ends = new ArrayList();
    private final List<ShapeRange> shapeRanges = new ArrayList<ShapeRange>();
    private final Range[] dimRanges = new Range[3];

    public S2IndexCellData() {
        this.dimRanges[0] = new Range();
        this.dimRanges[1] = new Range();
        this.dimRanges[2] = new Range();
    }

    public S2IndexCellData(S2ShapeIndex index, S2CellId id, S2ShapeIndex.Cell cell) {
        this.loadCell(index, id, cell);
    }

    public void reset() {
        this.index = null;
        this.cell = null;
        this.edgeIds.clear();
        this.chainIds.clear();
        this.offsets.clear();
        this.starts.clear();
        this.ends.clear();
        this.shapeRanges.clear();
        this.dimWanted[0] = true;
        this.dimWanted[1] = true;
        this.dimWanted[2] = true;
    }

    public boolean dimWanted(int dim) {
        Preconditions.checkArgument(0 <= dim && dim <= 2);
        return this.dimWanted[dim];
    }

    public void setDimWanted(int dim, boolean wanted) {
        Preconditions.checkArgument(0 <= dim && dim <= 2);
        this.dimWanted[dim] = wanted;
    }

    public S2CellId id() {
        return this.cellId;
    }

    public S2ShapeIndex index() {
        return this.index;
    }

    public int loadedShapeId() {
        return this.loadedShapeId;
    }

    public S2Cell cell() {
        if (!this.s2cellSet) {
            this.s2cell = new S2Cell(this.cellId);
            this.s2cellSet = true;
        }
        return this.s2cell;
    }

    public S2Point center() {
        if (!this.centerSet) {
            this.cellCenter = this.cellId.toPoint();
            this.centerSet = true;
        }
        return this.cellCenter;
    }

    public void loadCell(S2ShapeIndex index, S2CellId id, S2ShapeIndex.Cell cell) {
        this.loadCell(index, id, cell, -1);
    }

    public void loadCell(S2ShapeIndex index, S2CellId id, S2ShapeIndex.Cell cell, int shapeId) {
        int maxDim;
        int minDim;
        assert (index != null);
        if (this.index == index && this.cellId.equals(id) && this.loadedShapeId == shapeId) {
            return;
        }
        this.index = index;
        this.loadedShapeId = shapeId;
        this.cell = cell;
        this.cellId = id;
        this.s2cellSet = false;
        this.centerSet = false;
        this.starts.clear();
        this.ends.clear();
        this.edgeIds.clear();
        this.chainIds.clear();
        this.offsets.clear();
        this.shapeRanges.clear();
        for (Range range : this.dimRanges) {
            range.clear();
        }
        for (minDim = 0; minDim <= 2 && !this.dimWanted(minDim); ++minDim) {
        }
        for (maxDim = 2; maxDim >= 0 && !this.dimWanted(maxDim); --maxDim) {
        }
        if (minDim > 2 || maxDim < 0) {
            return;
        }
        for (int dim = minDim; dim <= maxDim; ++dim) {
            int dimStart = this.edgeIds.size();
            for (int clippedShapeIndex = 0; clippedShapeIndex < cell.numShapes(); ++clippedShapeIndex) {
                S2Shape shape;
                S2ShapeIndex.S2ClippedShape clipped = cell.clipped(clippedShapeIndex);
                int clippedShapeId = clipped.shapeId();
                if (this.loadedShapeId != -1 && clippedShapeId != this.loadedShapeId || (shape = index.getShapes().get(clippedShapeId)).dimension() != dim || !this.dimWanted(dim)) continue;
                int shapeStart = this.edgeIds.size();
                S2Shape.ChainPosition position = new S2Shape.ChainPosition();
                S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
                for (int i = 0; i < clipped.numEdges(); ++i) {
                    int edgeId = clipped.edge(i);
                    shape.getChainPosition(edgeId, position);
                    shape.getChainEdge(position.chainId, position.offset, edge);
                    this.starts.add(edge.a);
                    this.ends.add(edge.b);
                    this.edgeIds.add(edgeId);
                    this.chainIds.add(position.chainId);
                    this.offsets.add(position.offset);
                }
                this.shapeRanges.add(ShapeRange.of(clippedShapeId, new Range(shapeStart, this.edgeIds.size() - shapeStart)));
            }
            this.dimRanges[dim] = new Range(dimStart, this.edgeIds.size() - dimStart);
        }
    }

    public int numClipped() {
        return this.cell.numShapes();
    }

    public S2Shape shape(S2ShapeIndex.S2ClippedShape clipped) {
        S2Shape shape = this.index.getShapes().get(clipped.shapeId());
        assert (shape != null);
        return shape;
    }

    public S2Shape shape(int shapeId) {
        S2Shape shape = this.index.getShapes().get(shapeId);
        assert (shape != null);
        return shape;
    }

    public List<S2ShapeIndex.S2ClippedShape> clippedShapes() {
        return this.cell.clippedShapes();
    }

    private boolean visitRange(int start, int size, Visitor visitor) {
        for (int i = start; i < start + size; ++i) {
            if (visitor.visit(this.edgeIds.get(i), this.chainIds.get(i), this.offsets.get(i), this.starts.get(i), this.ends.get(i))) continue;
            return false;
        }
        return true;
    }

    private List<EdgeAndIdChain> edgeRange(final int start, final int size) {
        return new AbstractList<EdgeAndIdChain>(){

            @Override
            public EdgeAndIdChain get(final int index) {
                return new EdgeAndIdChain(){

                    @Override
                    public S2Point start() {
                        return S2IndexCellData.this.starts.get(start + index);
                    }

                    @Override
                    public S2Point end() {
                        return S2IndexCellData.this.ends.get(start + index);
                    }

                    @Override
                    public int edgeId() {
                        return S2IndexCellData.this.edgeIds.get(start + index);
                    }

                    @Override
                    public int chainId() {
                        return S2IndexCellData.this.chainIds.get(start + index);
                    }

                    @Override
                    public int offset() {
                        return S2IndexCellData.this.offsets.get(start + index);
                    }
                };
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public List<EdgeAndIdChain> edges() {
        return this.edgeRange(0, this.edgeIds.size());
    }

    @CanIgnoreReturnValue
    public boolean visitEdges(Visitor visitor) {
        return this.visitRange(0, this.edgeIds.size(), visitor);
    }

    public List<EdgeAndIdChain> shapeEdges(int shapeId) {
        for (ShapeRange shapeRange : this.shapeRanges) {
            if (shapeRange.shapeId != shapeId) continue;
            Range range = shapeRange.range;
            if (range.start >= this.edgeIds.size()) {
                return ImmutableList.of();
            }
            return this.edgeRange(range.start, range.size);
        }
        return ImmutableList.of();
    }

    @CanIgnoreReturnValue
    public boolean visitShapeEdges(int shapeId, Visitor visitor) {
        for (ShapeRange shapeRange : this.shapeRanges) {
            if (shapeRange.shapeId != shapeId) continue;
            Range range = shapeRange.range;
            if (range.start >= this.edgeIds.size()) {
                return true;
            }
            return this.visitRange(range.start, range.size, visitor);
        }
        return true;
    }

    public List<EdgeAndIdChain> dimEdges(int dim) {
        Preconditions.checkArgument(0 <= dim && dim <= 2);
        Range range = this.dimRanges[dim];
        if (range.start < this.edgeIds.size()) {
            return this.edgeRange(range.start, range.size);
        }
        return ImmutableList.of();
    }

    @CanIgnoreReturnValue
    public boolean visitDimEdges(int dim, Visitor visitor) {
        Preconditions.checkArgument(0 <= dim && dim <= 2);
        Range range = this.dimRanges[dim];
        if (range.start < this.edgeIds.size()) {
            return this.visitRange(range.start, range.size, visitor);
        }
        return true;
    }

    public List<EdgeAndIdChain> dimRangeEdges(int dim0, int dim1) {
        Preconditions.checkArgument(dim0 <= dim1);
        Preconditions.checkArgument(0 <= dim0 && dim0 <= 2);
        Preconditions.checkArgument(0 <= dim1 && dim1 <= 2);
        int start = this.dimRanges[dim0].start;
        int size = 0;
        for (int dim = dim0; dim <= dim1; ++dim) {
            start = Math.min(start, this.dimRanges[dim].start);
            size += this.dimRanges[dim].size;
        }
        if (start < this.edgeIds.size()) {
            return this.edgeRange(start, size);
        }
        return ImmutableList.of();
    }

    public boolean shapeContains(S2ShapeIndex.S2ClippedShape clipped, S2Point point, S2ContainsPointQuery.S2VertexModel model) {
        assert (new S2PaddedCell(this.id(), S2ShapeIndex.CELL_PADDING).bound().contains(S2Projections.validFaceXyzToUv(this.id().face(), point)));
        S2Shape shape = this.index.getShapes().get(clipped.shapeId());
        if (shape.dimension() < 2) {
            if (model != S2ContainsPointQuery.S2VertexModel.CLOSED) {
                return false;
            }
            for (EdgeAndIdChain edge : this.shapeEdges(clipped.shapeId())) {
                if (!edge.hasEndpoint(point)) continue;
                return true;
            }
            return false;
        }
        S2Point center = this.center();
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(center, point);
        boolean[] inside = new boolean[]{clipped.containsCenter()};
        this.visitShapeEdges(clipped.shapeId(), (edgeId, chain, offset, start, end) -> {
            boolean crossing;
            int sign = crosser.robustCrossing(start, end);
            if (sign < 0) {
                return true;
            }
            boolean bl = crossing = sign > 0;
            if (!crossing) {
                if (model != S2ContainsPointQuery.S2VertexModel.SEMI_OPEN && (start.equalsPoint(point) || end.equalsPoint(point))) {
                    return model == S2ContainsPointQuery.S2VertexModel.CLOSED;
                }
                crossing = S2EdgeUtil.vertexCrossing(crosser.a(), crosser.b(), start, end);
            }
            inside[0] = inside[0] ^ crossing;
            return true;
        });
        return inside[0];
    }

    public boolean shapeContains(S2ShapeIndex.S2ClippedShape clipped, S2Point point) {
        return this.shapeContains(clipped, point, S2ContainsPointQuery.S2VertexModel.OPEN);
    }

    private static class ShapeRange {
        public int shapeId;
        public Range range;

        private ShapeRange() {
        }

        public static ShapeRange of(int shapeId, Range range) {
            ShapeRange shapeRange = new ShapeRange();
            shapeRange.shapeId = shapeId;
            shapeRange.range = range;
            return shapeRange;
        }
    }

    private static class Range {
        int start = 0;
        int size = 0;

        public Range() {
        }

        public Range(int start, int size) {
            Preconditions.checkArgument(start >= 0);
            Preconditions.checkArgument(size >= 0);
            this.start = start;
            this.size = size;
        }

        public void clear() {
            this.start = 0;
            this.size = 0;
        }
    }

    public static interface EdgeAndIdChain {
        public S2Point start();

        public S2Point end();

        public int edgeId();

        public int chainId();

        public int offset();

        default public boolean isEqualTo(EdgeAndIdChain other) {
            return this.start().equalsPoint(other.start()) && this.end().equalsPoint(other.end());
        }

        default public boolean isReverseOf(EdgeAndIdChain other) {
            return this.start().equalsPoint(other.end()) && this.end().equalsPoint(other.start());
        }

        public static boolean equals(EdgeAndIdChain x, EdgeAndIdChain y) {
            return x.isEqualTo(y);
        }

        public static boolean lessThan(EdgeAndIdChain x, EdgeAndIdChain y) {
            return x.start().compareTo(y.start()) < 0 || x.start().equalsPoint(y.start()) && x.end().compareTo(y.end()) < 0;
        }

        default public boolean hasEndpoint(S2Point point) {
            return this.start().equalsPoint(point) || this.end().equalsPoint(point);
        }
    }

    public static interface Visitor {
        public boolean visit(int var1, int var2, int var3, S2Point var4, S2Point var5);
    }
}

