/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2ShapeIndex;

public class S2CellRangeIterator<T extends S2Iterator.Entry>
implements S2Iterator<T> {
    private final S2Iterator<T> it;
    private S2CellId rangeMin;
    private S2CellId rangeMax;

    public S2CellRangeIterator(S2Iterator<T> it) {
        this.it = it;
        this.restart();
    }

    public static S2CellRangeIterator<S2ShapeIndex.Cell> makeS2CellRangeIterator(S2ShapeIndex index) {
        return new S2CellRangeIterator<S2ShapeIndex.Cell>(index.iterator());
    }

    public static <E extends S2Iterator.Entry> S2CellRangeIterator<E> makeS2CellRangeIterator(S2Iterator<E> iter) {
        return new S2CellRangeIterator<E>(iter);
    }

    @Override
    public S2CellRangeIterator<T> copy() {
        return new S2CellRangeIterator<T>(this.it.copy());
    }

    public S2Iterator<T> iterator() {
        return this.it;
    }

    public S2CellId rangeMin() {
        return this.rangeMin;
    }

    public S2CellId rangeMax() {
        return this.rangeMax;
    }

    public void begin() {
        this.restart();
    }

    @Override
    public void restart() {
        this.it.restart();
        this.refresh();
    }

    @Override
    public S2CellId id() {
        return this.it.id();
    }

    @Override
    public T entry() {
        return this.it.entry();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean next() {
        boolean result = this.it.next();
        this.refresh();
        return result;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean prev() {
        boolean result = this.it.prev();
        this.refresh();
        return result;
    }

    @Override
    public boolean done() {
        return this.it.done();
    }

    @Override
    public boolean atBegin() {
        return this.it.atBegin();
    }

    @Override
    public void seek(S2CellId target) {
        this.it.seek(target);
        this.refresh();
    }

    @Override
    public void seekForward(S2CellId target) {
        this.it.seekForward(target);
        this.refresh();
    }

    @Override
    public void finish() {
        this.it.finish();
        this.refresh();
    }

    @Override
    public boolean locate(S2Point target) {
        boolean result = this.it.locate(target);
        this.refresh();
        return result;
    }

    @Override
    public S2ShapeIndex.CellRelation locate(S2CellId target) {
        this.seek(target.rangeMin());
        if (!this.done()) {
            if (this.id().greaterOrEquals(target) && this.rangeMin().lessOrEquals(target)) {
                return S2ShapeIndex.CellRelation.INDEXED;
            }
            if (this.id().lessOrEquals(target.rangeMax())) {
                return S2ShapeIndex.CellRelation.SUBDIVIDED;
            }
        }
        if (this.prev() && this.rangeMax().greaterOrEquals(target)) {
            return S2ShapeIndex.CellRelation.INDEXED;
        }
        return S2ShapeIndex.CellRelation.DISJOINT;
    }

    public S2ShapeIndex.CellRelation locate(S2CellRangeIterator<T> target) {
        this.seek(target.rangeMin());
        if (!this.done()) {
            if (this.id().greaterOrEquals(target.id()) && this.rangeMin().lessOrEquals(target.id())) {
                return S2ShapeIndex.CellRelation.INDEXED;
            }
            if (this.id().lessOrEquals(target.rangeMax())) {
                return S2ShapeIndex.CellRelation.SUBDIVIDED;
            }
        }
        if (this.prev() && this.rangeMax().greaterOrEquals(target.id())) {
            return S2ShapeIndex.CellRelation.INDEXED;
        }
        return S2ShapeIndex.CellRelation.DISJOINT;
    }

    public void seekTo(S2CellRangeIterator<?> target) {
        this.seek(target.rangeMin());
        if ((this.done() || this.rangeMin().greaterThan(target.rangeMax())) && this.prev() && this.rangeMax().lessThan(target.id())) {
            this.next();
        }
        this.refresh();
    }

    public void seekBeyond(S2CellRangeIterator<?> target) {
        this.seek(target.rangeMax().next());
        if (!this.done() && this.rangeMin().lessOrEquals(target.rangeMax())) {
            this.next();
        }
        this.refresh();
    }

    public int relation(S2CellRangeIterator<?> b) {
        if (this.rangeMax().lessThan(b.rangeMin())) {
            return -1;
        }
        if (this.rangeMin().greaterThan(b.rangeMax())) {
            return 1;
        }
        return 0;
    }

    private void refresh() {
        if (this.done()) {
            this.rangeMin = S2CellId.sentinel().rangeMin();
            this.rangeMax = S2CellId.sentinel().rangeMax();
        } else {
            this.rangeMin = this.id().rangeMin();
            this.rangeMax = this.id().rangeMax();
        }
    }
}

