/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.Serializable;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
public final class R1Interval
implements Serializable {
    private double lo;
    private double hi;

    R1Interval() {
        this(1.0, 0.0);
    }

    public R1Interval(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    @JsIgnore
    public R1Interval(R1Interval interval) {
        this(interval.lo, interval.hi);
    }

    public static R1Interval empty() {
        return new R1Interval(1.0, 0.0);
    }

    public static R1Interval fromPoint(double p) {
        return new R1Interval(p, p);
    }

    public static R1Interval fromPointPair(double p1, double p2) {
        R1Interval result = new R1Interval();
        result.initFromPointPair(p1, p2);
        return result;
    }

    void initFromPointPair(double p1, double p2) {
        if (p1 <= p2) {
            this.lo = p1;
            this.hi = p2;
        } else {
            this.lo = p2;
            this.hi = p1;
        }
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    double getValue(Endpoint endpoint) {
        return endpoint.getValue(this);
    }

    void setValue(Endpoint endpoint, double value) {
        endpoint.setValue(this, value);
    }

    public boolean isEmpty() {
        return this.lo > this.hi;
    }

    public double getCenter() {
        return 0.5 * (this.lo + this.hi);
    }

    public double getLength() {
        return this.hi - this.lo;
    }

    @JsMethod(name="containsPoint")
    public boolean contains(double p) {
        return p >= this.lo && p <= this.hi;
    }

    @JsMethod(name="interiorContainsPoint")
    public boolean interiorContains(double p) {
        return p > this.lo && p < this.hi;
    }

    public boolean contains(R1Interval y) {
        if (y.isEmpty()) {
            return true;
        }
        return y.lo >= this.lo && y.hi <= this.hi;
    }

    public boolean interiorContains(R1Interval y) {
        if (y.isEmpty()) {
            return true;
        }
        return y.lo > this.lo && y.hi < this.hi;
    }

    public boolean intersects(R1Interval y) {
        if (this.lo <= y.lo) {
            return y.lo <= this.hi && y.lo <= y.hi;
        }
        return this.lo <= y.hi && this.lo <= this.hi;
    }

    public boolean interiorIntersects(R1Interval y) {
        return y.lo < this.hi && this.lo < y.hi && this.lo < this.hi && y.lo <= y.hi;
    }

    public double getDirectedHausdorffDistance(R1Interval y) {
        if (this.isEmpty()) {
            return 0.0;
        }
        if (y.isEmpty()) {
            return Double.MAX_VALUE;
        }
        return Math.max(0.0, Math.max(this.hi() - y.hi(), y.lo() - this.lo()));
    }

    void set(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    void setLo(double lo) {
        this.lo = lo;
    }

    void setHi(double hi) {
        this.hi = hi;
    }

    void setEmpty() {
        this.lo = 1.0;
        this.hi = 0.0;
    }

    void unionInternal(double p) {
        if (this.isEmpty()) {
            this.lo = p;
            this.hi = p;
        } else if (p < this.lo) {
            this.lo = p;
        } else if (p > this.hi) {
            this.hi = p;
        }
    }

    public double clampPoint(double p) {
        assert (!this.isEmpty());
        return Math.max(this.lo, Math.min(this.hi, p));
    }

    @CheckReturnValue
    public R1Interval expanded(double margin) {
        if (this.isEmpty()) {
            return this;
        }
        return new R1Interval(this.lo - margin, this.hi + margin);
    }

    void expandedInternal(double radius) {
        this.lo -= radius;
        this.hi += radius;
    }

    @CheckReturnValue
    public R1Interval union(R1Interval y) {
        if (this.isEmpty()) {
            return y;
        }
        if (y.isEmpty()) {
            return this;
        }
        return new R1Interval(Math.min(this.lo, y.lo), Math.max(this.hi, y.hi));
    }

    void unionInternal(R1Interval y) {
        if (this.isEmpty()) {
            this.lo = y.lo;
            this.hi = y.hi;
        } else if (!y.isEmpty()) {
            this.lo = Math.min(this.lo, y.lo);
            this.hi = Math.max(this.hi, y.hi);
        }
    }

    @CheckReturnValue
    public R1Interval intersection(R1Interval y) {
        return new R1Interval(Math.max(this.lo, y.lo), Math.min(this.hi, y.hi));
    }

    void intersectionInternal(R1Interval y) {
        this.lo = Math.max(this.lo, y.lo);
        this.hi = Math.min(this.hi, y.hi);
    }

    @CheckReturnValue
    public R1Interval addPoint(double p) {
        if (this.isEmpty()) {
            return R1Interval.fromPoint(p);
        }
        if (p < this.lo) {
            return new R1Interval(p, this.hi);
        }
        if (p > this.hi) {
            return new R1Interval(this.lo, p);
        }
        return new R1Interval(this.lo, this.hi);
    }

    public boolean equals(Object that) {
        if (that instanceof R1Interval) {
            R1Interval y = (R1Interval)that;
            return this.lo == y.lo && this.hi == y.hi || this.isEmpty() && y.isEmpty();
        }
        return false;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 17;
        }
        long value = 17L;
        value = 37L * value + Double.doubleToLongBits(this.lo);
        value = 37L * value + Double.doubleToLongBits(this.hi);
        return (int)(value ^ value >>> 32);
    }

    public boolean approxEquals(R1Interval y) {
        return this.approxEquals(y, 1.0E-15);
    }

    @JsMethod(name="approxEqualsWithMaxError")
    public boolean approxEquals(R1Interval y, double maxError) {
        if (this.isEmpty()) {
            return y.getLength() <= maxError;
        }
        if (y.isEmpty()) {
            return this.getLength() <= maxError;
        }
        return Math.abs(y.lo - this.lo) <= maxError && Math.abs(y.hi - this.hi) <= maxError;
    }

    public String toString() {
        return "[" + this.lo + ", " + this.hi + "]";
    }

    static enum Endpoint {
        LO{

            @Override
            public double getValue(R1Interval interval) {
                return interval.lo;
            }

            @Override
            public void setValue(R1Interval interval, double value) {
                interval.lo = value;
            }

            @Override
            public Endpoint opposite() {
                return HI;
            }
        }
        ,
        HI{

            @Override
            public double getValue(R1Interval interval) {
                return interval.hi;
            }

            @Override
            public void setValue(R1Interval interval, double value) {
                interval.hi = value;
            }

            @Override
            public Endpoint opposite() {
                return LO;
            }
        };


        public abstract double getValue(R1Interval var1);

        public abstract void setValue(R1Interval var1, double var2);

        public abstract Endpoint opposite();
    }
}

