/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sedona.shaded.jiffle.parser.node.BinaryExpression;
import org.apache.sedona.shaded.jiffle.parser.node.Node;
import org.apache.sedona.shaded.jiffle.parser.node.SourceWriter;

public class GlobalVars
implements Node {
    private final List<BinaryExpression> inits;

    public GlobalVars() {
        this.inits = Collections.emptyList();
    }

    public GlobalVars(List<BinaryExpression> inits) {
        this.inits = inits;
    }

    @Override
    public void write(SourceWriter writer) {
        for (BinaryExpression init : this.inits) {
            init.writeDefaultValue(writer);
        }
    }

    public void writeFields(SourceWriter w) {
        for (BinaryExpression init : this.inits) {
            init.writeDeclaration(w);
        }
    }

    public void listNames(SourceWriter w) {
        for (int i = 0; i < this.inits.size(); ++i) {
            w.append("\"");
            this.inits.get(i).appendName(w);
            w.append("\"");
            if (i >= this.inits.size() - 1) continue;
            w.append(", ");
        }
    }

    public List<BinaryExpression> getInits() {
        return new ArrayList<BinaryExpression>(this.inits);
    }
}

