/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.apache.sedona.common.raster.RasterBandAccessors;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.arcgrid.ArcGridWriteParams;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.referencing.operation.transform.AffineTransform2D;

public class RasterOutputs {
    public static byte[] asGeoTiff(GridCoverage2D raster, String compressionType, double compressionQuality) {
        GeoTiffWriter writer;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            writer = new GeoTiffWriter((Object)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ParameterValueGroup defaultParams = writer.getFormat().getWriteParameters();
        if (compressionType != null && compressionQuality >= 0.0 && compressionQuality <= 1.0) {
            GeoTiffWriteParams params = new GeoTiffWriteParams();
            params.setCompressionMode(2);
            params.setCompressionType(compressionType);
            params.setCompressionQuality((float)compressionQuality);
            defaultParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)params);
        }
        GeneralParameterValue[] wps = defaultParams.values().toArray(new GeneralParameterValue[0]);
        try {
            writer.write((GridCoverage)raster, wps);
            writer.dispose();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public static byte[] asGeoTiff(GridCoverage2D raster) {
        return RasterOutputs.asGeoTiff(raster, null, -1.0);
    }

    public static boolean writeToDiskFile(byte[] bytes, String filePath) {
        File outputFile = new File(filePath);
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static byte[] asPNG(GridCoverage2D raster, int maxWidth) throws IOException {
        String bandType = RasterBandAccessors.getBandType(raster);
        if ("B".equals(bandType) || "UNSIGNED_8BITS".equals(bandType)) {
            byte[] out = RasterOutputs.doAsPNGByteBands(raster, maxWidth);
            if (out.length > 0) {
                return out;
            }
            return RasterOutputs.doAsPNGMultiBand(raster, maxWidth);
        }
        if (raster.getRenderedImage().getSampleModel().getNumBands() == 1) {
            return RasterOutputs.doAsPNGSingleBand(raster, maxWidth);
        }
        return RasterOutputs.doAsPNGMultiBand(raster, maxWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doAsPNGByteBands(GridCoverage2D raster, int maxWidth) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RenderedImage image = raster.getRenderedImage();
        RenderedOp scaleOp = RasterOutputs.scaleImageToFitMaxWidth(image, maxWidth);
        if (scaleOp != null) {
            image = scaleOp.getAsBufferedImage();
        }
        try {
            ImageIO.write(image, "png", out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (scaleOp != null) {
                scaleOp.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doAsPNGSingleBand(GridCoverage2D raster, int maxWidth) throws IOException {
        RenderedImage image = raster.getRenderedImage();
        RenderedOp scaleOp = RasterOutputs.scaleImageToFitMaxWidth(image, maxWidth);
        if (scaleOp != null) {
            image = scaleOp.getAsBufferedImage();
        }
        try {
            Raster inputRaster = RasterUtils.getRaster(image);
            double noDataValue = RasterUtils.getNoDataValue(raster.getSampleDimension(0));
            double min2 = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    double value = inputRaster.getSampleDouble(x, y, 0);
                    if (Double.compare(value, noDataValue) == 0) continue;
                    min2 = Math.min(min2, value);
                    max = Math.max(max, value);
                }
            }
            double scale = max != min2 ? 255.0 / (max - min2) : 1.0;
            BufferedImage outputImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            WritableRaster outputRaster = outputImage.getRaster();
            double[] pixel = new double[1];
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    if (Double.compare((pixel = inputRaster.getPixel(x, y, pixel))[0], noDataValue) == 0) {
                        outputRaster.setPixel(x, y, new int[]{0, 0, 0, 0});
                        continue;
                    }
                    int normalizedValue = (int)((pixel[0] - min2) * scale);
                    outputRaster.setPixel(x, y, new int[]{normalizedValue, normalizedValue, normalizedValue, 255});
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outputImage, "png", os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (scaleOp != null) {
                scaleOp.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doAsPNGMultiBand(GridCoverage2D raster, int maxWidth) throws IOException {
        RenderedImage image = raster.getRenderedImage();
        RenderedOp scaleOp = RasterOutputs.scaleImageToFitMaxWidth(image, maxWidth);
        if (scaleOp != null) {
            image = scaleOp.getAsBufferedImage();
        }
        try {
            BufferedImage outputImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            ColorModel colorModel = image.getColorModel();
            Raster inputRaster = RasterUtils.getRaster(image);
            WritableRaster outputRaster = outputImage.getRaster();
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    Object pixel = inputRaster.getDataElements(x, y, null);
                    try {
                        int rgb = colorModel.getRGB(pixel);
                        outputRaster.setPixel(x, y, new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF});
                        continue;
                    }
                    catch (Exception e) {
                        outputRaster.setPixel(x, y, new int[]{0, 0, 0});
                    }
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)outputImage, "png", os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (scaleOp != null) {
                scaleOp.dispose();
            }
        }
    }

    private static RenderedOp scaleImageToFitMaxWidth(RenderedImage image, int maxWidth) {
        int width;
        int n = width = maxWidth < 0 ? image.getWidth() : Math.min(image.getWidth(), maxWidth);
        if (width == image.getWidth()) {
            return null;
        }
        double scaleFactor = (double)width / (double)image.getWidth();
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add((float)scaleFactor);
        pb.add((float)scaleFactor);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(new InterpolationNearest());
        return JAI.create((String)"scale", (ParameterBlock)pb, null);
    }

    public static byte[] asPNG(GridCoverage2D raster) throws IOException {
        return RasterOutputs.asPNG(raster, -1);
    }

    public static byte[] asArcGrid(GridCoverage2D raster, int sourceBand) {
        ArcGridWriter writer;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            writer = new ArcGridWriter((Object)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ParameterValueGroup defaultParams = writer.getFormat().getWriteParameters();
        if (sourceBand >= 0) {
            ArcGridWriteParams params = new ArcGridWriteParams();
            params.setSourceBands(new int[]{sourceBand});
            defaultParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)params);
        }
        GeneralParameterValue[] wps = defaultParams.values().toArray(new GeneralParameterValue[0]);
        try {
            writer.write((GridCoverage)raster, wps);
            writer.dispose();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public static byte[] asArcGrid(GridCoverage2D raster) {
        return RasterOutputs.asArcGrid(raster, -1);
    }

    public static String asBase64(GridCoverage2D raster, int maxWidth) throws IOException {
        byte[] png = RasterOutputs.asPNG(raster, maxWidth);
        return Base64.getEncoder().encodeToString(png);
    }

    public static String asBase64(GridCoverage2D raster) throws IOException {
        byte[] png = RasterOutputs.asPNG(raster, -1);
        return Base64.getEncoder().encodeToString(png);
    }

    public static String asMatrixPretty(GridCoverage2D raster, int band, int precision) {
        try {
            RasterUtils.ensureBand(raster, band);
            RenderedImage img = raster.getRenderedImage();
            Raster r = RasterUtils.getRaster(img);
            int minX = img.getMinX();
            int minY = img.getMinY();
            int width = r.getWidth();
            int height = r.getHeight();
            int bandIdx = band - 1;
            AffineTransform2D at = RasterUtils.getAffineTransform(raster, PixelOrientation.UPPER_LEFT);
            double a = at.getScaleX();
            double b = at.getShearX();
            double d = at.getShearY();
            double e = at.getScaleY();
            double tx = at.getTranslateX();
            double ty = at.getTranslateY();
            boolean integral = RasterUtils.isDataTypeIntegral(r.getDataBuffer().getDataType());
            String numPat = precision <= 0 ? "0" : "0." + "#".repeat(precision);
            DecimalFormat df = new DecimalFormat(numPat);
            String[][] cells = new String[height + 1][width + 1];
            cells[0][0] = "y\\x";
            for (int x = 0; x < width; ++x) {
                double xc = minX + x;
                double yc = minY;
                double worldX = a * xc + b * yc + tx;
                cells[0][x + 1] = "[" + (minX + x) + ", " + df.format(worldX) + "]";
            }
            for (int y = 0; y < height; ++y) {
                int x;
                Object[] vals;
                double yc = minY + y;
                double xc = minX;
                double worldY = d * xc + e * yc + ty;
                cells[y + 1][0] = "[" + (minY + y) + ", " + df.format(worldY) + "]";
                if (integral) {
                    vals = r.getSamples(0, y, width, 1, bandIdx, (int[])null);
                    for (x = 0; x < width; ++x) {
                        cells[y + 1][x + 1] = String.valueOf(vals[x]);
                    }
                    continue;
                }
                vals = r.getSamples(0, y, width, 1, bandIdx, (double[])null);
                for (x = 0; x < width; ++x) {
                    cells[y + 1][x + 1] = df.format((double)vals[x]);
                }
            }
            int rows = height + 1;
            int cols = width + 1;
            int[] colWidths = new int[cols];
            for (int c = 0; c < cols; ++c) {
                int max = 0;
                for (int rIdx = 0; rIdx < rows; ++rIdx) {
                    max = Math.max(max, cells[rIdx][c].length());
                }
                colWidths[c] = max;
            }
            StringBuilder out = new StringBuilder();
            Object sep = "+";
            for (int c = 0; c < cols; ++c) {
                sep = (String)sep + "-".repeat(colWidths[c] + 2) + "+";
            }
            sep = (String)sep + "\n";
            out.append((String)sep);
            for (int rIdx = 0; rIdx < rows; ++rIdx) {
                out.append("| ");
                for (int c = 0; c < cols; ++c) {
                    boolean leftAlign;
                    String val = cells[rIdx][c];
                    boolean bl = leftAlign = c == 0 || rIdx == 0;
                    if (leftAlign) {
                        out.append(String.format("%-" + colWidths[c] + "s", val));
                    } else {
                        out.append(String.format("%" + colWidths[c] + "s", val));
                    }
                    out.append(" | ");
                }
                out.append("\n");
                if (rIdx != 0) continue;
                out.append((String)sep);
            }
            out.append((String)sep);
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to format raster matrix", e);
        }
    }

    public static String asMatrix(GridCoverage2D raster, int band, int postDecimalPrecision) {
        RasterUtils.ensureBand(raster, band);
        Raster rasterData = RasterUtils.getRaster(raster.getRenderedImage());
        int dataTypeCode = rasterData.getDataBuffer().getDataType();
        int width = rasterData.getWidth();
        int height = rasterData.getHeight();
        if (RasterUtils.isDataTypeIntegral(dataTypeCode)) {
            int[] bandValues = rasterData.getSamples(0, 0, width, height, band - 1, (int[])null);
            return RasterOutputs.createPaddedMatrixStringFromInt(bandValues, width);
        }
        double[] bandValues = rasterData.getSamples(0, 0, width, height, band - 1, (double[])null);
        return RasterOutputs.createPaddedMatrixStringFromDouble(bandValues, width, postDecimalPrecision);
    }

    public static String asMatrix(GridCoverage2D raster, int band) {
        return RasterOutputs.asMatrix(raster, band, 6);
    }

    public static String asMatrix(GridCoverage2D raster) {
        return RasterOutputs.asMatrix(raster, 1);
    }

    private static String createPaddedMatrixStringFromDouble(double[] values, int width, int decimalPrecision) {
        StringBuilder res = new StringBuilder();
        int maxPreDecimal = 0;
        int maxDecimalPrecision = 0;
        for (double value : values) {
            String[] splitByDecimal = String.valueOf(value).split("\\.");
            int preDecimal = splitByDecimal[0].length();
            int postDecimal = Math.min(decimalPrecision, splitByDecimal.length > 1 ? splitByDecimal[1].length() : 0);
            maxDecimalPrecision = Math.max(maxDecimalPrecision, postDecimal);
            int currWidth = preDecimal + 1;
            maxPreDecimal = Math.max(maxPreDecimal, currWidth);
        }
        int maxColWidth = maxDecimalPrecision + maxPreDecimal;
        for (int i = 0; i < values.length; ++i) {
            int row = i / width;
            int col = i % width;
            String fmt = String.format("%s%%%d.%df%s", col == 0 ? "|" : "  ", maxColWidth, maxDecimalPrecision, col < width - 1 ? "" : "|%n");
            res.append(String.format(fmt, values[i]));
        }
        return res.toString();
    }

    private static String createPaddedMatrixStringFromInt(int[] values, int width) {
        StringBuilder res = new StringBuilder();
        int maxColWidth = 0;
        for (int value : values) {
            int currWidth = String.valueOf(value).length();
            maxColWidth = Math.max(maxColWidth, currWidth);
        }
        for (int i = 0; i < values.length; ++i) {
            int row = i / width;
            int col = i % width;
            String fmt = String.format("%s%%%dd%s", col == 0 ? "|" : "  ", maxColWidth, col < width - 1 ? "" : "|%n");
            res.append(String.format(fmt, values[i]));
        }
        return res.toString();
    }

    public static String createHTMLString(GridCoverage2D raster, int imageWidth) throws IOException {
        String rasterAsBase64 = RasterOutputs.asBase64(raster, imageWidth);
        String imageString = String.format("data:image/png;base64,%s", rasterAsBase64);
        String htmlString = "<img src=\"" + imageString + "\" width=\"" + imageWidth + "\" />";
        return new String(htmlString.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    }

    public static String createHTMLString(GridCoverage2D raster) throws IOException {
        return RasterOutputs.createHTMLString(raster, 200);
    }
}

