/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2ShapeIndex;

public class GeographyIndex {
    private final S2ShapeIndex index;
    private final List<Integer> values;

    public GeographyIndex() {
        this(new S2ShapeIndex.Options());
    }

    public GeographyIndex(S2ShapeIndex.Options options) {
        this.index = new S2ShapeIndex(options);
        this.values = new ArrayList<Integer>(Collections.singletonList(-1));
    }

    public void add(Geography geog, int value) {
        for (int i = 0; i < geog.numShapes(); ++i) {
            this.index.add(geog.shape(i));
            int shapeId = this.index.getShapes().size();
            this.values.add(shapeId, value);
        }
    }

    public int value(int shapeId) {
        return this.values.get(shapeId);
    }

    public S2ShapeIndex getShapeIndex() {
        return this.index;
    }

    private static int[] expand(int[] array, int newSize) {
        if (array == null) {
            return new int[newSize];
        }
        if (array.length < newSize) {
            return Arrays.copyOf(array, newSize);
        }
        return array;
    }

    public static class Iterator {
        private final GeographyIndex parent;
        private final S2Iterator.ListIterator<S2ShapeIndex.Cell> iterator;

        public Iterator(GeographyIndex index) {
            this.parent = index;
            this.iterator = index.getShapeIndex().iterator();
        }

        public void query(Iterable<S2CellId> covering, Set<Integer> result) {
            for (S2CellId cell : covering) {
                this.query(cell, result);
            }
        }

        public void query(S2CellId cellId, Set<Integer> result) {
            block4: {
                S2ShapeIndex.CellRelation relation;
                block3: {
                    relation = this.iterator.locate(cellId);
                    if (relation != S2ShapeIndex.CellRelation.INDEXED) break block3;
                    S2ShapeIndex.Cell cell = this.iterator.entry();
                    List<S2ShapeIndex.S2ClippedShape> clippedShape = cell.clippedShapes();
                    for (int k = 0; k < clippedShape.size(); ++k) {
                        int sid = cell.clipped(k).shapeId();
                        result.add(this.parent.value(sid));
                    }
                    break block4;
                }
                if (relation != S2ShapeIndex.CellRelation.SUBDIVIDED) break block4;
                while (!this.iterator.done() && cellId.contains(this.iterator.id())) {
                    S2ShapeIndex.Cell cell = this.iterator.entry();
                    List<S2ShapeIndex.S2ClippedShape> clippedShape = cell.clippedShapes();
                    for (int k = 0; k < clippedShape.size(); ++k) {
                        int sid = cell.clipped(k).shapeId();
                        result.add(this.parent.value(sid));
                    }
                    this.iterator.next();
                }
            }
        }
    }
}

