/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v11.nt;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import ch.ethz.globis.phtree.util.Refs;
import ch.ethz.globis.phtree.v11.nt.NtNode;
import ch.ethz.globis.phtree.v11.nt.NtNodeIteratorMask;
import java.util.NoSuchElementException;

public final class NtIteratorMask<T>
implements MaxKTreeI.PhIterator64<T> {
    private final PhIteratorStack stack;
    private long minMask;
    private long maxMask;
    private final MaxKTreeI.NtEntry<T> resultBuf1;
    private final MaxKTreeI.NtEntry<T> resultBuf2;
    private boolean isFreeBuf1;
    boolean isFinished = false;

    public NtIteratorMask(int keyBitWidth) {
        this.stack = new PhIteratorStack(NtNode.calcTreeHeight(keyBitWidth));
        this.resultBuf1 = new MaxKTreeI.NtEntry<Object>(0L, new long[keyBitWidth], null);
        this.resultBuf2 = new MaxKTreeI.NtEntry<Object>(0L, new long[keyBitWidth], null);
    }

    @Override
    public void reset(MaxKTreeI tree, long minMask, long maxMask) {
        this.reset((NtNode)tree.getRoot(), minMask, maxMask);
    }

    @Override
    public void reset(MaxKTreeI tree) {
        throw new UnsupportedOperationException();
    }

    public NtIteratorMask<T> reset(NtNode<T> root, long minMask, long maxMask) {
        this.minMask = minMask;
        this.maxMask = maxMask;
        this.stack.size = 0;
        this.isFinished = false;
        if (root == null) {
            this.isFinished = true;
            return this;
        }
        this.stack.prepareAndPush(root, 0L);
        this.findNextElement();
        return this;
    }

    private void findNextElement() {
        MaxKTreeI.NtEntry<T> result;
        MaxKTreeI.NtEntry<T> ntEntry = result = this.isFreeBuf1 ? this.resultBuf1 : this.resultBuf2;
        while (!this.stack.isEmpty()) {
            NtNodeIteratorMask<T> p = this.stack.peek();
            while (p.increment(result)) {
                if (p.isNextSub()) {
                    p = this.stack.prepareAndPush(p.getCurrentSubNode(), p.getPrefix());
                    continue;
                }
                this.isFreeBuf1 = !this.isFreeBuf1;
                return;
            }
            this.stack.pop();
        }
        this.isFinished = true;
    }

    @Override
    public long nextKey() {
        return this.nextEntryReuse().getKey();
    }

    @Override
    public long[] nextKdKey() {
        long[] key = this.nextEntryReuse().getKdKey();
        long[] ret = new long[key.length];
        System.arraycopy(key, 0, ret, 0, key.length);
        return ret;
    }

    @Override
    public T nextValue() {
        return this.nextEntryReuse().getValue();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    @Deprecated
    public MaxKTreeI.NtEntry<T> nextEntry() {
        return new MaxKTreeI.NtEntry<T>(this.nextEntryReuse());
    }

    @Override
    public T next() {
        return this.nextEntryReuse().getValue();
    }

    @Override
    public MaxKTreeI.NtEntry<T> nextEntryReuse() {
        if (this.isFinished) {
            throw new NoSuchElementException();
        }
        MaxKTreeI.NtEntry<T> ret = this.isFreeBuf1 ? this.resultBuf2 : this.resultBuf1;
        this.findNextElement();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void adjustMinMax(long newGlobalMinMask, long newGlobalMaxMask) {
        while (this.stack.size > 1 && !this.stack.peek().verifyMinMax(newGlobalMinMask, newGlobalMaxMask)) {
            this.stack.pop();
        }
        while (!this.stack.isEmpty() && !this.stack.peek().adjustMinMax(newGlobalMinMask, newGlobalMaxMask)) {
            this.stack.pop();
        }
    }

    private class PhIteratorStack {
        private final NtNodeIteratorMask<T>[] stack;
        private int size = 0;

        public PhIteratorStack(int depth) {
            this.stack = Refs.newArray(NtNodeIteratorMask.class, depth);
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public NtNodeIteratorMask<T> prepareAndPush(NtNode<T> node, long currentPrefix) {
            NtNodeIteratorMask ni;
            if ((ni = this.stack[this.size++]) == null) {
                ni = new NtNodeIteratorMask();
                this.stack[this.size - 1] = ni;
            }
            ni.init(NtIteratorMask.this.minMask, NtIteratorMask.this.maxMask, currentPrefix, node);
            return ni;
        }

        public NtNodeIteratorMask<T> peek() {
            return this.stack[this.size - 1];
        }

        public NtNodeIteratorMask<T> pop() {
            return this.stack[--this.size];
        }
    }
}

