/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.util;

import ch.ethz.globis.phtree.util.Bits;

public class BitsLongAligned {
    static final int UNIT_3 = 6;
    public static final int UNIT_BITS = 64;
    private static final int UNIT_0x1F = 63;
    private static final long UNIT_0xFF = -1L;
    private static final long UNIT_0x8000 = Long.MIN_VALUE;
    private static final int BYTES_PER_UNIT = 8;
    static int statACreate = 0;
    static int statAExpand = 0;
    static int statATrim = 0;
    static int statOldRightShift = 0;
    static int statOldRightShiftTime = 0;

    public static long readArray64(long[] ba, int offsetBit) {
        return ba[offsetBit];
    }

    public static void readArray64(long[] ba, int offsetBit, long[] out) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = ba[offsetBit + i];
        }
    }

    public static long readArrayByBit(long[] ba, int offsetBit, int entryLen) {
        int pA = offsetBit >>> 6;
        int srcLocStart = offsetBit & 0x3F;
        long mask1 = -1L >>> srcLocStart;
        long ret = ba[pA] & mask1;
        int srcLocalEnd = offsetBit + entryLen - 1 & 0x3F;
        ++srcLocalEnd;
        if (srcLocStart + entryLen > 64) {
            ret <<= srcLocalEnd;
            long mask2 = -1L >>> srcLocalEnd;
            ret |= Long.rotateLeft(ba[pA + 1] & (mask2 ^ 0xFFFFFFFFFFFFFFFFL), srcLocalEnd);
        } else {
            ret >>>= 64 - srcLocalEnd;
        }
        return ret;
    }

    public static void writeArray64(long[] ba, int offsetBit, long val) {
        ba[offsetBit] = val;
    }

    public static void writeArray64(long[] ba, int offsetBit, long[] val) {
        for (int i = 0; i < val.length; ++i) {
            ba[offsetBit + i] = val[i];
        }
    }

    public static void writeArrayByBit(long[] ba, int offsetBit, int entryLen, long val) {
        long mask2;
        if (entryLen == 0) {
            return;
        }
        int pA = offsetBit >>> 6;
        int startBit = offsetBit & 0x3F;
        int endPos = offsetBit + entryLen - 1;
        int endBit = endPos & 0x3F;
        long mask1 = -1L >>> startBit;
        long l = mask2 = ++endBit == 64 ? 0L : -1L >>> endBit;
        if (endBit <= startBit) {
            int n = pA;
            ba[n] = ba[n] & (mask1 ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = pA;
            ba[n2] = ba[n2] | val >>> offsetBit + entryLen & mask1;
            int n3 = pA + 1;
            ba[n3] = ba[n3] & mask2;
            int n4 = pA + 1;
            ba[n4] = ba[n4] | Long.rotateRight(val, endBit) & (mask2 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            long mask = mask1 & (mask2 ^ 0xFFFFFFFFFFFFFFFFL);
            int n = pA;
            ba[n] = ba[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            int n5 = pA;
            ba[n5] = ba[n5] | val << 64 - endBit & mask;
        }
    }

    public static void insertBits(long[] ba, int start, int nBits) {
        if (nBits == 0 || start + nBits >= ba.length * 64) {
            return;
        }
        int posSrc = start;
        int posDst = start + nBits;
        int len = ba.length - posDst;
        if (len > 16) {
            System.arraycopy(ba, posSrc, ba, posDst, len);
        } else {
            for (int i = len - 1; i >= 0; --i) {
                ba[posDst + i] = ba[posSrc + i];
            }
        }
    }

    public static void removeBits(long[] ba, int start, int nBits) {
        if (nBits == 0 || start + nBits >= ba.length * 64) {
            return;
        }
        int posSrc = start + nBits;
        int posDst = start;
        int len = ba.length - posSrc;
        if (len > 16) {
            System.arraycopy(ba, posSrc, ba, posDst, len);
        } else {
            for (int i = 0; i < len; ++i) {
                ba[posDst + i] = ba[posSrc + i];
            }
        }
    }

    public static void copyBitsLeft64(long[] src, int posSrc, long[] trg, int posTrg, int nBits) {
        if (nBits == 0) {
            return;
        }
        if (nBits >= 16) {
            System.arraycopy(src, posSrc, trg, posTrg, nBits);
        } else {
            for (int i = 0; i < nBits; ++i) {
                trg[posTrg + i] = src[posSrc + i];
            }
        }
    }

    public static boolean getBit(long[] ba, int posBit) {
        int pA = posBit >>> 6;
        return (ba[pA] & Long.MIN_VALUE >>> (posBit &= 0x3F)) != 0L;
    }

    public static void setBit(long[] ba, int posBit, boolean b) {
        int pA = posBit >>> 6;
        posBit &= 0x3F;
        if (b) {
            int n = pA;
            ba[n] = ba[n] | Long.MIN_VALUE >>> posBit;
        } else {
            int n = pA;
            ba[n] = ba[n] & (Long.MIN_VALUE >>> posBit ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static int binarySearch(long[] ba, int startBit, int nEntries, long key, int keyWidth, int valueWidth) {
        int entryWidth = keyWidth + valueWidth;
        int min2 = 0;
        int max = nEntries - 1;
        while (min2 <= max) {
            int mid = min2 + max >>> 1;
            long midKey = ba[mid * entryWidth + startBit];
            if (midKey < key) {
                min2 = mid + 1;
                continue;
            }
            if (midKey > key) {
                max = mid - 1;
                continue;
            }
            return mid;
        }
        return -(min2 + 1);
    }

    public static int binarySearch(long[] ba, int startBit, int nEntries, long key) {
        int min2 = 0;
        int max = nEntries - 1;
        while (min2 <= max) {
            int mid = min2 + max >>> 1;
            long midKey = ba[mid + startBit];
            if (midKey < key) {
                min2 = mid + 1;
                continue;
            }
            if (midKey > key) {
                max = mid - 1;
                continue;
            }
            return mid;
        }
        return -(min2 + 1);
    }

    public static int calcArraySize(int nBits) {
        return nBits;
    }

    public static long[] arrayExpand(long[] oldA, int newSizeBits) {
        long[] newA = new long[BitsLongAligned.calcArraySize(newSizeBits)];
        BitsLongAligned.copyBitsLeft64(oldA, 0, newA, 0, oldA.length);
        return newA;
    }

    public static long[] arrayCreate(int nBits) {
        long[] newA = new long[BitsLongAligned.calcArraySize(nBits)];
        return newA;
    }

    public static long[] arrayEnsureSize(long[] oldA, int requiredBits) {
        if (BitsLongAligned.isCapacitySufficient(oldA, requiredBits)) {
            return oldA;
        }
        return BitsLongAligned.arrayExpand(oldA, requiredBits);
    }

    public static boolean isCapacitySufficient(long[] a, int requiredBits) {
        return a.length >= requiredBits;
    }

    public static long[] arrayTrim(long[] oldA, int requiredBits) {
        int reqSize = BitsLongAligned.calcArraySize(requiredBits);
        if (oldA.length == reqSize) {
            return oldA;
        }
        long[] newA = new long[reqSize];
        BitsLongAligned.copyBitsLeft64(oldA, 0, newA, 0, reqSize);
        return newA;
    }

    public static int arraySizeInByte(long[] ba) {
        return ba.length * 8;
    }

    public static int arraySizeInByte(int arrayLength) {
        return arrayLength * 8;
    }

    public static String toBinary(long l) {
        return BitsLongAligned.toBinary(l, 64);
    }

    public static String toBinary(long l, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DEPTH; ++i) {
            long mask = 1L << (int)((long)(DEPTH - i - 1));
            if ((l & mask) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if ((i + 1) % 8 == 0 && i + 1 < DEPTH) {
                sb.append('.');
            }
            mask >>>= 1;
        }
        return sb.toString();
    }

    public static String toBinary(long[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (long l : la) {
            sb.append(BitsLongAligned.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(int[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        int[] nArray = la;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray[i];
            sb.append(BitsLongAligned.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(long[] ba) {
        StringBuilder sb = new StringBuilder();
        for (long l : ba) {
            sb.append(BitsLongAligned.toBinary(l, 64));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getStats() {
        return "Array create: " + Bits.statACreate + "  exp:" + Bits.statAExpand + "  trm:" + Bits.statATrim + "  oldRS:" + Bits.statOldRightShift + " / " + Bits.statOldRightShiftTime;
    }
}

