/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.nv;

import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.nv.PhTreeNV;
import ch.ethz.globis.phtree.nv.PhTreeVProxy;
import ch.ethz.globis.phtree.pre.PreProcessorRangeF;
import ch.ethz.globis.phtree.util.PhMapperK;
import ch.ethz.globis.phtree.util.PhMapperKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PhTreeNVSolidF
implements Iterable<PHREntry> {
    private final int DIM;
    private final PhTreeNV pht;
    private final PreProcessorRangeF pre;
    private final double[] MIN;
    private final double[] MAX;

    public PhTreeNVSolidF(int dim) {
        this(PhTreeNV.create(dim * 2));
    }

    public PhTreeNVSolidF(PhTreeNV tree) {
        this(tree, new PreProcessorRangeF.IEEE(tree.getDIM()));
    }

    public PhTreeNVSolidF(PhTreeNV tree, PreProcessorRangeF preprocessor) {
        this.DIM = tree.getDIM() / 2;
        if (this.DIM * 2 != tree.getDIM()) {
            throw new IllegalArgumentException("The backing tree's DIM must be a multiple of 2");
        }
        this.pht = tree;
        this.pre = preprocessor;
        this.MIN = new double[this.DIM];
        Arrays.fill(this.MIN, Double.NEGATIVE_INFINITY);
        this.MAX = new double[this.DIM];
        Arrays.fill(this.MAX, Double.POSITIVE_INFINITY);
    }

    public boolean insert(double[] lower, double[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.insert(lVal);
    }

    public boolean delete(double[] lower, double[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.delete(lVal);
    }

    public boolean contains(double[] lower, double[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.contains(lVal);
    }

    public boolean insert(PHREntry e) {
        return this.insert(e.lower(), e.upper());
    }

    public boolean delete(PHREntry e) {
        return this.delete(e.lower(), e.upper());
    }

    public boolean contains(PHREntry e) {
        return this.contains(e.lower(), e.upper());
    }

    public PHREntryIterator queryInclude(PHREntry e) {
        return this.queryInclude(e.lower(), e.upper());
    }

    public PHREntryIterator queryIntersect(PHREntry e) {
        return this.queryIntersect(e.lower(), e.upper());
    }

    public PHREntryIterator queryInclude(double[] lower, double[] upper) {
        long[] lUpp = new long[lower.length << 1];
        long[] lLow = new long[lower.length << 1];
        this.pre.pre(lower, lower, lLow);
        this.pre.pre(upper, upper, lUpp);
        return new PHREntryIterator(this.pht.query(lLow, lUpp), this.DIM);
    }

    public PHREntryIterator queryIntersect(double[] lower, double[] upper) {
        long[] lUpp = new long[lower.length << 1];
        long[] lLow = new long[lower.length << 1];
        this.pre.pre(this.MIN, lower, lLow);
        this.pre.pre(upper, this.MAX, lUpp);
        return new PHREntryIterator(this.pht.query(lLow, lUpp), this.DIM);
    }

    @Override
    public Iterator<PHREntry> iterator() {
        return new PHREntryIteratorI(this.pht.queryExtent(), this.DIM);
    }

    public PhTreeNV getInternalTree() {
        return this.pht;
    }

    public boolean update(double[] lo1, double[] up1, double[] lo2, double[] up2) {
        long[] pOld = new long[lo1.length << 1];
        long[] pNew = new long[lo1.length << 1];
        this.pre.pre(lo1, up1, pOld);
        this.pre.pre(lo2, up2, pNew);
        return this.pht.update(pOld, pNew);
    }

    public List<PHREntry> queryIntersectAll(double[] lower, double[] upper) {
        return this.queryIntersectAll(lower, upper, Integer.MAX_VALUE, null, point -> new PHREntry(PhMapperK.toDouble(point)));
    }

    public <R> List<R> queryIntersectAll(double[] lower, double[] upper, int maxResults, PhFilter filter, PhMapperKey<R> mapper) {
        long[] lUpp = new long[lower.length << 1];
        long[] lLow = new long[lower.length << 1];
        this.pre.pre(this.MIN, lower, lLow);
        this.pre.pre(upper, this.MAX, lUpp);
        return ((PhTreeVProxy)this.pht).queryAll(lLow, lUpp, maxResults, filter, mapper);
    }

    public int size() {
        return this.pht.size();
    }

    public class PHREntryIteratorI
    implements Iterator<PHREntry> {
        private final Iterator<long[]> iter;
        private final int dims;

        private PHREntryIteratorI(Iterator<long[]> iter, int DIM) {
            this.iter = iter;
            this.dims = DIM;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PHREntry next() {
            double[] lower = new double[this.dims];
            double[] upper = new double[this.dims];
            PhTreeNVSolidF.this.pre.post(this.iter.next(), lower, upper);
            return new PHREntry(lower, upper);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    public static class PHREntry {
        private final double[] lower;
        private final double[] upper;

        public PHREntry(double[] lower, double[] upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public PHREntry(double[] point) {
            int dim = point.length >> 1;
            this.lower = new double[dim];
            this.upper = new double[dim];
            System.arraycopy(point, 0, this.lower, 0, dim);
            System.arraycopy(point, dim, this.upper, 0, dim);
        }

        public double[] lower() {
            return this.lower;
        }

        public double[] upper() {
            return this.upper;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PHREntry)) {
                return false;
            }
            PHREntry e = (PHREntry)obj;
            return Arrays.equals(this.lower, e.lower) && Arrays.equals(this.upper, e.upper);
        }

        public int hashCode() {
            return Arrays.hashCode(this.lower) ^ Arrays.hashCode(this.upper);
        }

        public String toString() {
            return "{" + Arrays.toString(this.lower) + "," + Arrays.toString(this.upper) + "}";
        }
    }

    public class PHREntryIterator
    implements Iterator<PHREntry> {
        private final PhTreeNV.PhIteratorNV iter;
        private final int DIM;

        private PHREntryIterator(PhTreeNV.PhIteratorNV iter, int DIM) {
            this.iter = iter;
            this.DIM = DIM;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNextKey();
        }

        @Override
        public PHREntry next() {
            double[] lower = new double[this.DIM];
            double[] upper = new double[this.DIM];
            PhTreeNVSolidF.this.pre.post(this.iter.nextKey(), lower, upper);
            return new PHREntry(lower, upper);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

