/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhDistanceF;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.pre.PreProcessorPointF;
import ch.ethz.globis.phtree.util.PhIteratorBase;
import ch.ethz.globis.phtree.util.PhMapper;
import ch.ethz.globis.phtree.util.PhMapperK;
import ch.ethz.globis.phtree.util.PhTreeStats;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PhTreeF<T> {
    private final PhTree<T> pht;
    private final PreProcessorPointF pre;

    protected PhTreeF(int dim, PreProcessorPointF pre) {
        this.pht = PhTree.create(dim);
        this.pre = pre;
    }

    protected PhTreeF(PhTree<T> tree) {
        this.pht = tree;
        this.pre = new PreProcessorPointF.IEEE();
    }

    public static <T> PhTreeF<T> create(int dim) {
        return new PhTreeF<T>(dim, new PreProcessorPointF.IEEE());
    }

    public static <T> PhTreeF<T> create(int dim, PreProcessorPointF pre) {
        return new PhTreeF<T>(dim, pre);
    }

    public static <T> PhTreeF<T> wrap(PhTree<T> tree) {
        return new PhTreeF<T>(tree);
    }

    public int size() {
        return this.pht.size();
    }

    public T put(double[] key, T value) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return this.pht.put(lKey, value);
    }

    public boolean contains(double ... key) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return this.pht.contains(lKey);
    }

    public T get(double ... key) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return this.pht.get(lKey);
    }

    public T remove(double ... key) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return this.pht.remove(lKey);
    }

    public PhExtentF<T> queryExtent() {
        return new PhExtentF<T>(this.pht.queryExtent(), this.pht.getDim(), this.pre);
    }

    public PhQueryF<T> query(double[] min2, double[] max) {
        long[] lMin = new long[min2.length];
        long[] lMax = new long[max.length];
        this.pre.pre(min2, lMin);
        this.pre.pre(max, lMax);
        return new PhQueryF<T>(this.pht.query(lMin, lMax), this.pht.getDim(), this.pre);
    }

    public PhRangeQueryF<T> rangeQuery(double dist, double ... center) {
        return this.rangeQuery(dist, PhDistanceF.THIS, center);
    }

    public PhRangeQueryF<T> rangeQuery(double dist, PhDistance optionalDist, double ... center) {
        if (optionalDist == null) {
            optionalDist = PhDistanceF.THIS;
        }
        long[] lKey = new long[center.length];
        this.pre.pre(center, lKey);
        PhRangeQuery<T> iter = this.pht.rangeQuery(dist, optionalDist, lKey);
        return new PhRangeQueryF<T>(iter, this.pht, this.pre);
    }

    public int getDim() {
        return this.pht.getDim();
    }

    public PhKnnQueryF<T> nearestNeighbour(int nMin, double ... key) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        PhTree.PhKnnQuery<T> iter = this.pht.nearestNeighbour(nMin, PhDistanceF.THIS, null, lKey);
        return new PhKnnQueryF<T>(iter, this.pht.getDim(), this.pre);
    }

    public PhKnnQueryF<T> nearestNeighbour(int nMin, PhDistance dist, double ... key) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        PhTree.PhKnnQuery<T> iter = this.pht.nearestNeighbour(nMin, dist, null, lKey);
        return new PhKnnQueryF<T>(iter, this.pht.getDim(), this.pre);
    }

    public T update(double[] oldKey, double[] newKey) {
        long[] oldL = new long[oldKey.length];
        long[] newL = new long[newKey.length];
        this.pre.pre(oldKey, oldL);
        this.pre.pre(newKey, newL);
        return this.pht.update(oldL, newL);
    }

    public List<PhEntryF<T>> queryAll(double[] min2, double[] max) {
        return this.queryAll(min2, max, Integer.MAX_VALUE, null, e -> new PhEntryF(PhMapperK.toDouble(e.getKey()), e.getValue()));
    }

    public <R> List<R> queryAll(double[] min2, double[] max, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        long[] lUpp = new long[min2.length];
        long[] lLow = new long[max.length];
        this.pre.pre(min2, lLow);
        this.pre.pre(max, lUpp);
        return this.pht.queryAll(lLow, lUpp, maxResults, filter, mapper);
    }

    public void clear() {
        this.pht.clear();
    }

    public PhTree<T> getInternalTree() {
        return this.pht;
    }

    public PreProcessorPointF getPreprocessor() {
        return this.pre;
    }

    public String toStringTree() {
        return this.pht.toStringTree();
    }

    public String toString() {
        return this.pht.toString();
    }

    public PhTreeStats getStats() {
        return this.pht.getStats();
    }

    public T getOrDefault(double[] key, T defaultValue) {
        T t = this.get(key);
        return t == null ? defaultValue : t;
    }

    public T putIfAbsent(double[] key, T value) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return this.pht.putIfAbsent(lKey, value);
    }

    public boolean remove(double[] key, T value) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return this.pht.remove(lKey, value);
    }

    public boolean replace(double[] key, T oldValue, T newValue) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return this.pht.replace(lKey, oldValue, newValue);
    }

    public T replace(double[] key, T value) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return this.pht.replace(lKey, value);
    }

    public T computeIfAbsent(double[] key, Function<double[], ? extends T> mappingFunction) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return (T)this.pht.computeIfAbsent(lKey, (long[] longs) -> mappingFunction.apply(key));
    }

    public T computeIfPresent(double[] key, BiFunction<double[], ? super T, ? extends T> remappingFunction) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return (T)this.pht.computeIfPresent(lKey, (long[] longs, ? super T t) -> remappingFunction.apply(key, (Object)t));
    }

    public T compute(double[] key, BiFunction<double[], ? super T, ? extends T> remappingFunction) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return (T)this.pht.compute(lKey, (long[] longs, ? super T t) -> remappingFunction.apply(key, (Object)t));
    }

    public static class PhEntryDistF<T>
    extends PhEntryF<T> {
        private double dist;

        public PhEntryDistF(double[] key, T value, double dist) {
            super(key, value);
            this.dist = dist;
        }

        public void set(T value, double dist) {
            this.value = value;
            this.dist = dist;
        }

        public double dist() {
            return this.dist;
        }
    }

    public static class PhEntryF<T> {
        protected double[] key;
        protected T value;

        public PhEntryF(double[] key, T value) {
            this.key = key;
            this.value = value;
        }

        public double[] getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }

    public static class PhRangeQueryF<T>
    extends PhIteratorF<T> {
        private final long[] lCenter;
        private final PhRangeQuery<T> q;
        private final int dims;

        protected PhRangeQueryF(PhRangeQuery<T> iter, PhTree<T> tree, PreProcessorPointF pre) {
            super(iter, tree.getDim(), pre);
            this.dims = tree.getDim();
            this.q = iter;
            this.lCenter = new long[this.dims];
        }

        public PhRangeQueryF<T> reset(double range, double ... center) {
            this.pre.pre(center, this.lCenter);
            this.q.reset(range, this.lCenter);
            return this;
        }
    }

    public static class PhKnnQueryF<T>
    extends PhIteratorF<T> {
        private final long[] lCenter;
        private final PhTree.PhKnnQuery<T> q;
        private final PhEntryDistF<T> buffer;
        private final int dims;

        protected PhKnnQueryF(PhTree.PhKnnQuery<T> iter, int dims, PreProcessorPointF pre) {
            super(iter, dims, pre);
            this.dims = dims;
            this.q = iter;
            this.lCenter = new long[dims];
            this.buffer = new PhEntryDistF<Object>(new double[dims], null, Double.NaN);
        }

        @Override
        public PhEntryDistF<T> nextEntry() {
            double[] d = new double[this.dims];
            PhEntryDist e = (PhEntryDist)this.q.nextEntryReuse();
            this.pre.post(e.getKey(), d);
            return new PhEntryDistF(d, e.getValue(), e.dist());
        }

        @Override
        public PhEntryDistF<T> nextEntryReuse() {
            PhEntryDist e = (PhEntryDist)this.q.nextEntryReuse();
            this.pre.post(e.getKey(), this.buffer.getKey());
            this.buffer.set(e.getValue(), e.dist());
            return this.buffer;
        }

        public PhKnnQueryF<T> reset(int nMin, PhDistance dist, double ... center) {
            this.pre.pre(center, this.lCenter);
            this.q.reset(nMin, dist, this.lCenter);
            return this;
        }
    }

    public static class PhQueryF<T>
    extends PhIteratorF<T> {
        private final long[] lMin;
        private final long[] lMax;
        private final PhTree.PhQuery<T> q;

        protected PhQueryF(PhTree.PhQuery<T> iter, int dims, PreProcessorPointF pre) {
            super(iter, dims, pre);
            this.q = iter;
            this.lMin = new long[dims];
            this.lMax = new long[dims];
        }

        public void reset(double[] lower, double[] upper) {
            this.pre.pre(lower, this.lMin);
            this.pre.pre(upper, this.lMax);
            this.q.reset(this.lMin, this.lMax);
        }
    }

    public static class PhExtentF<T>
    extends PhIteratorF<T> {
        private final PhTree.PhExtent<T> iter;

        protected PhExtentF(PhTree.PhExtent<T> iter, int dims, PreProcessorPointF pre) {
            super(iter, dims, pre);
            this.iter = iter;
        }

        public PhExtentF<T> reset() {
            this.iter.reset();
            return this;
        }
    }

    public static class PhIteratorF<T>
    implements PhIteratorBase<T, PhEntryF<T>> {
        private final PhIteratorBase<T, ? extends PhEntry<T>> iter;
        protected final PreProcessorPointF pre;
        private final int dims;
        private final PhEntryF<T> buffer;

        protected PhIteratorF(PhIteratorBase<T, ? extends PhEntry<T>> iter, int dims, PreProcessorPointF pre) {
            this.iter = iter;
            this.pre = pre;
            this.dims = dims;
            this.buffer = new PhEntryF<Object>(new double[dims], null);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        @Override
        public PhEntryF<T> nextEntry() {
            double[] d = new double[this.dims];
            PhEntry<T> e = this.iter.nextEntryReuse();
            this.pre.post(e.getKey(), d);
            return new PhEntryF<T>(d, e.getValue());
        }

        @Override
        public PhEntryF<T> nextEntryReuse() {
            PhEntry<T> e = this.iter.nextEntryReuse();
            this.pre.post(e.getKey(), this.buffer.getKey());
            this.buffer.setValue(e.getValue());
            return this.buffer;
        }

        public double[] nextKey() {
            double[] d = new double[this.dims];
            this.pre.post(this.iter.nextEntryReuse().getKey(), d);
            return d;
        }

        @Override
        public T nextValue() {
            return this.iter.nextValue();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

