/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.geojson;

import java.io.Serializable;
import org.apache.sedona.common.Constructors;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class GeoJSONUtils$ {
    public static final GeoJSONUtils$ MODULE$ = new GeoJSONUtils$();

    public StructType updateGeometrySchema(StructType schema, DataType datatype) {
        return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String string = structField.name();
                boolean nullable = structField.nullable();
                Metadata metadata = structField.metadata();
                if ("geometry".equals(string)) {
                    return new StructField("geometry", datatype, nullable, metadata);
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType dataType = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata metadata = structField.metadata();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    return new StructField(name, (DataType)MODULE$.updateGeometrySchema(structType, datatype), nullable, metadata);
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType dataType = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata metadata = structField.metadata();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    boolean containsNull = arrayType.containsNull();
                    if (elementType instanceof StructType) {
                        StructType structType = (StructType)elementType;
                        StructType updatedElementType = MODULE$.updateGeometrySchema(structType, datatype);
                        return new StructField(name, (DataType)new ArrayType((DataType)updatedElementType, containsNull), nullable, metadata);
                    }
                }
            }
            return structField;
        }, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public byte[] geoJsonToGeometry(String geoJson) {
        Geometry geometry = Constructors.geomFromText((String)geoJson, (FileDataSplitter)FileDataSplitter.GEOJSON);
        return GeometryUDT$.MODULE$.serialize(geometry);
    }

    public String geometryToGeoJson(byte[] geometryBinary) {
        Geometry geometry = GeometryUDT$.MODULE$.deserialize(geometryBinary);
        return Functions.asGeoJson((Geometry)geometry);
    }

    public ArrayData handleArray(InternalRow row, int index, DataType elementType, boolean toGeometry) {
        ArrayData arrayData = row.getArray(index);
        if (arrayData == null || arrayData.numElements() == 0) {
            return new GenericArrayData((Seq)package$.MODULE$.Seq().empty());
        }
        DataType dataType = elementType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            IndexedSeq convertedArray = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), arrayData.numElements()).map((Function1 & Serializable)i -> GeoJSONUtils$.$anonfun$handleArray$1(arrayData, structType, toGeometry, BoxesRunTime.unboxToInt((Object)i)));
            return new GenericArrayData((Seq)convertedArray);
        }
        return arrayData;
    }

    public InternalRow convertGeometryToGeoJson(InternalRow row, StructType schema) {
        Object[] newValues = new Object[schema.fields().length];
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))), (Function1 & Serializable)x0$1 -> {
            GeoJSONUtils$.$anonfun$convertGeometryToGeoJson$1(row, newValues, schema, x0$1);
            return BoxedUnit.UNIT;
        });
        return InternalRow$.MODULE$.fromSeq((scala.collection.immutable.Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)newValues));
    }

    public InternalRow convertGeoJsonToGeometry(InternalRow row, StructType schema) {
        Object[] newValues = new Object[schema.fields().length];
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))), (Function1 & Serializable)x0$1 -> {
            GeoJSONUtils$.$anonfun$convertGeoJsonToGeometry$1(row, newValues, schema, x0$1);
            return BoxedUnit.UNIT;
        });
        return InternalRow$.MODULE$.fromSeq((scala.collection.immutable.Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)newValues));
    }

    public static final /* synthetic */ InternalRow $anonfun$handleArray$1(ArrayData arrayData$1, StructType x2$1, boolean toGeometry$1, int i) {
        if (!arrayData$1.isNullAt(i)) {
            InternalRow innerRow = arrayData$1.getStruct(i, x2$1.fields().length);
            if (toGeometry$1) {
                return MODULE$.convertGeoJsonToGeometry(innerRow, x2$1);
            }
            return MODULE$.convertGeometryToGeoJson(innerRow, x2$1);
        }
        return null;
    }

    public static final /* synthetic */ void $anonfun$convertGeometryToGeoJson$1(InternalRow row$1, Object[] newValues$1, StructType schema$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string;
            StructField structField = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (structField != null && "geometry".equals(string = structField.name()) && structField.dataType() instanceof GeometryUDT) {
                byte[] geometryBinary = row$1.getBinary(index);
                newValues$1[index] = UTF8String.fromString((String)MODULE$.geometryToGeoJson(geometryBinary));
                return;
            }
        }
        if (tuple2 != null) {
            DataType structType;
            StructField structField = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (structField != null && (structType = structField.dataType()) instanceof StructType) {
                StructType structType2 = (StructType)structType;
                InternalRow nestedRow = row$1.getStruct(index, structType2.fields().length);
                newValues$1[index] = MODULE$.convertGeometryToGeoJson(nestedRow, structType2);
                return;
            }
        }
        if (tuple2 != null) {
            DataType arrayType;
            StructField structField = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (structField != null && (arrayType = structField.dataType()) instanceof ArrayType) {
                ArrayType arrayType2 = (ArrayType)arrayType;
                newValues$1[index] = MODULE$.handleArray(row$1, index, arrayType2.elementType(), false);
                return;
            }
        }
        if (tuple2 != null) {
            int index = tuple2._2$mcI$sp();
            newValues$1[index] = row$1.get(index, schema$1.fields()[index].dataType());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$convertGeoJsonToGeometry$1(InternalRow row$2, Object[] newValues$2, StructType schema$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField structField = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (structField != null) {
                String string = structField.name();
                DataType dataType = structField.dataType();
                if ("geometry".equals(string) && StringType$.MODULE$.equals(dataType)) {
                    String geometryGeoJson = row$2.getString(index);
                    newValues$2[index] = MODULE$.geoJsonToGeometry(geometryGeoJson);
                    return;
                }
            }
        }
        if (tuple2 != null) {
            DataType structType;
            StructField structField = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (structField != null && (structType = structField.dataType()) instanceof StructType) {
                StructType structType2 = (StructType)structType;
                InternalRow nestedRow = row$2.getStruct(index, structType2.fields().length);
                newValues$2[index] = MODULE$.convertGeoJsonToGeometry(nestedRow, structType2);
                return;
            }
        }
        if (tuple2 != null) {
            DataType arrayType;
            StructField structField = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (structField != null && (arrayType = structField.dataType()) instanceof ArrayType) {
                ArrayType arrayType2 = (ArrayType)arrayType;
                newValues$2[index] = MODULE$.handleArray(row$2, index, arrayType2.elementType(), true);
                return;
            }
        }
        if (tuple2 != null) {
            int index = tuple2._2$mcI$sp();
            newValues$2[index] = row$2.get(index, schema$2.fields()[index].dataType());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private GeoJSONUtils$() {
    }
}

