/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.utils;

import org.apache.sedona.viz.utils.RasterizationUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class Pixel
extends Point {
    private final int resolutionX;
    private final int resolutionY;
    private boolean isDuplicate = false;
    private int currentPartitionId = -1;

    public Pixel(double x, double y, int resolutionX, int resolutionY, boolean isDuplicate, int currentPartitionId) {
        super(new Coordinate(x, y), new PrecisionModel(), Integer.parseInt("0"));
        this.resolutionX = resolutionX;
        this.resolutionY = resolutionY;
        this.isDuplicate = isDuplicate;
        this.currentPartitionId = currentPartitionId;
    }

    public Pixel(double x, double y, int resolutionX, int resolutionY) {
        super(new Coordinate(x, y), new PrecisionModel(), Integer.parseInt("0"));
        this.resolutionX = resolutionX;
        this.resolutionY = resolutionY;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.isDuplicate = duplicate;
    }

    public int getCurrentPartitionId() {
        return this.currentPartitionId;
    }

    public void setCurrentPartitionId(int currentPartitionId) {
        this.currentPartitionId = currentPartitionId;
    }

    public int getResolutionX() {
        return this.resolutionX;
    }

    public int getResolutionY() {
        return this.resolutionY;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Pixel)) {
            return false;
        }
        return this.hashCode() == o.hashCode();
    }

    public String toString() {
        return "Pixel(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.resolutionX + ", height=" + this.resolutionY + ", isDuplicate=" + this.isDuplicate + ", tileId=" + this.currentPartitionId + ")";
    }

    public int hashCode() {
        int id = -1;
        try {
            id = RasterizationUtils.Encode2DTo1DId(this.resolutionX, this.resolutionY, (int)this.getX(), (int)this.getY());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }
}

